Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/utils/dataDefinition.es", ['module', 'exports', 'require', './lang.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getOptionLabel = exports.getFieldLabel = exports.getDataDefinitionFieldSet = exports.getDataDefinitionField = exports.containsFieldSet = exports.forEachDataDefinitionField = void 0;

    var _lang = require("./lang.es");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const forEachDataDefinitionField = (dataDefinition = {
      dataDefinitionFields: []
    }, fn) => {
      const {
        dataDefinitionFields = []
      } = dataDefinition;

      for (let i = 0; i < dataDefinitionFields.length; i++) {
        const field = dataDefinitionFields[i];

        if (fn(field)) {
          return true;
        }

        if (forEachDataDefinitionField({
          dataDefinitionFields: field.nestedDataDefinitionFields || []
        }, fn)) {
          return true;
        }
      }

      return false;
    };

    exports.forEachDataDefinitionField = forEachDataDefinitionField;

    const containsFieldSet = (dataDefinition, dataDefinitionId) => {
      let hasFieldSet = false;
      forEachDataDefinitionField(dataDefinition, dataDefinitionField => {
        const {
          customProperties,
          fieldType
        } = dataDefinitionField;

        if (fieldType === 'fieldset' && customProperties && customProperties.ddmStructureId == dataDefinitionId) {
          hasFieldSet = true;
        }

        return hasFieldSet;
      });
      return hasFieldSet;
    };

    exports.containsFieldSet = containsFieldSet;

    const getDataDefinitionField = (dataDefinition = {
      dataDefinitionFields: []
    }, fieldName) => {
      let field = null;
      forEachDataDefinitionField(dataDefinition, currentField => {
        if (currentField.name === fieldName) {
          field = currentField;
          return true;
        }

        return false;
      });
      return field;
    };

    exports.getDataDefinitionField = getDataDefinitionField;

    const getDataDefinitionFieldSet = (dataDefinitionFields, fieldSetId) => dataDefinitionFields.find(({
      customProperties: {
        ddmStructureId
      }
    }) => ddmStructureId == fieldSetId);

    exports.getDataDefinitionFieldSet = getDataDefinitionFieldSet;

    const getFieldLabel = (dataDefinition, fieldName) => {
      const field = getDataDefinitionField(dataDefinition, fieldName);

      if (field) {
        return (0, _lang.getLocalizedValue)(dataDefinition.defaultLanguageId, field.label);
      }

      return fieldName;
    };

    exports.getFieldLabel = getFieldLabel;

    const getOptionLabel = (options = {}, value, defaultLanguageId = themeDisplay.getDefaultLanguageId(), languageId = themeDisplay.getLanguageId()) => {
      const getLabel = languageId => {
        if (options[languageId]) {
          var _options$languageId$f;

          return (_options$languageId$f = options[languageId].find(option => option.value === value)) === null || _options$languageId$f === void 0 ? void 0 : _options$languageId$f.label;
        }
      };

      return getLabel(languageId) || getLabel(defaultLanguageId) || value;
    };

    exports.getOptionLabel = getOptionLabel;
    //# sourceMappingURL=dataDefinition.es.js.map
  }
});
//# sourceMappingURL=dataDefinition.es.js.map