Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/utils/dataLayoutVisitor.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.findField = findField;
    exports.containsField = containsField;
    exports.mapDataLayoutColumns = mapDataLayoutColumns;
    exports.deleteField = deleteField;
    exports.getFieldNameFromIndexes = getFieldNameFromIndexes;
    exports.getIndexesFromFieldName = getIndexesFromFieldName;
    exports.normalizeRule = normalizeRule;
    exports.isDataLayoutEmpty = isDataLayoutEmpty;
    exports.normalizeDataLayoutRows = normalizeDataLayoutRows;

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function findField(dataLayoutPages, fieldName) {
      return (dataLayoutPages || []).find(({
        dataLayoutRows
      }) => {
        return (dataLayoutRows || []).find(({
          dataLayoutColumns
        }) => {
          return (dataLayoutColumns || []).find(({
            fieldNames
          }) => {
            return (fieldNames || []).find(name => name === fieldName);
          });
        });
      });
    }

    function containsField(dataLayoutPages, fieldName) {
      return !!findField(dataLayoutPages, fieldName);
    }

    function mapDataLayoutColumns(dataLayoutPages, fn = () => {}) {
      return (dataLayoutPages || []).map((_ref, pageIndex) => {
        let {
          dataLayoutRows
        } = _ref,
            dataLayoutPage = _objectWithoutProperties(_ref, ["dataLayoutRows"]);

        return _objectSpread(_objectSpread({}, dataLayoutPage), {}, {
          dataLayoutRows: (dataLayoutRows || []).map((_ref2, rowIndex) => {
            let {
              dataLayoutColumns
            } = _ref2,
                dataLayoutRow = _objectWithoutProperties(_ref2, ["dataLayoutColumns"]);

            return _objectSpread(_objectSpread({}, dataLayoutRow), {}, {
              dataLayoutColumns: dataLayoutColumns.map((dataLayoutColumn, columnIndex) => fn(dataLayoutColumn, columnIndex, rowIndex, pageIndex))
            });
          })
        });
      });
    }

    function deleteField(dataLayoutPages, fieldName) {
      return mapDataLayoutColumns(dataLayoutPages, _ref3 => {
        let {
          fieldNames
        } = _ref3,
            dataLayoutColumn = _objectWithoutProperties(_ref3, ["fieldNames"]);

        return _objectSpread(_objectSpread({}, dataLayoutColumn), {}, {
          fieldNames: (fieldNames || []).filter(name => name !== fieldName)
        });
      });
    }

    function getFieldNameFromIndexes({
      dataLayoutPages
    }, {
      columnIndex,
      fieldIndex = 0,
      pageIndex,
      rowIndex
    }) {
      return dataLayoutPages[pageIndex].dataLayoutRows[rowIndex].dataLayoutColumns[columnIndex].fieldNames[fieldIndex];
    }

    function getIndexesFromFieldName({
      dataLayoutPages
    }, fieldName) {
      let indexes = {};
      dataLayoutPages.some(({
        dataLayoutRows
      }, pageIndex) => {
        return dataLayoutRows.some(({
          dataLayoutColumns
        }, rowIndex) => {
          return dataLayoutColumns.some(({
            fieldNames = []
          }, columnIndex) => {
            return fieldNames.some(name => {
              if (name === fieldName) {
                indexes = {
                  columnIndex,
                  pageIndex,
                  rowIndex
                };
                return true;
              }

              return false;
            });
          });
        });
      });
      return indexes;
    }

    function normalizeRule(dataRule) {
      if (Object.prototype.hasOwnProperty.call(dataRule, 'logical-operator')) {
        dataRule['logicalOperator'] = dataRule['logical-operator'];
        delete dataRule['logical-operator'];
      }

      dataRule = _objectSpread(_objectSpread({}, dataRule), {}, {
        name: {
          en_US: dataRule.name
        }
      });
      return dataRule;
    }

    function isDataLayoutEmpty(dataLayoutPages) {
      return dataLayoutPages.every(({
        dataLayoutRows
      }) => {
        return dataLayoutRows.every(({
          dataLayoutColumns
        }) => {
          return dataLayoutColumns.every(({
            fieldNames = []
          }) => {
            return !fieldNames.length;
          });
        });
      });
    }

    function normalizeDataLayoutRows(dataLayoutPages) {
      return dataLayoutPages[0].dataLayoutRows.map(({
        dataLayoutColumns
      }) => {
        return {
          columns: dataLayoutColumns.map(({
            columnSize: size,
            fieldNames: fields
          }) => ({
            fields,
            size
          }))
        };
      });
    }
    //# sourceMappingURL=dataLayoutVisitor.es.js.map
  }
});
//# sourceMappingURL=dataLayoutVisitor.es.js.map