Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/utils/generateDataDefinitionFieldName.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const findFieldByName = (dataDefinitionFields, fieldName) => {
      let result;

      const traverse = dataDefinitionFields => dataDefinitionFields.forEach(dataDefinition => {
        const {
          name,
          nestedDataDefinitionFields = []
        } = dataDefinition;

        if (name === fieldName) {
          result = dataDefinition;
          return;
        }

        traverse(nestedDataDefinitionFields);
      });

      traverse(dataDefinitionFields);
      return result;
    };

    var _default = (dataDefinitionFields, desiredName, currentName = null, blacklist = []) => {
      let counter = 0;
      let name = (0, _dynamicDataMappingFormRenderer.normalizeFieldName)(desiredName);
      let existingField;

      while ((existingField = findFieldByName(dataDefinitionFields, name)) && existingField && existingField.name !== currentName || blacklist.includes(name)) {
        name = (0, _dynamicDataMappingFormRenderer.normalizeFieldName)("".concat(desiredName).concat(++counter));
      }

      return name;
    };

    exports.default = _default;
    //# sourceMappingURL=generateDataDefinitionFieldName.es.js.map
  }
});
//# sourceMappingURL=generateDataDefinitionFieldName.es.js.map