Liferay.Loader.define("data-engine-taglib@2.5.34/data_layout_builder/js/utils/settingsForm.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getFilteredSettingsContext = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    const getPredefinedValues = ({
      locale,
      localizedValue,
      options
    }) => {
      if (Array.isArray(localizedValue[locale])) {
        return localizedValue[locale].filter(value => {
          if (options.find(option => value === option.value)) {
            return value;
          }
        });
      }

      return localizedValue[locale];
    };

    const getFilteredSettingsContext = ({
      config,
      editingLanguageId,
      fieldType,
      settingsContext
    }) => {
      const defaultLanguageId = themeDisplay.getDefaultLanguageId();
      const unsupportedTabs = [...config.disabledTabs];
      const pages = settingsContext.pages.filter(page => !unsupportedTabs.includes(page.title));
      const visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      const unsupportedRepeatableFieldset = fieldType === 'fieldset' ? ['repeatable'] : [];
      const unsupportedProperties = [...config.unimplementedProperties, ...config.disabledProperties, ...unsupportedRepeatableFieldset];
      return _objectSpread(_objectSpread({}, settingsContext), {}, {
        pages: visitor.mapColumns(column => {
          return _objectSpread(_objectSpread({}, column), {}, {
            fields: column.fields.map(field => {
              const {
                fieldName,
                name
              } = field;

              const updatedField = _objectSpread(_objectSpread({}, field), {}, {
                defaultLanguageId,
                editingLanguageId
              });

              if (unsupportedProperties.includes(fieldName)) {
                return _objectSpread(_objectSpread({}, updatedField), {}, {
                  name: (0, _dynamicDataMappingFormRenderer.generateName)(name, updatedField),
                  visibilityExpression: 'FALSE',
                  visible: false
                });
              }

              if (fieldName === 'dataSourceType') {
                return _objectSpread(_objectSpread({}, updatedField), {}, {
                  name: (0, _dynamicDataMappingFormRenderer.generateName)(name, updatedField),
                  predefinedValue: '["manual"]',
                  readOnly: true,
                  visible: false
                });
              }

              if (fieldName === 'name') {
                return _objectSpread(_objectSpread({}, updatedField), {}, {
                  readOnly: true
                });
              }

              if (fieldName === 'predefinedValue') {
                field.localizedValue[field.locale] = getPredefinedValues(field);
              }

              if (fieldName === 'repeatable') {
                return _objectSpread(_objectSpread({}, updatedField), {}, {
                  name: (0, _dynamicDataMappingFormRenderer.generateName)(name, updatedField),
                  showMaximumRepetitionsInfo: false
                });
              }

              return _objectSpread(_objectSpread({}, updatedField), {}, {
                name: (0, _dynamicDataMappingFormRenderer.generateName)(name, updatedField)
              });
            })
          });
        })
      });
    };

    exports.getFilteredSettingsContext = getFilteredSettingsContext;
    //# sourceMappingURL=settingsForm.es.js.map
  }
});
//# sourceMappingURL=settingsForm.es.js.map