Liferay.Loader.define('data-engine-taglib$lodash-es@4.17.15/_isIterateeCall', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import eq from './eq.js';
    import isArrayLike from './isArrayLike.js';
    import isIndex from './_isIndex.js';
    import isObject from './isObject.js';

    /**
     * Checks if the given arguments are from an iteratee call.
     *
     * @private
     * @param {*} value The potential iteratee value argument.
     * @param {*} index The potential iteratee index or key argument.
     * @param {*} object The potential iteratee object argument.
     * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
     *  else `false`.
     */
    function isIterateeCall(value, index, object) {
      if (!isObject(object)) {
        return false;
      }
      var type = typeof index;
      if (type == 'number' ? isArrayLike(object) && isIndex(index, object.length) : type == 'string' && index in object) {
        return eq(object[index], value);
      }
      return false;
    }

    export default isIterateeCall;
  }
});
//# sourceMappingURL=_isIterateeCall.js.map