Liferay.Loader.define('data-engine-taglib$lodash-es@4.17.15/_setWrapToString', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import getWrapDetails from './_getWrapDetails.js';
    import insertWrapDetails from './_insertWrapDetails.js';
    import setToString from './_setToString.js';
    import updateWrapDetails from './_updateWrapDetails.js';

    /**
     * Sets the `toString` method of `wrapper` to mimic the source of `reference`
     * with wrapper details in a comment at the top of the source body.
     *
     * @private
     * @param {Function} wrapper The function to modify.
     * @param {Function} reference The reference function.
     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
     * @returns {Function} Returns `wrapper`.
     */
    function setWrapToString(wrapper, reference, bitmask) {
      var source = reference + '';
      return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
    }

    export default setWrapToString;
  }
});
//# sourceMappingURL=_setWrapToString.js.map