Liferay.Loader.define('data-engine-taglib$lodash-es@4.17.15/toPath', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import arrayMap from './_arrayMap.js';
    import copyArray from './_copyArray.js';
    import isArray from './isArray.js';
    import isSymbol from './isSymbol.js';
    import stringToPath from './_stringToPath.js';
    import toKey from './_toKey.js';
    import toString from './toString.js';

    /**
     * Converts `value` to a property path array.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {*} value The value to convert.
     * @returns {Array} Returns the new property path array.
     * @example
     *
     * _.toPath('a.b.c');
     * // => ['a', 'b', 'c']
     *
     * _.toPath('a[0].b.c');
     * // => ['a', '0', 'b', 'c']
     */
    function toPath(value) {
      if (isArray(value)) {
        return arrayMap(value, toKey);
      }
      return isSymbol(value) ? [value] : copyArray(stringToPath(toString(value)));
    }

    export default toPath;
  }
});
//# sourceMappingURL=toPath.js.map