"use strict";
Liferay.Loader.define("data-engine-taglib$history@4.9.0/cjs/history.min", ['module', 'exports', 'require', 'data-engine-taglib$resolve-pathname', 'data-engine-taglib$value-equal', 'data-engine-taglib$tiny-warning', 'data-engine-taglib$tiny-invariant'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _interopDefault(n) {
      return n && "object" == typeof n && "default" in n ? n.default : n;
    }Object.defineProperty(exports, "__esModule", { value: !0 });var resolvePathname = _interopDefault(require("data-engine-taglib$resolve-pathname")),
        valueEqual = _interopDefault(require("data-engine-taglib$value-equal"));require("data-engine-taglib$tiny-warning");var invariant = _interopDefault(require("data-engine-taglib$tiny-invariant"));function _extends() {
      return (_extends = Object.assign || function (n) {
        for (var t = 1; t < arguments.length; t++) {
          var e = arguments[t];for (var a in e) Object.prototype.hasOwnProperty.call(e, a) && (n[a] = e[a]);
        }return n;
      }).apply(this, arguments);
    }function addLeadingSlash(n) {
      return "/" === n.charAt(0) ? n : "/" + n;
    }function stripLeadingSlash(n) {
      return "/" === n.charAt(0) ? n.substr(1) : n;
    }function hasBasename(n, t) {
      return new RegExp("^" + t + "(\\/|\\?|#|$)", "i").test(n);
    }function stripBasename(n, t) {
      return hasBasename(n, t) ? n.substr(t.length) : n;
    }function stripTrailingSlash(n) {
      return "/" === n.charAt(n.length - 1) ? n.slice(0, -1) : n;
    }function parsePath(n) {
      var t = n || "/",
          e = "",
          a = "",
          o = t.indexOf("#");-1 !== o && (a = t.substr(o), t = t.substr(0, o));var r = t.indexOf("?");return -1 !== r && (e = t.substr(r), t = t.substr(0, r)), { pathname: t, search: "?" === e ? "" : e, hash: "#" === a ? "" : a };
    }function createPath(n) {
      var t = n.pathname,
          e = n.search,
          a = n.hash,
          o = t || "/";return e && "?" !== e && (o += "?" === e.charAt(0) ? e : "?" + e), a && "#" !== a && (o += "#" === a.charAt(0) ? a : "#" + a), o;
    }function createLocation(n, t, e, a) {
      var o;"string" == typeof n ? (o = parsePath(n)).state = t : (void 0 === (o = _extends({}, n)).pathname && (o.pathname = ""), o.search ? "?" !== o.search.charAt(0) && (o.search = "?" + o.search) : o.search = "", o.hash ? "#" !== o.hash.charAt(0) && (o.hash = "#" + o.hash) : o.hash = "", void 0 !== t && void 0 === o.state && (o.state = t));try {
        o.pathname = decodeURI(o.pathname);
      } catch (n) {
        throw n instanceof URIError ? new URIError('Pathname "' + o.pathname + '" could not be decoded. This is likely caused by an invalid percent-encoding.') : n;
      }return e && (o.key = e), a ? o.pathname ? "/" !== o.pathname.charAt(0) && (o.pathname = resolvePathname(o.pathname, a.pathname)) : o.pathname = a.pathname : o.pathname || (o.pathname = "/"), o;
    }function locationsAreEqual(n, t) {
      return n.pathname === t.pathname && n.search === t.search && n.hash === t.hash && n.key === t.key && valueEqual(n.state, t.state);
    }function createTransitionManager() {
      var r = null;var a = [];return { setPrompt: function (n) {
          return r = n, function () {
            r === n && (r = null);
          };
        }, confirmTransitionTo: function (n, t, e, a) {
          if (null != r) {
            var o = "function" == typeof r ? r(n, t) : r;"string" == typeof o ? "function" == typeof e ? e(o, a) : a(!0) : a(!1 !== o);
          } else a(!0);
        }, appendListener: function (n) {
          var t = !0;function e() {
            t && n.apply(void 0, arguments);
          }return a.push(e), function () {
            t = !1, a = a.filter(function (n) {
              return n !== e;
            });
          };
        }, notifyListeners: function () {
          for (var n = arguments.length, t = new Array(n), e = 0; e < n; e++) t[e] = arguments[e];a.forEach(function (n) {
            return n.apply(void 0, t);
          });
        } };
    }var canUseDOM = !("undefined" == typeof window || !window.document || !window.document.createElement);function getConfirmation(n, t) {
      t(window.confirm(n));
    }function supportsHistory() {
      var n = window.navigator.userAgent;return (-1 === n.indexOf("Android 2.") && -1 === n.indexOf("Android 4.0") || -1 === n.indexOf("Mobile Safari") || -1 !== n.indexOf("Chrome") || -1 !== n.indexOf("Windows Phone")) && window.history && "pushState" in window.history;
    }function supportsPopStateOnHashChange() {
      return -1 === window.navigator.userAgent.indexOf("Trident");
    }function supportsGoWithoutReloadUsingHash() {
      return -1 === window.navigator.userAgent.indexOf("Firefox");
    }function isExtraneousPopstateEvent(n) {
      void 0 === n.state && navigator.userAgent.indexOf("CriOS");
    }var PopStateEvent = "popstate",
        HashChangeEvent = "hashchange";function getHistoryState() {
      try {
        return window.history.state || {};
      } catch (n) {
        return {};
      }
    }function createBrowserHistory(n) {
      void 0 === n && (n = {}), canUseDOM || invariant(!1);var c = window.history,
          s = supportsHistory(),
          t = !supportsPopStateOnHashChange(),
          e = n,
          a = e.forceRefresh,
          h = void 0 !== a && a,
          o = e.getUserConfirmation,
          u = void 0 === o ? getConfirmation : o,
          r = e.keyLength,
          i = void 0 === r ? 6 : r,
          f = n.basename ? stripTrailingSlash(addLeadingSlash(n.basename)) : "";function l(n) {
        var t = n || {},
            e = t.key,
            a = t.state,
            o = window.location,
            r = o.pathname + o.search + o.hash;return f && (r = stripBasename(r, f)), createLocation(r, a, e);
      }function d() {
        return Math.random().toString(36).substr(2, i);
      }var v = createTransitionManager();function p(n) {
        _extends(T, n), T.length = c.length, v.notifyListeners(T.location, T.action);
      }function g(n) {
        isExtraneousPopstateEvent(n) || w(l(n.state));
      }function P() {
        w(l(getHistoryState()));
      }var m = !1;function w(t) {
        if (m) m = !1, p();else {
          v.confirmTransitionTo(t, "POP", u, function (n) {
            n ? p({ action: "POP", location: t }) : function (n) {
              var t = T.location,
                  e = H.indexOf(t.key);-1 === e && (e = 0);var a = H.indexOf(n.key);-1 === a && (a = 0);var o = e - a;o && (m = !0, L(o));
            }(t);
          });
        }
      }var y = l(getHistoryState()),
          H = [y.key];function x(n) {
        return f + createPath(n);
      }function L(n) {
        c.go(n);
      }var O = 0;function E(n) {
        1 === (O += n) && 1 === n ? (window.addEventListener(PopStateEvent, g), t && window.addEventListener(HashChangeEvent, P)) : 0 === O && (window.removeEventListener(PopStateEvent, g), t && window.removeEventListener(HashChangeEvent, P));
      }var S = !1;var T = { length: c.length, action: "POP", location: y, createHref: x, push: function (n, t) {
          var i = createLocation(n, t, d(), T.location);v.confirmTransitionTo(i, "PUSH", u, function (n) {
            if (n) {
              var t = x(i),
                  e = i.key,
                  a = i.state;if (s) {
                if (c.pushState({ key: e, state: a }, null, t), h) window.location.href = t;else {
                  var o = H.indexOf(T.location.key),
                      r = H.slice(0, -1 === o ? 0 : o + 1);r.push(i.key), H = r, p({ action: "PUSH", location: i });
                }
              } else window.location.href = t;
            }
          });
        }, replace: function (n, t) {
          var r = "REPLACE",
              i = createLocation(n, t, d(), T.location);v.confirmTransitionTo(i, r, u, function (n) {
            if (n) {
              var t = x(i),
                  e = i.key,
                  a = i.state;if (s) {
                if (c.replaceState({ key: e, state: a }, null, t), h) window.location.replace(t);else {
                  var o = H.indexOf(T.location.key);-1 !== o && (H[o] = i.key), p({ action: r, location: i });
                }
              } else window.location.replace(t);
            }
          });
        }, go: L, goBack: function () {
          L(-1);
        }, goForward: function () {
          L(1);
        }, block: function (n) {
          void 0 === n && (n = !1);var t = v.setPrompt(n);return S || (E(1), S = !0), function () {
            return S && (S = !1, E(-1)), t();
          };
        }, listen: function (n) {
          var t = v.appendListener(n);return E(1), function () {
            E(-1), t();
          };
        } };return T;
    }var HashChangeEvent$1 = "hashchange",
        HashPathCoders = { hashbang: { encodePath: function (n) {
          return "!" === n.charAt(0) ? n : "!/" + stripLeadingSlash(n);
        }, decodePath: function (n) {
          return "!" === n.charAt(0) ? n.substr(1) : n;
        } }, noslash: { encodePath: stripLeadingSlash, decodePath: addLeadingSlash }, slash: { encodePath: addLeadingSlash, decodePath: addLeadingSlash } };function getHashPath() {
      var n = window.location.href,
          t = n.indexOf("#");return -1 === t ? "" : n.substring(t + 1);
    }function pushHashPath(n) {
      window.location.hash = n;
    }function replaceHashPath(n) {
      var t = window.location.href.indexOf("#");window.location.replace(window.location.href.slice(0, 0 <= t ? t : 0) + "#" + n);
    }function createHashHistory(n) {
      void 0 === n && (n = {}), canUseDOM || invariant(!1);var t = window.history,
          e = (supportsGoWithoutReloadUsingHash(), n),
          a = e.getUserConfirmation,
          i = void 0 === a ? getConfirmation : a,
          o = e.hashType,
          r = void 0 === o ? "slash" : o,
          c = n.basename ? stripTrailingSlash(addLeadingSlash(n.basename)) : "",
          s = HashPathCoders[r],
          h = s.encodePath,
          u = s.decodePath;function f() {
        var n = u(getHashPath());return c && (n = stripBasename(n, c)), createLocation(n);
      }var l = createTransitionManager();function d(n) {
        _extends(E, n), E.length = t.length, l.notifyListeners(E.location, E.action);
      }var v = !1,
          p = null;function g() {
        var n = getHashPath(),
            t = h(n);if (n !== t) replaceHashPath(t);else {
          var e = f(),
              a = E.location;if (!v && locationsAreEqual(a, e)) return;if (p === createPath(e)) return;p = null, function (t) {
            if (v) v = !1, d();else {
              l.confirmTransitionTo(t, "POP", i, function (n) {
                n ? d({ action: "POP", location: t }) : function (n) {
                  var t = E.location,
                      e = y.lastIndexOf(createPath(t));-1 === e && (e = 0);var a = y.lastIndexOf(createPath(n));-1 === a && (a = 0);var o = e - a;o && (v = !0, H(o));
                }(t);
              });
            }
          }(e);
        }
      }var P = getHashPath(),
          m = h(P);P !== m && replaceHashPath(m);var w = f(),
          y = [createPath(w)];function H(n) {
        t.go(n);
      }var x = 0;function L(n) {
        1 === (x += n) && 1 === n ? window.addEventListener(HashChangeEvent$1, g) : 0 === x && window.removeEventListener(HashChangeEvent$1, g);
      }var O = !1;var E = { length: t.length, action: "POP", location: w, createHref: function (n) {
          return "#" + h(c + createPath(n));
        }, push: function (n, t) {
          var r = createLocation(n, void 0, void 0, E.location);l.confirmTransitionTo(r, "PUSH", i, function (n) {
            if (n) {
              var t = createPath(r),
                  e = h(c + t);if (getHashPath() !== e) {
                p = t, pushHashPath(e);var a = y.lastIndexOf(createPath(E.location)),
                    o = y.slice(0, -1 === a ? 0 : a + 1);o.push(t), y = o, d({ action: "PUSH", location: r });
              } else d();
            }
          });
        }, replace: function (n, t) {
          var o = "REPLACE",
              r = createLocation(n, void 0, void 0, E.location);l.confirmTransitionTo(r, o, i, function (n) {
            if (n) {
              var t = createPath(r),
                  e = h(c + t);getHashPath() !== e && (p = t, replaceHashPath(e));var a = y.indexOf(createPath(E.location));-1 !== a && (y[a] = t), d({ action: o, location: r });
            }
          });
        }, go: H, goBack: function () {
          H(-1);
        }, goForward: function () {
          H(1);
        }, block: function (n) {
          void 0 === n && (n = !1);var t = l.setPrompt(n);return O || (L(1), O = !0), function () {
            return O && (O = !1, L(-1)), t();
          };
        }, listen: function (n) {
          var t = l.appendListener(n);return L(1), function () {
            L(-1), t();
          };
        } };return E;
    }function clamp(n, t, e) {
      return Math.min(Math.max(n, t), e);
    }function createMemoryHistory(n) {
      void 0 === n && (n = {});var t = n,
          o = t.getUserConfirmation,
          e = t.initialEntries,
          a = void 0 === e ? ["/"] : e,
          r = t.initialIndex,
          i = void 0 === r ? 0 : r,
          c = t.keyLength,
          s = void 0 === c ? 6 : c,
          h = createTransitionManager();function u(n) {
        _extends(g, n), g.length = g.entries.length, h.notifyListeners(g.location, g.action);
      }function f() {
        return Math.random().toString(36).substr(2, s);
      }var l = clamp(i, 0, a.length - 1),
          d = a.map(function (n) {
        return createLocation(n, void 0, "string" == typeof n ? f() : n.key || f());
      });function p(n) {
        var t = clamp(g.index + n, 0, g.entries.length - 1),
            e = g.entries[t];h.confirmTransitionTo(e, "POP", o, function (n) {
          n ? u({ action: "POP", location: e, index: t }) : u();
        });
      }var g = { length: d.length, action: "POP", location: d[l], index: l, entries: d, createHref: createPath, push: function (n, t) {
          var a = createLocation(n, t, f(), g.location);h.confirmTransitionTo(a, "PUSH", o, function (n) {
            if (n) {
              var t = g.index + 1,
                  e = g.entries.slice(0);e.length > t ? e.splice(t, e.length - t, a) : e.push(a), u({ action: "PUSH", location: a, index: t, entries: e });
            }
          });
        }, replace: function (n, t) {
          var e = "REPLACE",
              a = createLocation(n, t, f(), g.location);h.confirmTransitionTo(a, e, o, function (n) {
            n && (g.entries[g.index] = a, u({ action: e, location: a }));
          });
        }, go: p, goBack: function () {
          p(-1);
        }, goForward: function () {
          p(1);
        }, canGo: function (n) {
          var t = g.index + n;return 0 <= t && t < g.entries.length;
        }, block: function (n) {
          return void 0 === n && (n = !1), h.setPrompt(n);
        }, listen: function (n) {
          return h.appendListener(n);
        } };return g;
    }exports.createBrowserHistory = createBrowserHistory, exports.createHashHistory = createHashHistory, exports.createMemoryHistory = createMemoryHistory, exports.createLocation = createLocation, exports.locationsAreEqual = locationsAreEqual, exports.parsePath = parsePath, exports.createPath = createPath;
  }
});
//# sourceMappingURL=history.min.js.map