Liferay.Loader.define('data-engine-taglib$moment@2.24.0/src/locale/pa-in', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        //! moment.js locale configuration
        //! locale : Punjabi (India) [pa-in]
        //! author : Harpreet Singh : https://github.com/harpreetkhalsagtbit

        import moment from '../moment';

        var symbolMap = {
            '1': '੧',
            '2': '੨',
            '3': '੩',
            '4': '੪',
            '5': '੫',
            '6': '੬',
            '7': '੭',
            '8': '੮',
            '9': '੯',
            '0': '੦'
        },
            numberMap = {
            '੧': '1',
            '੨': '2',
            '੩': '3',
            '੪': '4',
            '੫': '5',
            '੬': '6',
            '੭': '7',
            '੮': '8',
            '੯': '9',
            '੦': '0'
        };

        export default moment.defineLocale('pa-in', {
            // There are months name as per Nanakshahi Calendar but they are not used as rigidly in modern Punjabi.
            months: 'ਜਨਵਰੀ_ਫ਼ਰਵਰੀ_ਮਾਰਚ_ਅਪ੍ਰੈਲ_ਮਈ_ਜੂਨ_ਜੁਲਾਈ_ਅਗਸਤ_ਸਤੰਬਰ_ਅਕਤੂਬਰ_ਨਵੰਬਰ_ਦਸੰਬਰ'.split('_'),
            monthsShort: 'ਜਨਵਰੀ_ਫ਼ਰਵਰੀ_ਮਾਰਚ_ਅਪ੍ਰੈਲ_ਮਈ_ਜੂਨ_ਜੁਲਾਈ_ਅਗਸਤ_ਸਤੰਬਰ_ਅਕਤੂਬਰ_ਨਵੰਬਰ_ਦਸੰਬਰ'.split('_'),
            weekdays: 'ਐਤਵਾਰ_ਸੋਮਵਾਰ_ਮੰਗਲਵਾਰ_ਬੁਧਵਾਰ_ਵੀਰਵਾਰ_ਸ਼ੁੱਕਰਵਾਰ_ਸ਼ਨੀਚਰਵਾਰ'.split('_'),
            weekdaysShort: 'ਐਤ_ਸੋਮ_ਮੰਗਲ_ਬੁਧ_ਵੀਰ_ਸ਼ੁਕਰ_ਸ਼ਨੀ'.split('_'),
            weekdaysMin: 'ਐਤ_ਸੋਮ_ਮੰਗਲ_ਬੁਧ_ਵੀਰ_ਸ਼ੁਕਰ_ਸ਼ਨੀ'.split('_'),
            longDateFormat: {
                LT: 'A h:mm ਵਜੇ',
                LTS: 'A h:mm:ss ਵਜੇ',
                L: 'DD/MM/YYYY',
                LL: 'D MMMM YYYY',
                LLL: 'D MMMM YYYY, A h:mm ਵਜੇ',
                LLLL: 'dddd, D MMMM YYYY, A h:mm ਵਜੇ'
            },
            calendar: {
                sameDay: '[ਅਜ] LT',
                nextDay: '[ਕਲ] LT',
                nextWeek: '[ਅਗਲਾ] dddd, LT',
                lastDay: '[ਕਲ] LT',
                lastWeek: '[ਪਿਛਲੇ] dddd, LT',
                sameElse: 'L'
            },
            relativeTime: {
                future: '%s ਵਿੱਚ',
                past: '%s ਪਿਛਲੇ',
                s: 'ਕੁਝ ਸਕਿੰਟ',
                ss: '%d ਸਕਿੰਟ',
                m: 'ਇਕ ਮਿੰਟ',
                mm: '%d ਮਿੰਟ',
                h: 'ਇੱਕ ਘੰਟਾ',
                hh: '%d ਘੰਟੇ',
                d: 'ਇੱਕ ਦਿਨ',
                dd: '%d ਦਿਨ',
                M: 'ਇੱਕ ਮਹੀਨਾ',
                MM: '%d ਮਹੀਨੇ',
                y: 'ਇੱਕ ਸਾਲ',
                yy: '%d ਸਾਲ'
            },
            preparse: function (string) {
                return string.replace(/[੧੨੩੪੫੬੭੮੯੦]/g, function (match) {
                    return numberMap[match];
                });
            },
            postformat: function (string) {
                return string.replace(/\d/g, function (match) {
                    return symbolMap[match];
                });
            },
            // Punjabi notation for meridiems are quite fuzzy in practice. While there exists
            // a rigid notion of a 'Pahar' it is not used as rigidly in modern Punjabi.
            meridiemParse: /ਰਾਤ|ਸਵੇਰ|ਦੁਪਹਿਰ|ਸ਼ਾਮ/,
            meridiemHour: function (hour, meridiem) {
                if (hour === 12) {
                    hour = 0;
                }
                if (meridiem === 'ਰਾਤ') {
                    return hour < 4 ? hour : hour + 12;
                } else if (meridiem === 'ਸਵੇਰ') {
                    return hour;
                } else if (meridiem === 'ਦੁਪਹਿਰ') {
                    return hour >= 10 ? hour : hour + 12;
                } else if (meridiem === 'ਸ਼ਾਮ') {
                    return hour + 12;
                }
            },
            meridiem: function (hour, minute, isLower) {
                if (hour < 4) {
                    return 'ਰਾਤ';
                } else if (hour < 10) {
                    return 'ਸਵੇਰ';
                } else if (hour < 17) {
                    return 'ਦੁਪਹਿਰ';
                } else if (hour < 20) {
                    return 'ਸ਼ਾਮ';
                } else {
                    return 'ਰਾਤ';
                }
            },
            week: {
                dow: 0, // Sunday is the first day of the week.
                doy: 6 // The week that contains Jan 6th is the first week of the year.
            }
        });
    }
});
//# sourceMappingURL=pa-in.js.map