/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.deployment.helper;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.zeroturnaround.zip.ByteSource;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipUtil;

public class DeploymentHelper {
    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String deploymentFileNames = arguments.get("deployment.files");
        if (Validator.isNull(deploymentFileNames)) {
            throw new IllegalArgumentException("The \"deployment.files\" argument is required");
        }
        String deploymentPath = arguments.get("deployment.path");
        if (Validator.isNull(deploymentPath)) {
            throw new IllegalArgumentException("The \"deployment.path\" argument is required");
        }
        String outputFileName = arguments.get("deployment.output.file");
        if (Validator.isNull(outputFileName)) {
            throw new IllegalArgumentException("The \"deployment.output.file\" argument is required");
        }
        try {
            new DeploymentHelper(deploymentFileNames, deploymentPath, outputFileName);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public DeploymentHelper(String deploymentFileNames, String deploymentPath, String outputFileName) throws Exception {
        ArrayList<ZipEntrySource> zipEntrySources = new ArrayList<ZipEntrySource>();
        StringBuilder sb = new StringBuilder();
        for (String deploymentFileName : deploymentFileNames.split(",")) {
            File file = new File(deploymentFileName.trim());
            String webInfDeploymentFileName = "WEB-INF/" + file.getName();
            zipEntrySources.add(new FileSource(webInfDeploymentFileName, file));
            sb.append('/');
            sb.append(webInfDeploymentFileName);
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        zipEntrySources.add(this.getWebXmlZipEntrySource(sb.toString(), deploymentPath));
        zipEntrySources.add(this.getClassZipEntrySource("com/liferay/deployment/helper/servlet/DeploymentHelperContextListener.class"));
        ZipUtil.pack(zipEntrySources.toArray(new ZipEntrySource[zipEntrySources.size()]), new File(outputFileName));
    }

    protected ZipEntrySource getClassZipEntrySource(String fileName) throws Exception {
        byte[] bytes = this.read(fileName);
        return new ByteSource("WEB-INF/classes/" + fileName, bytes);
    }

    protected ZipEntrySource getWebXmlZipEntrySource(String deploymentFileNames, String deploymentPath) throws Exception {
        byte[] bytes = this.read("com/liferay/deployment/helper/servlet/dependencies/web.xml");
        String content = new String(bytes);
        content = content.replace("${deployment.files}", deploymentFileNames);
        content = content.replace("${deployment.path}", deploymentPath);
        return new ByteSource("WEB-INF/web.xml", content.getBytes(StandardCharsets.UTF_8));
    }

    protected byte[] read(String fileName) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ClassLoader classLoader = DeploymentHelper.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(fileName);){
            byte[] bytes = new byte[1024];
            int length = 0;
            while ((length = inputStream.read(bytes)) > 0) {
                byteArrayOutputStream.write(bytes, 0, length);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

