/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validator {
    private static final String[] _BOOLEANS = new String[]{"false", "on", "off", "true"};
    private static final int _CHAR_LOWER_CASE_BEGIN = 97;
    private static final int _CHAR_LOWER_CASE_END = 122;
    private static final int _CHAR_UPPER_CASE_BEGIN = 65;
    private static final int _CHAR_UPPER_CASE_END = 90;
    private static final int _DIGIT_BEGIN = 48;
    private static final int _DIGIT_END = 57;
    private static final char[] _EMAIL_ADDRESS_SPECIAL_CHAR = new char[]{'.', '!', '#', '$', '%', '&', '\'', '*', '+', '-', '/', '=', '?', '^', '_', '`', '{', '|', '}', '~'};
    private static final String _VARIABLE_TERM_BEGIN = "[$";
    private static final String _VARIABLE_TERM_END = "$]";
    private static final String _XML_BEGIN = "<?xml";
    private static final String _XML_EMPTY = "<root />";
    private static final Pattern _emailAddressPattern = Pattern.compile("[\\w!#$%&'*+/=?^_`{|}~-]+(?:\\.[\\w!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:-*[a-zA-Z0-9])?\\.*)+");
    private static final Pattern _ipv4AddressPattern = Pattern.compile("^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private static final Pattern _ipv6AddressPattern = Pattern.compile("^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$");
    private static final Pattern _variableNamePattern = Pattern.compile("[_a-zA-Z]+[_a-zA-Z0-9]*");

    public static boolean equals(boolean boolean1, boolean boolean2) {
        return boolean1 == boolean2;
    }

    public static boolean equals(byte byte1, byte byte2) {
        return byte1 == byte2;
    }

    public static boolean equals(char char1, char char2) {
        return char1 == char2;
    }

    public static boolean equals(double double1, double double2) {
        return Double.compare(double1, double2) == 0;
    }

    public static boolean equals(float float1, float float2) {
        return Float.compare(float1, float2) == 0;
    }

    public static boolean equals(int int1, int int2) {
        return int1 == int2;
    }

    public static boolean equals(long long1, long long2) {
        return long1 == long2;
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static boolean equals(short short1, short short2) {
        return short1 == short2;
    }

    public static boolean equalsSorted(boolean[] booleanArray1, boolean[] booleanArray2) {
        Object[] booleanObjArray1 = ArrayUtil.toArray((boolean[])booleanArray1);
        Arrays.sort(booleanObjArray1);
        Object[] booleanObjArray2 = ArrayUtil.toArray((boolean[])booleanArray2);
        Arrays.sort(booleanObjArray2);
        return Arrays.equals(booleanObjArray1, booleanObjArray2);
    }

    public static boolean equalsSorted(byte[] byteArray1, byte[] byteArray2) {
        byteArray1 = ArrayUtil.clone((byte[])byteArray1);
        Arrays.sort(byteArray1);
        byteArray2 = ArrayUtil.clone((byte[])byteArray2);
        Arrays.sort(byteArray2);
        return Arrays.equals(byteArray1, byteArray2);
    }

    public static boolean equalsSorted(char[] charArray1, char[] charArray2) {
        charArray1 = ArrayUtil.clone((char[])charArray1);
        Arrays.sort(charArray1);
        charArray2 = ArrayUtil.clone((char[])charArray2);
        Arrays.sort(charArray2);
        return Arrays.equals(charArray1, charArray2);
    }

    public static boolean equalsSorted(double[] doubleArray1, double[] doubleArray2) {
        doubleArray1 = ArrayUtil.clone((double[])doubleArray1);
        Arrays.sort(doubleArray1);
        doubleArray2 = ArrayUtil.clone((double[])doubleArray2);
        Arrays.sort(doubleArray2);
        return Arrays.equals(doubleArray1, doubleArray2);
    }

    public static boolean equalsSorted(float[] floatArray1, float[] floatArray2) {
        floatArray1 = ArrayUtil.clone((float[])floatArray1);
        Arrays.sort(floatArray1);
        floatArray2 = ArrayUtil.clone((float[])floatArray2);
        Arrays.sort(floatArray2);
        return Arrays.equals(floatArray1, floatArray2);
    }

    public static boolean equalsSorted(int[] intArray1, int[] intArray2) {
        intArray1 = ArrayUtil.clone((int[])intArray1);
        Arrays.sort(intArray1);
        intArray2 = ArrayUtil.clone((int[])intArray2);
        Arrays.sort(intArray2);
        return Arrays.equals(intArray1, intArray2);
    }

    public static boolean equalsSorted(long[] longArray1, long[] longArray2) {
        longArray1 = ArrayUtil.clone((long[])longArray1);
        Arrays.sort(longArray1);
        longArray2 = ArrayUtil.clone((long[])longArray2);
        Arrays.sort(longArray2);
        return Arrays.equals(longArray1, longArray2);
    }

    public static boolean equalsSorted(Object[] objArray1, Object[] objArray2) {
        objArray1 = ArrayUtil.clone((Object[])objArray1);
        Arrays.sort(objArray1);
        objArray2 = ArrayUtil.clone((Object[])objArray2);
        Arrays.sort(objArray2);
        return Arrays.equals(objArray1, objArray2);
    }

    public static boolean equalsSorted(short[] shortArray1, short[] shortArray2) {
        shortArray1 = ArrayUtil.clone((short[])shortArray1);
        Arrays.sort(shortArray1);
        shortArray2 = ArrayUtil.clone((short[])shortArray2);
        Arrays.sort(shortArray2);
        return Arrays.equals(shortArray1, shortArray2);
    }

    public static boolean isAddress(String address) {
        if (Validator.isNull(address)) {
            return false;
        }
        String[] tokens = address.split("@");
        if (tokens.length != 2) {
            return false;
        }
        for (String token : tokens) {
            for (char c : token.toCharArray()) {
                if (!Character.isWhitespace(c)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAlphanumericName(String name) {
        if (Validator.isNull(name)) {
            return false;
        }
        for (char c : name.trim().toCharArray()) {
            if (Validator.isChar(c) || Validator.isDigit(c) || Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char c) {
        char i = c;
        return i >= ' ' && i <= '~';
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }

    public static boolean isBoolean(String value) {
        return ArrayUtil.contains((Object[])_BOOLEANS, (Object)value);
    }

    public static boolean isChar(char c) {
        char x = c;
        return x >= 'a' && x <= 'z' || x >= 'A' && x <= 'Z';
    }

    public static boolean isChar(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (Validator.isChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isContent(String s) {
        return Validator.isNotNull(StringUtil.replace((String)s, (String[])new String[]{"\n", "\t"}, (String[])new String[]{"", ""}));
    }

    public static boolean isDate(int month, int day, int year) {
        return Validator.isGregorianDate(month, day, year);
    }

    public static boolean isDigit(char c) {
        char x = c;
        return x >= '0' && x <= '9';
    }

    public static boolean isDigit(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (Validator.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDomain(String domainName) {
        String[] domainNameArray;
        if (Validator.isNull(domainName)) {
            return false;
        }
        if (domainName.length() > 255) {
            return false;
        }
        if (domainName.startsWith(".")) {
            return false;
        }
        for (String domainNamePart : domainNameArray = StringUtil.split((String)domainName, (char)'.')) {
            char[] domainNamePartCharArray = domainNamePart.toCharArray();
            for (int i = 0; i < domainNamePartCharArray.length; ++i) {
                char c = domainNamePartCharArray[i];
                if (i == 0 && c == '-') {
                    return false;
                }
                if (i == domainNamePartCharArray.length - 1 && c == '-') {
                    return false;
                }
                if (Character.isLetterOrDigit(c) || c == '-') continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmailAddress(String emailAddress) {
        Matcher matcher = _emailAddressPattern.matcher(emailAddress);
        return matcher.matches();
    }

    public static boolean isEmailAddressSpecialChar(char c) {
        for (char specialChar : _EMAIL_ADDRESS_SPECIAL_CHAR) {
            if (c != specialChar) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileExtension(String fileExtension) {
        return !Validator.isNull(fileExtension) && !fileExtension.contains("\\") && !fileExtension.contains("\u0000") && !fileExtension.contains("/");
    }

    public static boolean isFileName(String name) {
        return !Validator.isNull(name) && !name.equals(".") && !name.equals("..") && !name.contains("\\") && !name.contains("\u0000") && !name.contains("/");
    }

    public static boolean isFilePath(String path, boolean isParentDirAllowed) {
        if (Validator.isNull(path)) {
            return false;
        }
        if (path.contains("\u0000")) {
            return false;
        }
        if (isParentDirAllowed) {
            return true;
        }
        if (path.equals("..")) {
            return false;
        }
        String normalizedPath = path.replace('\\', '/');
        if (normalizedPath.startsWith("..".concat("/"))) {
            return false;
        }
        if (normalizedPath.endsWith("/".concat(".."))) {
            return false;
        }
        return !normalizedPath.contains("/".concat("..").concat("/"));
    }

    public static boolean isGregorianDate(int month, int day, int year) {
        if (month < 0 || month > 11) {
            return false;
        }
        int[] months = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (month == 1) {
            int febMax = 28;
            if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                febMax = 29;
            }
            if (day < 1 || day > febMax) {
                return false;
            }
        } else if (day < 1 || day > months[month]) {
            return false;
        }
        return true;
    }

    public static boolean isHex(String s) {
        return !Validator.isNull(s);
    }

    public static boolean isHostName(String name) {
        if (Validator.isNull(name)) {
            return false;
        }
        char[] nameCharArray = name.toCharArray();
        if (nameCharArray[0] == '-' || nameCharArray[0] == '.' || nameCharArray[nameCharArray.length - 1] == '-') {
            return false;
        }
        for (char c : nameCharArray) {
            if (Validator.isChar(c) || Validator.isDigit(c) || c == ']' || c == ':' || c == '-' || c == '[' || c == '.') continue;
            return false;
        }
        return true;
    }

    public static boolean isHTML(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        return !(!s.contains("<html>") && !s.contains("<HTML>") || !s.contains("</html>") && !s.contains("</HTML>"));
    }

    public static boolean isIPAddress(String ipAddress) {
        return Validator.isIPv4Address(ipAddress) || Validator.isIPv6Address(ipAddress);
    }

    public static boolean isIPv4Address(String ipAddress) {
        Matcher matcher = _ipv4AddressPattern.matcher(ipAddress);
        return matcher.matches();
    }

    public static boolean isIPv6Address(String ipAddress) {
        if (Validator.isNull(ipAddress)) {
            return false;
        }
        if (StringUtil.startsWith((String)ipAddress, (char)'[') && StringUtil.endsWith((String)ipAddress, (char)']')) {
            ipAddress = ipAddress.substring(1, ipAddress.length() - 1);
        }
        Matcher matcher = _ipv6AddressPattern.matcher(ipAddress);
        return matcher.matches();
    }

    public static boolean isJulianDate(int month, int day, int year) {
        if (month < 0 || month > 11) {
            return false;
        }
        int[] months = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (month == 1) {
            int febMax = 28;
            if (year % 4 == 0) {
                febMax = 29;
            }
            if (day < 1 || day > febMax) {
                return false;
            }
        } else if (day < 1 || day > months[month]) {
            return false;
        }
        return true;
    }

    public static boolean isLUHN(String number) {
        if (number == null) {
            return false;
        }
        number = StringUtil.reverse((String)number);
        int total = 0;
        for (int i = 0; i < number.length(); ++i) {
            int x = 0;
            if ((i + 1) % 2 == 0) {
                x = GetterUtil.getInteger(number.substring(i, i + 1)) * 2;
                if (x >= 10) {
                    String s = String.valueOf(x);
                    x = GetterUtil.getInteger(s.substring(0, 1)) + GetterUtil.getInteger(s.substring(1, 2));
                }
            } else {
                x = GetterUtil.getInteger(number.substring(i, i + 1));
            }
            total += x;
        }
        return total % 10 == 0;
    }

    public static boolean isName(String name) {
        if (Validator.isNull(name)) {
            return false;
        }
        for (char c : name.trim().toCharArray()) {
            if (Validator.isChar(c) || Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotNull(Long l) {
        return !Validator.isNull(l);
    }

    public static boolean isNotNull(Object obj) {
        return !Validator.isNull(obj);
    }

    @Deprecated
    public static boolean isNotNull(Object[] array) {
        return ArrayUtil.isNotEmpty((Object[])array);
    }

    public static boolean isNotNull(String s) {
        return !Validator.isNull(s);
    }

    public static boolean isNull(Long l) {
        return l == null || l == 0L;
    }

    public static boolean isNull(Object obj) {
        if (obj instanceof Long) {
            return Validator.isNull((Long)obj);
        }
        if (obj instanceof String) {
            return Validator.isNull((String)obj);
        }
        return obj == null;
    }

    @Deprecated
    public static boolean isNull(Object[] array) {
        return ArrayUtil.isEmpty((Object[])array);
    }

    public static boolean isNull(String s) {
        if (s == null) {
            return true;
        }
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ') continue;
            if (counter > 3) {
                return false;
            }
            if (counter == 0 ? c != 'n' : (counter == 1 ? c != 'u' : (counter == 2 || counter == 3) && c != 'l')) {
                return false;
            }
            ++counter;
        }
        return counter == 0 || counter == 4;
    }

    public static boolean isNumber(String number) {
        if (Validator.isNull(number)) {
            return false;
        }
        for (char c : number.toCharArray()) {
            if (Validator.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPassword(String password) {
        if (Validator.isNull(password)) {
            return false;
        }
        if (password.length() < 4) {
            return false;
        }
        for (char c : password.toCharArray()) {
            if (Validator.isChar(c) || Validator.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPhoneNumber(String phoneNumber) {
        return Validator.isNumber(StringUtil.extractDigits((String)phoneNumber));
    }

    public static boolean isUri(String uri) {
        if (Validator.isNotNull(uri)) {
            try {
                new URI(uri);
                return true;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isUrl(String url) {
        if (Validator.isNotNull(url)) {
            if (url.indexOf(58) == -1) {
                return false;
            }
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isVariableName(String variableName) {
        if (Validator.isNull(variableName)) {
            return false;
        }
        Matcher matcher = _variableNamePattern.matcher(variableName);
        return matcher.matches();
    }

    public static boolean isVariableTerm(String s) {
        return s.startsWith(_VARIABLE_TERM_BEGIN) && s.endsWith(_VARIABLE_TERM_END);
    }

    public static boolean isWhitespace(char c) {
        char i = c;
        return i == '\u0000' || Character.isWhitespace(c);
    }

    public static boolean isXml(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        return s.startsWith(_XML_BEGIN) || s.startsWith(_XML_EMPTY);
    }
}

