/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.exportimport.data.handler;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.xml.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class DepotEntryGroupRelStagedModelDataHandler
extends BaseStagedModelDataHandler<DepotEntryGroupRel> {
    public static final String[] CLASS_NAMES = new String[]{DepotEntryGroupRel.class.getName()};
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.depot.model.DepotEntryGroupRel)", unbind="-")
    private StagedModelRepository<DepotEntryGroupRel> _stagedModelRepository;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DepotEntryGroupRel depotEntryGroupRel) throws Exception {
        Element exportDataElement = portletDataContext.getExportDataElement((ClassedModel)depotEntryGroupRel);
        exportDataElement.addAttribute("depot-entry-live-group-id", String.valueOf(this._getDepotEntryLiveGroupId(depotEntryGroupRel)));
        portletDataContext.addClassedModel(exportDataElement, ExportImportPathUtil.getModelPath((StagedModel)depotEntryGroupRel), (ClassedModel)depotEntryGroupRel);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DepotEntryGroupRel depotEntryGroupRel) throws Exception {
        DepotEntryGroupRel importedDepotEntryGroupRel = (DepotEntryGroupRel)depotEntryGroupRel.clone();
        importedDepotEntryGroupRel.setGroupId(portletDataContext.getScopeGroupId());
        importedDepotEntryGroupRel.setToGroupId(portletDataContext.getScopeGroupId());
        DepotEntryGroupRel existingDepotEntryGroupRel = (DepotEntryGroupRel)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(depotEntryGroupRel.getUuid(), portletDataContext.getScopeGroupId());
        if (existingDepotEntryGroupRel == null || !portletDataContext.isDataStrategyMirror()) {
            Element importDataElement = portletDataContext.getImportDataElement((StagedModel)importedDepotEntryGroupRel);
            DepotEntry depotEntry = this._depotEntryLocalService.getGroupDepotEntry(GetterUtil.getLong((String)importDataElement.attributeValue("depot-entry-live-group-id")));
            importedDepotEntryGroupRel.setDepotEntryId(depotEntry.getDepotEntryId());
            importedDepotEntryGroupRel = (DepotEntryGroupRel)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedDepotEntryGroupRel);
        } else {
            existingDepotEntryGroupRel.setDdmStructuresAvailable(importedDepotEntryGroupRel.isDdmStructuresAvailable());
            existingDepotEntryGroupRel.setSearchable(importedDepotEntryGroupRel.isSearchable());
            importedDepotEntryGroupRel = this._depotEntryGroupRelLocalService.updateDepotEntryGroupRel(existingDepotEntryGroupRel);
        }
        portletDataContext.importClassedModel((ClassedModel)depotEntryGroupRel, (ClassedModel)importedDepotEntryGroupRel);
    }

    protected StagedModelRepository<DepotEntryGroupRel> getStagedModelRepository() {
        return this._stagedModelRepository;
    }

    private long _getDepotEntryLiveGroupId(DepotEntryGroupRel depotEntryGroupRel) throws Exception {
        DepotEntry depotEntry = this._depotEntryLocalService.getDepotEntry(depotEntryGroupRel.getDepotEntryId());
        Group group = depotEntry.getGroup();
        Group stagingGroup = group.getStagingGroup();
        if (stagingGroup != null) {
            return stagingGroup.getGroupId();
        }
        long liveGroupId = group.getLiveGroupId();
        if (group.isStagedRemotely()) {
            liveGroupId = group.getRemoteLiveGroupId();
        }
        if (liveGroupId == 0L) {
            liveGroupId = group.getGroupId();
        }
        return liveGroupId;
    }
}

