/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.instance.lifecycle;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class DepotRolesPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final String[] _DEPOT_ROLE_NAMES = new String[]{"Asset Library Administrator", "Asset Library Connected Site Member", "Asset Library Content Reviewer", "Asset Library Member", "Asset Library Owner"};
    private static final Log _log = LogFactoryUtil.getLog(DepotRolesPortalInstanceLifecycleListener.class);
    @Reference
    private Language _language;
    @Reference(target="(bundle.symbolic.name=com.liferay.depot.service)")
    private ResourceBundleLoader _resourceBundleLoader;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws PortalException {
        for (String name : _DEPOT_ROLE_NAMES) {
            Role role = this._getOrCreateRole(company.getCompanyId(), name, this._getDescriptionMap(name));
            this._resourceLocalService.addResources(company.getCompanyId(), 0L, 0L, Role.class.getName(), role.getRoleId(), false, false, false);
        }
    }

    private String _getDescription(Locale locale, String name) {
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        if (Objects.equals("Asset Library Administrator", name)) {
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"asset-library-administrators-are-super-users-of-their-asset-library-but-cannot-make-other-users-into-asset-library-administrators");
        }
        if (Objects.equals("Asset Library Member", name)) {
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"all-users-who-belong-to-an-asset-library-have-this-role-within-that-asset-library");
        }
        if (Objects.equals("Asset Library Owner", name)) {
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"asset-library-owners-are-super-users-of-their-asset-library-and-can-assign-asset-library-roles-to-users");
        }
        return null;
    }

    private Map<Locale, String> _getDescriptionMap(String name) {
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        for (Locale locale : this._language.getAvailableLocales()) {
            String description = this._getDescription(locale, name);
            if (description == null) continue;
            descriptionMap.put(locale, description);
        }
        return descriptionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Role _getOrCreateRole(long companyId, String name, Map<Locale, String> descriptionMap) throws PortalException {
        try {
            Role role = this._roleLocalService.getRole(companyId, name);
            if (!Objects.equals(descriptionMap, role.getDescriptionMap())) {
                role.setDescriptionMap(descriptionMap);
                return this._roleLocalService.updateRole(role);
            }
            return role;
        }
        catch (NoSuchRoleException noSuchRoleException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchRoleException, (Throwable)noSuchRoleException);
            }
            boolean addResource = PermissionThreadLocal.isAddResource();
            try {
                PermissionThreadLocal.setAddResource((boolean)false);
                User user = this._userLocalService.getDefaultUser(companyId);
                Role role = this._roleLocalService.addRole(user.getUserId(), null, 0L, name, null, descriptionMap, 5, null, null);
                return role;
            }
            finally {
                PermissionThreadLocal.setAddResource((boolean)addResource);
            }
        }
    }
}

