/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.security.permission.contributor;

import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.contributor.RoleCollection;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RoleContributor.class})
public class DepotRoleContributor
implements RoleContributor {
    private static final Log _log = LogFactoryUtil.getLog(DepotRoleContributor.class);
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    public void contribute(RoleCollection roleCollection) {
        try {
            User user;
            if (roleCollection.getGroupId() <= 0L) {
                return;
            }
            Group group = this._groupLocalService.getGroup(roleCollection.getGroupId());
            if (!group.isDepot()) {
                return;
            }
            UserBag userBag = roleCollection.getUserBag();
            if (userBag.hasUserGroup(group)) {
                this._addRoleId(roleCollection, "Asset Library Member");
            }
            if (this._userGroupRoleLocalService.hasUserGroupRole((user = roleCollection.getUser()).getUserId(), group.getGroupId(), "Asset Library Content Reviewer", true)) {
                // empty if block
            }
            if (this._userGroupRoleLocalService.hasUserGroupRole(user.getUserId(), group.getGroupId(), "Asset Library Owner", true) || this._userGroupRoleLocalService.hasUserGroupRole(user.getUserId(), group.getGroupId(), "Asset Library Administrator", true)) {
                // empty if block
            }
            List depotEntryGroupRels = this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(this._depotEntryLocalService.getGroupDepotEntry(group.getGroupId()));
            for (DepotEntryGroupRel depotEntryGroupRel : depotEntryGroupRels) {
                if (!userBag.hasUserGroup(this._groupLocalService.getGroup(depotEntryGroupRel.getToGroupId()))) continue;
                this._addRoleId(roleCollection, "Asset Library Connected Site Member");
                break;
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }

    private void _addRoleId(RoleCollection roleCollection, String roleName) throws PortalException {
        Role role = this._roleLocalService.getRole(roleCollection.getCompanyId(), roleName);
        roleCollection.addRoleId(role.getRoleId());
    }
}

