/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.service.impl;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.base.DepotEntryGroupRelLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.depot.model.DepotEntryGroupRel"}, service={AopService.class})
public class DepotEntryGroupRelLocalServiceImpl
extends DepotEntryGroupRelLocalServiceBaseImpl {
    public DepotEntryGroupRel addDepotEntryGroupRel(boolean ddmStructuresAvailable, long depotEntryId, long toGroupId, boolean searchable) {
        DepotEntryGroupRel depotEntryGroupRel = this.depotEntryGroupRelPersistence.fetchByD_TGI(depotEntryId, toGroupId);
        if (depotEntryGroupRel != null) {
            return depotEntryGroupRel;
        }
        depotEntryGroupRel = this.depotEntryGroupRelPersistence.create(this.counterLocalService.increment());
        depotEntryGroupRel.setGroupId(toGroupId);
        depotEntryGroupRel.setDdmStructuresAvailable(ddmStructuresAvailable);
        depotEntryGroupRel.setDepotEntryId(depotEntryId);
        depotEntryGroupRel.setSearchable(searchable);
        depotEntryGroupRel.setToGroupId(toGroupId);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            depotEntryGroupRel.setUuid(serviceContext.getUuid());
        }
        return (DepotEntryGroupRel)this.depotEntryGroupRelPersistence.update((BaseModel)depotEntryGroupRel);
    }

    public DepotEntryGroupRel addDepotEntryGroupRel(long depotEntryId, long toGroupId) {
        return this.addDepotEntryGroupRel(depotEntryId, toGroupId, true);
    }

    public DepotEntryGroupRel addDepotEntryGroupRel(long depotEntryId, long toGroupId, boolean searchable) {
        return this.addDepotEntryGroupRel(false, depotEntryId, toGroupId, searchable);
    }

    @Override
    @SystemEvent(type=1)
    public DepotEntryGroupRel deleteDepotEntryGroupRel(DepotEntryGroupRel depotEntryGroupRel) {
        return super.deleteDepotEntryGroupRel(depotEntryGroupRel);
    }

    public void deleteToGroupDepotEntryGroupRels(long toGroupId) {
        this.depotEntryGroupRelPersistence.removeByToGroupId(toGroupId);
    }

    public DepotEntryGroupRel fetchDepotEntryGroupRelByDepotEntryIdToGroupId(long depotEntryId, long toGroupId) {
        return this.depotEntryGroupRelPersistence.fetchByD_TGI(depotEntryId, toGroupId);
    }

    public List<DepotEntryGroupRel> getDepotEntryGroupRels(DepotEntry depotEntry) {
        return this.depotEntryGroupRelPersistence.findByDepotEntryId(depotEntry.getDepotEntryId());
    }

    public List<DepotEntryGroupRel> getDepotEntryGroupRels(long groupId, int start, int end) {
        return this.depotEntryGroupRelPersistence.findByToGroupId(groupId, start, end);
    }

    public int getDepotEntryGroupRelsCount(DepotEntry depotEntry) {
        return this.depotEntryGroupRelPersistence.countByDepotEntryId(depotEntry.getDepotEntryId());
    }

    public int getDepotEntryGroupRelsCount(long groupId) {
        return this.depotEntryGroupRelPersistence.countByToGroupId(groupId);
    }

    public List<DepotEntryGroupRel> getSearchableDepotEntryGroupRels(long groupId, int start, int end) {
        return this.depotEntryGroupRelPersistence.findByS_TGI(true, groupId, start, end);
    }

    public int getSearchableDepotEntryGroupRelsCount(long groupId) {
        return this.depotEntryGroupRelPersistence.countByS_TGI(true, groupId);
    }

    public DepotEntryGroupRel updateDDMStructuresAvailable(long depotEntryGroupRelId, boolean ddmStructuresAvailable) throws PortalException {
        DepotEntryGroupRel depotEntryGroupRel = this.getDepotEntryGroupRel(depotEntryGroupRelId);
        depotEntryGroupRel.setDdmStructuresAvailable(ddmStructuresAvailable);
        return (DepotEntryGroupRel)this.depotEntryGroupRelPersistence.update((BaseModel)depotEntryGroupRel);
    }

    public DepotEntryGroupRel updateSearchable(long depotEntryGroupRelId, boolean searchable) throws PortalException {
        DepotEntryGroupRel depotEntryGroupRel = this.getDepotEntryGroupRel(depotEntryGroupRelId);
        depotEntryGroupRel.setSearchable(searchable);
        return (DepotEntryGroupRel)this.depotEntryGroupRelPersistence.update((BaseModel)depotEntryGroupRel);
    }
}

