/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.executor;

import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorOutput;
import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchLogLocalService;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Date;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public abstract class BaseDispatchTaskExecutor
implements DispatchTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BaseDispatchTaskExecutor.class);
    private static final ServiceTracker<?, DispatchLogLocalService> _dispatchLogLocalServiceTracker = ServiceTrackerFactory.open((Bundle)FrameworkUtil.getBundle(DispatchLogLocalService.class), DispatchLogLocalService.class);
    private static final ServiceTracker<?, DispatchTriggerLocalService> _dispatchTriggerLocalServiceTracker = ServiceTrackerFactory.open((Bundle)FrameworkUtil.getBundle(DispatchTriggerLocalService.class), DispatchTriggerLocalService.class);

    public abstract void doExecute(DispatchTrigger var1, DispatchTaskExecutorOutput var2) throws IOException, PortalException;

    @Override
    public void execute(long dispatchTriggerId) throws IOException, PortalException {
        DispatchLogLocalService dispatchLogLocalService = (DispatchLogLocalService)_dispatchLogLocalServiceTracker.getService();
        DispatchTriggerLocalService dispatchTriggerLocalService = (DispatchTriggerLocalService)_dispatchTriggerLocalServiceTracker.getService();
        DispatchTrigger dispatchTrigger = dispatchTriggerLocalService.getDispatchTrigger(dispatchTriggerId);
        DispatchLog dispatchLog = dispatchLogLocalService.addDispatchLog(dispatchTrigger.getUserId(), dispatchTrigger.getDispatchTriggerId(), null, null, null, new Date(), DispatchTaskStatus.IN_PROGRESS);
        DispatchTaskExecutorOutput dispatchTaskExecutorOutput = new DispatchTaskExecutorOutput();
        try {
            this.doExecute(dispatchTrigger, dispatchTaskExecutorOutput);
            dispatchLogLocalService.updateDispatchLog(dispatchLog.getDispatchLogId(), new Date(), dispatchTaskExecutorOutput.getError(), dispatchTaskExecutorOutput.getOutput(), DispatchTaskStatus.SUCCESSFUL);
        }
        catch (Throwable throwable) {
            String error = dispatchTaskExecutorOutput.getError();
            if (Validator.isNull((String)error) && Validator.isNull((String)(error = throwable.getMessage()))) {
                Class<?> throwableClass = throwable.getClass();
                error = "Unable to execute due " + throwableClass.getName();
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to execute task", throwable);
                }
            }
            dispatchLogLocalService.updateDispatchLog(dispatchLog.getDispatchLogId(), new Date(), error, dispatchTaskExecutorOutput.getOutput(), DispatchTaskStatus.FAILED);
        }
    }
}

