/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.exporter;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DDLExporterFactory.class})
public class DDLExporterFactory {
    private final Map<String, DDLExporter> _ddlExporters = new ConcurrentHashMap<String, DDLExporter>();

    public Set<String> getAvailableFormats() {
        return Collections.unmodifiableSet(this._ddlExporters.keySet());
    }

    public DDLExporter getDDLExporter(String format) {
        DDLExporter ddlExporter = this._ddlExporters.get(format);
        if (ddlExporter == null) {
            throw new IllegalArgumentException("No DDL exporter exists for the format " + format);
        }
        return ddlExporter;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="removeDDLExporter")
    protected void addDDLExporter(DDLExporter ddlExporter) {
        this._ddlExporters.put(ddlExporter.getFormat(), ddlExporter);
    }

    protected void removeDDLExporter(DDLExporter ddlExporter) {
        this._ddlExporters.remove(ddlExporter.getFormat());
    }
}

