/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal;

import com.liferay.dynamic.data.mapping.form.field.type.BaseDDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.io.DDMFormFieldTypesJSONSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutJSONSerializer;
import com.liferay.dynamic.data.mapping.io.internal.DDMFormFieldTypeSettingsSerializerHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMFormFieldTypesJSONSerializerImpl
implements DDMFormFieldTypesJSONSerializer {
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private DDMFormJSONSerializer _ddmFormJSONSerializer;
    private DDMFormLayoutJSONSerializer _ddmFormLayoutJSONSerializer;
    private JSONFactory _jsonFactory;

    @Override
    public String serialize(List<DDMFormFieldType> ddmFormFieldTypes) throws PortalException {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDMFormFieldType ddmFormFieldType : ddmFormFieldTypes) {
            jsonArray.put(this.toJSONObject(ddmFormFieldType));
        }
        return jsonArray.toString();
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    @Reference(unbind="-")
    protected void setDDMFormJSONSerializer(DDMFormJSONSerializer ddmFormJSONSerializer) {
        this._ddmFormJSONSerializer = ddmFormJSONSerializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormLayoutJSONSerializer(DDMFormLayoutJSONSerializer ddmFormLayoutJSONSerializer) {
        this._ddmFormLayoutJSONSerializer = ddmFormLayoutJSONSerializer;
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected JSONObject toJSONObject(DDMFormFieldType ddmFormFieldType) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        Map ddmFormFieldTypeProperties = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypeProperties(ddmFormFieldType.getName());
        jsonObject.put("icon", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.icon", (String)"icon-ok-circle"));
        jsonObject.put("javaScriptClass", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.js.class.name", (String)"Liferay.DDM.Renderer.Field"));
        jsonObject.put("javaScriptModule", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.js.module", (String)"liferay-ddm-form-renderer-field"));
        jsonObject.put("name", ddmFormFieldType.getName());
        DDMFormFieldTypeSettingsSerializerHelper ddmFormFieldTypeSettingsSerializerHelper = new DDMFormFieldTypeSettingsSerializerHelper(ddmFormFieldType.getDDMFormFieldTypeSettings(), this._ddmFormJSONSerializer, this._ddmFormLayoutJSONSerializer, this._jsonFactory);
        jsonObject.put("settings", ddmFormFieldTypeSettingsSerializerHelper.getSettingsJSONObject());
        jsonObject.put("settingsLayout", ddmFormFieldTypeSettingsSerializerHelper.getSettingsLayoutJSONObject());
        jsonObject.put("system", MapUtil.getBoolean((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.system"));
        DDMFormFieldRenderer ddmFormFieldRenderer = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldRenderer(ddmFormFieldType.getName());
        if (ddmFormFieldRenderer instanceof BaseDDMFormFieldRenderer) {
            BaseDDMFormFieldRenderer baseDDMFormFieldRenderer = (BaseDDMFormFieldRenderer)ddmFormFieldRenderer;
            jsonObject.put("templateNamespace", baseDDMFormFieldRenderer.getTemplateNamespace());
        }
        return jsonObject;
    }
}

