/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldTypeSettings;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMFormJSONSerializerImpl
implements DDMFormJSONSerializer {
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private JSONFactory _jsonFactory;

    @Override
    public String serialize(DDMForm ddmForm) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this.addAvailableLanguageIds(jsonObject, ddmForm.getAvailableLocales());
        this.addDefaultLanguageId(jsonObject, ddmForm.getDefaultLocale());
        this.addFields(jsonObject, ddmForm.getDDMFormFields());
        return jsonObject.toString();
    }

    protected void addAvailableLanguageIds(JSONObject jsonObject, Set<Locale> availableLocales) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (Locale availableLocale : availableLocales) {
            jsonArray.put(LocaleUtil.toLanguageId((Locale)availableLocale));
        }
        jsonObject.put("availableLanguageIds", jsonArray);
    }

    protected void addDefaultLanguageId(JSONObject jsonObject, Locale defaultLocale) {
        jsonObject.put("defaultLanguageId", LocaleUtil.toLanguageId((Locale)defaultLocale));
    }

    protected void addFields(JSONObject jsonObject, List<DDMFormField> ddmFormFields) {
        jsonObject.put("fields", this.toJSONArray(ddmFormFields));
    }

    protected void addNestedFields(JSONObject jsonObject, List<DDMFormField> nestedDDMFormFields) {
        if (nestedDDMFormFields.isEmpty()) {
            return;
        }
        jsonObject.put("nestedFields", this.toJSONArray(nestedDDMFormFields));
    }

    protected void addProperties(JSONObject jsonObject, DDMFormField ddmFormField) {
        DDMForm ddmFormFieldTypeSettingsDDMForm = this.getDDMFormFieldTypeSettingsDDMForm(ddmFormField.getType());
        for (DDMFormField ddmFormFieldTypeSetting : ddmFormFieldTypeSettingsDDMForm.getDDMFormFields()) {
            this.addProperty(jsonObject, ddmFormField, ddmFormFieldTypeSetting);
        }
    }

    protected void addProperty(JSONObject jsonObject, DDMFormField ddmFormField, DDMFormField ddmFormFieldTypeSetting) {
        Object property = ddmFormField.getProperty(ddmFormFieldTypeSetting.getName());
        if (property == null) {
            return;
        }
        this.addProperty(jsonObject, ddmFormFieldTypeSetting.getName(), this.serializeDDMFormFieldProperty(property, ddmFormFieldTypeSetting));
    }

    protected void addProperty(JSONObject jsonObject, String propertyName, Object propertyValue) {
        if (propertyValue == null) {
            return;
        }
        jsonObject.put(propertyName, propertyValue);
    }

    protected DDMForm getDDMFormFieldTypeSettingsDDMForm(String type) {
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(type);
        Class ddmFormFieldTypeSettings = DefaultDDMFormFieldTypeSettings.class;
        if (ddmFormFieldType != null) {
            ddmFormFieldTypeSettings = ddmFormFieldType.getDDMFormFieldTypeSettings();
        }
        return DDMFormFactory.create(ddmFormFieldTypeSettings);
    }

    protected Object serializeDDMFormFieldProperty(Object property, DDMFormField ddmFormFieldTypeSetting) {
        if (ddmFormFieldTypeSetting.isLocalizable()) {
            return this.toJSONObject((LocalizedValue)property);
        }
        String dataType = ddmFormFieldTypeSetting.getDataType();
        if (Validator.equals((Object)dataType, (Object)"boolean")) {
            return GetterUtil.getBoolean((Object)property);
        }
        if (Validator.equals((Object)dataType, (Object)"ddm-options")) {
            return this.toJSONArray((DDMFormFieldOptions)property);
        }
        if (Validator.equals((Object)dataType, (Object)"ddm-validation")) {
            return this.toJSONObject((DDMFormFieldValidation)property);
        }
        return String.valueOf(property);
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected JSONArray toJSONArray(DDMFormFieldOptions ddmFormFieldOptions) {
        Set optionValues = ddmFormFieldOptions.getOptionsValues();
        if (optionValues.isEmpty()) {
            return null;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (String optionValue : optionValues) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            jsonObject.put("value", optionValue);
            jsonObject.put("label", this.toJSONObject(ddmFormFieldOptions.getOptionLabels(optionValue)));
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    protected JSONArray toJSONArray(List<DDMFormField> ddmFormFields) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDMFormField ddmFormField : ddmFormFields) {
            jsonArray.put(this.toJSONObject(ddmFormField));
        }
        return jsonArray;
    }

    protected JSONObject toJSONObject(DDMFormField ddmFormField) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this.addProperties(jsonObject, ddmFormField);
        this.addNestedFields(jsonObject, ddmFormField.getNestedDDMFormFields());
        return jsonObject;
    }

    protected JSONObject toJSONObject(DDMFormFieldValidation ddmFormFieldValidation) {
        if (ddmFormFieldValidation == null) {
            return null;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("errorMessage", ddmFormFieldValidation.getErrorMessage());
        jsonObject.put("expression", ddmFormFieldValidation.getExpression());
        return jsonObject;
    }

    protected JSONObject toJSONObject(LocalizedValue localizedValue) {
        Map values = localizedValue.getValues();
        if (values.isEmpty()) {
            return null;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (Locale availableLocale : localizedValue.getAvailableLocales()) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), localizedValue.getString(availableLocale));
        }
        return jsonObject;
    }
}

