/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal;

import com.liferay.dynamic.data.mapping.io.DDMFormLayoutJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMFormLayoutJSONDeserializerImpl
implements DDMFormLayoutJSONDeserializer {
    private JSONFactory _jsonFactory;

    @Override
    public DDMFormLayout deserialize(String serializedDDMFormLayout) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(serializedDDMFormLayout);
        DDMFormLayout ddmFormLayout = new DDMFormLayout();
        this.setDDMFormLayoutDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmFormLayout);
        this.setDDMFormLayoutPages(jsonObject.getJSONArray("pages"), ddmFormLayout);
        this.setDDMFormLayoutPageTitlesDefaultLocale(ddmFormLayout);
        this._setDDMFormLayoutPaginationMode(jsonObject.getString("paginationMode"), ddmFormLayout);
        return ddmFormLayout;
    }

    protected DDMFormLayoutColumn getDDMFormLayoutColumn(JSONObject jsonObject) {
        DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn(jsonObject.getInt("size"), new String[0]);
        this.setDDMFormLayouColumnFieldNames(jsonObject.getJSONArray("fieldNames"), ddmFormLayoutColumn);
        return ddmFormLayoutColumn;
    }

    protected List<String> getDDMFormLayoutColumnFieldNames(JSONArray jsonArray) {
        ArrayList<String> ddmFormFieldNames = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ddmFormFieldNames.add(jsonArray.getString(i));
        }
        return ddmFormFieldNames;
    }

    protected List<DDMFormLayoutColumn> getDDMFormLayoutColumns(JSONArray jsonArray) {
        ArrayList<DDMFormLayoutColumn> ddmFormLayoutColumns = new ArrayList<DDMFormLayoutColumn>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormLayoutColumn ddmFormLayoutColumn = this.getDDMFormLayoutColumn(jsonArray.getJSONObject(i));
            ddmFormLayoutColumns.add(ddmFormLayoutColumn);
        }
        return ddmFormLayoutColumns;
    }

    protected DDMFormLayoutPage getDDMFormLayoutPage(JSONObject jsonObject) {
        DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
        this.setDDMFormLayoutPageDescription(jsonObject.getJSONObject("description"), ddmFormLayoutPage);
        this.setDDMFormLayoutPageRows(jsonObject.getJSONArray("rows"), ddmFormLayoutPage);
        this.setDDMFormLayoutPageTitle(jsonObject.getJSONObject("title"), ddmFormLayoutPage);
        return ddmFormLayoutPage;
    }

    protected List<DDMFormLayoutPage> getDDMFormLayoutPages(JSONArray jsonArray) {
        ArrayList<DDMFormLayoutPage> ddmFormLayoutPages = new ArrayList<DDMFormLayoutPage>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormLayoutPage ddmFormLayoutPage = this.getDDMFormLayoutPage(jsonArray.getJSONObject(i));
            ddmFormLayoutPages.add(ddmFormLayoutPage);
        }
        return ddmFormLayoutPages;
    }

    protected DDMFormLayoutRow getDDMFormLayoutRow(JSONObject jsonObject) {
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        this.setDDMFormLayoutRowColumns(jsonObject.getJSONArray("columns"), ddmFormLayoutRow);
        return ddmFormLayoutRow;
    }

    protected List<DDMFormLayoutRow> getDDMFormLayoutRows(JSONArray jsonArray) {
        ArrayList<DDMFormLayoutRow> ddmFormLayoutRows = new ArrayList<DDMFormLayoutRow>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormLayoutRow ddmFormLayoutRow = this.getDDMFormLayoutRow(jsonArray.getJSONObject(i));
            ddmFormLayoutRows.add(ddmFormLayoutRow);
        }
        return ddmFormLayoutRows;
    }

    protected LocalizedValue getTitle(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        LocalizedValue title = new LocalizedValue();
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            title.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return title;
    }

    protected void setDDMFormLayouColumnFieldNames(JSONArray jsonArray, DDMFormLayoutColumn ddmFormLayoutColumn) {
        List<String> ddmFormLayoutColumnNames = this.getDDMFormLayoutColumnFieldNames(jsonArray);
        ddmFormLayoutColumn.setDDMFormFieldNames(ddmFormLayoutColumnNames);
    }

    protected void setDDMFormLayoutDefaultLocale(String defaultLanguageId, DDMFormLayout ddmFormLayout) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmFormLayout.setDefaultLocale(defaultLocale);
    }

    protected void setDDMFormLayoutPageDescription(JSONObject jsonObject, DDMFormLayoutPage ddmFormLayoutPage) {
        LocalizedValue description = this._getDescription(jsonObject);
        if (description == null) {
            return;
        }
        ddmFormLayoutPage.setDescription(description);
    }

    protected void setDDMFormLayoutPageRows(JSONArray jsonArray, DDMFormLayoutPage ddmFormLayoutPage) {
        List<DDMFormLayoutRow> ddmFormLayoutRows = this.getDDMFormLayoutRows(jsonArray);
        ddmFormLayoutPage.setDDMFormLayoutRows(ddmFormLayoutRows);
    }

    protected void setDDMFormLayoutPages(JSONArray jsonArray, DDMFormLayout ddmFormLayout) {
        List<DDMFormLayoutPage> ddmFormLayoutPages = this.getDDMFormLayoutPages(jsonArray);
        ddmFormLayout.setDDMFormLayoutPages(ddmFormLayoutPages);
    }

    protected void setDDMFormLayoutPageTitle(JSONObject jsonObject, DDMFormLayoutPage ddmFormLayoutPage) {
        LocalizedValue title = this.getTitle(jsonObject);
        if (title == null) {
            return;
        }
        ddmFormLayoutPage.setTitle(title);
    }

    protected void setDDMFormLayoutPageTitlesDefaultLocale(DDMFormLayout ddmFormLayout) {
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            LocalizedValue title = ddmFormLayoutPage.getTitle();
            title.setDefaultLocale(ddmFormLayout.getDefaultLocale());
        }
    }

    protected void setDDMFormLayoutRowColumns(JSONArray jsonArray, DDMFormLayoutRow ddmFormLayoutRow) {
        List<DDMFormLayoutColumn> ddmFormLayoutColumns = this.getDDMFormLayoutColumns(jsonArray);
        ddmFormLayoutRow.setDDMFormLayoutColumns(ddmFormLayoutColumns);
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    private LocalizedValue _getDescription(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        LocalizedValue description = new LocalizedValue();
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            description.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return description;
    }

    private void _setDDMFormLayoutPaginationMode(String paginationMode, DDMFormLayout ddmFormLayout) {
        ddmFormLayout.setPaginationMode(paginationMode);
    }
}

