/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal;

import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.form.layout.serializer.type=json"}, service={DDMFormLayoutSerializer.class})
public class DDMFormLayoutJSONSerializer
implements DDMFormLayoutSerializer {
    private JSONFactory _jsonFactory;

    public DDMFormLayoutSerializerSerializeResponse serialize(DDMFormLayoutSerializerSerializeRequest ddmFormLayoutSerializerSerializeRequest) {
        DDMFormLayout ddmFormLayout = ddmFormLayoutSerializerSerializeRequest.getDDMFormLayout();
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this.addDefaultLanguageId(jsonObject, ddmFormLayout.getDefaultLocale());
        this.addPages(jsonObject, ddmFormLayout.getDDMFormLayoutPages());
        this.addPaginationMode(jsonObject, ddmFormLayout.getPaginationMode());
        DDMFormLayoutSerializerSerializeResponse.Builder builder = DDMFormLayoutSerializerSerializeResponse.Builder.newBuilder((String)jsonObject.toString());
        return builder.build();
    }

    protected void addColumns(JSONObject jsonObject, List<DDMFormLayoutColumn> ddmFormLayoutColumns) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutColumns) {
            jsonArray.put(this.toJSONObject(ddmFormLayoutColumn));
        }
        jsonObject.put("columns", jsonArray);
    }

    protected void addDefaultLanguageId(JSONObject jsonObject, Locale defaultLocale) {
        jsonObject.put("defaultLanguageId", LocaleUtil.toLanguageId((Locale)defaultLocale));
    }

    protected void addDescription(JSONObject pageJSONObject, LocalizedValue description) {
        Map values = description.getValues();
        if (values.isEmpty()) {
            return;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (Locale availableLocale : description.getAvailableLocales()) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), description.getString(availableLocale));
        }
        pageJSONObject.put("description", jsonObject);
    }

    protected void addFieldNames(JSONObject jsonObject, List<String> ddmFormFieldNames) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (String ddmFormFieldName : ddmFormFieldNames) {
            jsonArray.put(ddmFormFieldName);
        }
        jsonObject.put("fieldNames", jsonArray);
    }

    protected void addPages(JSONObject jsonObject, List<DDMFormLayoutPage> ddmFormLayoutPages) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayoutPages) {
            jsonArray.put(this.toJSONObject(ddmFormLayoutPage));
        }
        jsonObject.put("pages", jsonArray);
    }

    protected void addPaginationMode(JSONObject jsonObject, String paginationMode) {
        jsonObject.put("paginationMode", paginationMode);
    }

    protected void addRows(JSONObject jsonObject, List<DDMFormLayoutRow> ddmFormLayoutRows) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutRows) {
            jsonArray.put(this.toJSONObject(ddmFormLayoutRow));
        }
        jsonObject.put("rows", jsonArray);
    }

    protected void addTitle(JSONObject pageJSONObject, LocalizedValue title) {
        Map values = title.getValues();
        if (values.isEmpty()) {
            return;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (Locale availableLocale : title.getAvailableLocales()) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), title.getString(availableLocale));
        }
        pageJSONObject.put("title", jsonObject);
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected JSONObject toJSONObject(DDMFormLayoutColumn ddmFormLayoutColumn) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("size", ddmFormLayoutColumn.getSize());
        this.addFieldNames(jsonObject, ddmFormLayoutColumn.getDDMFormFieldNames());
        return jsonObject;
    }

    protected JSONObject toJSONObject(DDMFormLayoutPage ddmFormLayoutPage) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this.addDescription(jsonObject, ddmFormLayoutPage.getDescription());
        this.addRows(jsonObject, ddmFormLayoutPage.getDDMFormLayoutRows());
        this.addTitle(jsonObject, ddmFormLayoutPage.getTitle());
        return jsonObject;
    }

    protected JSONObject toJSONObject(DDMFormLayoutRow ddmFormLayoutRow) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this.addColumns(jsonObject, ddmFormLayoutRow.getDDMFormLayoutColumns());
        return jsonObject;
    }
}

