/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal;

import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerTracker;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DDMFormSerializerTracker.class})
public class DDMFormSerializerTrackerImpl
implements DDMFormSerializerTracker {
    private final Map<String, DDMFormSerializer> _ddmFormSerializers = new TreeMap<String, DDMFormSerializer>();

    public DDMFormSerializer getDDMFormSerializer(String type) {
        return this._ddmFormSerializers.get(type);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDDMFormSerializer(DDMFormSerializer ddmFormSerializer, Map<String, Object> properties) {
        String type = MapUtil.getString(properties, (String)"ddm.form.serializer.type");
        this._ddmFormSerializers.put(type, ddmFormSerializer);
    }

    @Deactivate
    protected void deactivate() {
        this._ddmFormSerializers.clear();
    }

    protected void removeDDMFormSerializer(DDMFormSerializer ddmFormSerializer, Map<String, Object> properties) {
        String type = MapUtil.getString(properties, (String)"ddm.form.serializer.type");
        this._ddmFormSerializers.remove(type);
    }
}

