/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.web.internal.portlet.action;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationFactory;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationHelper;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationService;
import com.liferay.exportimport.kernel.service.ExportImportService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.ui.util.SessionTreeJSClicks;
import com.liferay.trash.kernel.service.TrashEntryService;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.ArrayList;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_exportimport_web_portlet_ExportPortlet", "mvc.command.name=editExportConfiguration"}, service={MVCActionCommand.class})
public class EditExportConfigurationMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    protected BackgroundTaskManager backgroundTaskManager;
    protected ExportImportConfigurationLocalService exportImportConfigurationLocalService;
    @Reference
    protected ExportImportHelper exportImportHelper;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(EditExportConfigurationMVCActionCommand.class);
    private ExportImportConfigurationService _exportImportConfigurationService;
    private ExportImportService _exportImportService;
    private TrashEntryService _trashEntryService;

    protected void addSessionMessages(ActionRequest actionRequest) throws Exception {
        String portletId = this.portal.getPortletId((PortletRequest)actionRequest);
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "exportImportConfigurationId"), (Object)exportImportConfigurationId);
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "name"), (Object)name);
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "description"), (Object)description);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Map settingsMap = ExportImportConfigurationSettingsMapFactory.buildSettingsMap((PortletRequest)actionRequest, (long)groupId, (int)0);
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "settingsMap"), (Object)settingsMap);
    }

    protected void deleteExportImportConfiguration(ActionRequest actionRequest, boolean moveToTrash) throws PortalException {
        long[] deleteExportImportConfigurationIds = null;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        deleteExportImportConfigurationIds = exportImportConfigurationId > 0L ? new long[]{exportImportConfigurationId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteExportImportConfigurationIds"), (long)0L);
        ArrayList<ExportImportConfiguration> trashedModels = new ArrayList<ExportImportConfiguration>();
        for (long deleteExportImportConfigurationId : deleteExportImportConfigurationIds) {
            if (moveToTrash) {
                ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationService.moveExportImportConfigurationToTrash(deleteExportImportConfigurationId);
                trashedModels.add(exportImportConfiguration);
                continue;
            }
            this._exportImportConfigurationService.deleteExportImportConfiguration(deleteExportImportConfigurationId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.setLayoutIdMap(actionRequest);
                this.updateExportConfiguration(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteExportImportConfiguration(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteExportImportConfiguration(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreTrashEntries(actionRequest);
            } else if (cmd.equals("relaunch")) {
                this.relaunchExportLayoutConfiguration(actionRequest);
            } else if (Validator.isNull((String)cmd)) {
                this.addSessionMessages(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
        }
    }

    protected void relaunchExportLayoutConfiguration(ActionRequest actionRequest) throws Exception {
        long backgroundTaskId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"backgroundTaskId");
        BackgroundTask backgroundTask = this.backgroundTaskManager.getBackgroundTask(backgroundTaskId);
        Map taskContextMap = backgroundTask.getTaskContextMap();
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(MapUtil.getLong((Map)taskContextMap, (String)"exportImportConfigurationId"));
        exportImportConfiguration = ExportImportConfigurationFactory.cloneExportImportConfiguration((ExportImportConfiguration)exportImportConfiguration);
        this._exportImportService.exportLayoutsAsFileInBackground(exportImportConfiguration);
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this.exportImportConfigurationLocalService = exportImportConfigurationLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationService(ExportImportConfigurationService exportImportConfigurationService) {
        this._exportImportConfigurationService = exportImportConfigurationService;
    }

    @Reference(unbind="-")
    protected void setExportImportService(ExportImportService exportImportService) {
        this._exportImportService = exportImportService;
    }

    protected void setLayoutIdMap(ActionRequest actionRequest) {
        HttpServletRequest portletRequest = this.portal.getHttpServletRequest((PortletRequest)actionRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        String treeId = ParamUtil.getString((PortletRequest)actionRequest, (String)"treeId");
        String openNodes = SessionTreeJSClicks.getOpenNodes((HttpServletRequest)portletRequest, (String)(treeId + "SelectedNode"));
        String selectedLayoutsJSON = this.exportImportHelper.getSelectedLayoutsJSON(groupId, privateLayout, openNodes);
        actionRequest.setAttribute("layoutIdMap", (Object)selectedLayoutsJSON);
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }

    protected ExportImportConfiguration updateExportConfiguration(ActionRequest actionRequest) throws Exception {
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        if (exportImportConfigurationId > 0L) {
            return ExportImportConfigurationHelper.updateExportLayoutExportImportConfiguration((PortletRequest)actionRequest);
        }
        return ExportImportConfigurationHelper.addExportLayoutExportImportConfiguration((PortletRequest)actionRequest);
    }
}

