/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.web.internal.portlet.action;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationHelper;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.exportimport.web.internal.portlet.action.EditExportConfigurationMVCActionCommand;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_exportimport_web_portlet_ExportImportPortlet", "mvc.command.name=editPublishConfiguration"}, service={MVCActionCommand.class})
public class EditPublishConfigurationMVCActionCommand
extends EditExportConfigurationMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditPublishConfigurationMVCActionCommand.class);

    @Override
    protected void addSessionMessages(ActionRequest actionRequest) throws Exception {
        String portletId = this.portal.getPortletId((PortletRequest)actionRequest);
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "exportImportConfigurationId"), (Object)exportImportConfigurationId);
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "name"), (Object)name);
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "description"), (Object)description);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        int exportImportConfigurationType = 2;
        boolean localPublishing = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"localPublishing");
        if (localPublishing) {
            exportImportConfigurationType = 1;
        }
        Map settingsMap = ExportImportConfigurationSettingsMapFactory.buildSettingsMap((PortletRequest)actionRequest, (long)groupId, (int)exportImportConfigurationType);
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "settingsMap"), (Object)settingsMap);
    }

    @Override
    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
            if (cmd.equals("add") || cmd.equals("update")) {
                this.setLayoutIdMap(actionRequest);
                this.updatePublishConfiguration(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteExportImportConfiguration(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteExportImportConfiguration(actionRequest, true);
            } else if (cmd.equals("publish_to_live")) {
                this.setBackgroundTaskName(actionRequest, exportImportConfigurationId);
                this.setRedirect(actionRequest, actionResponse, StagingUtil.publishLayouts((long)themeDisplay.getUserId(), (long)exportImportConfigurationId));
            } else if (cmd.equals("publish_to_remote")) {
                this.setBackgroundTaskName(actionRequest, exportImportConfigurationId);
                this.setRedirect(actionRequest, actionResponse, StagingUtil.copyRemoteLayouts((long)exportImportConfigurationId));
            } else if (cmd.equals("relaunch")) {
                this.relaunchPublishLayoutConfiguration(themeDisplay.getUserId(), actionRequest);
            } else if (Validator.isNull((String)cmd)) {
                this.addSessionMessages(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        }
    }

    protected void relaunchPublishLayoutConfiguration(long userId, ActionRequest actionRequest) throws PortalException {
        long backgroundTaskId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"backgroundTaskId");
        BackgroundTask backgroundTask = BackgroundTaskManagerUtil.getBackgroundTask((long)backgroundTaskId);
        Map taskContextMap = backgroundTask.getTaskContextMap();
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(MapUtil.getLong((Map)taskContextMap, (String)"exportImportConfigurationId"));
        if (exportImportConfiguration.getType() == 1) {
            StagingUtil.publishLayouts((long)userId, (ExportImportConfiguration)exportImportConfiguration);
        } else if (exportImportConfiguration.getType() == 2) {
            StagingUtil.copyRemoteLayouts((ExportImportConfiguration)exportImportConfiguration);
        }
    }

    protected void setBackgroundTaskName(ActionRequest actionRequest, long exportImportConfigurationId) throws PortalException {
        String name = actionRequest.getParameter("name");
        if (Validator.isBlank((String)name)) {
            return;
        }
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        parameterMap.put("name", new String[]{name});
        String settings = JSONFactoryUtil.serialize((Object)settingsMap);
        exportImportConfiguration.setSettings(settings);
        this.exportImportConfigurationLocalService.updateExportImportConfiguration(exportImportConfiguration);
    }

    protected void setRedirect(ActionRequest actionRequest, ActionResponse actionResponse, long backgroundTaskId) {
        LiferayPortletResponse liferayPortletResponse = this.portal.getLiferayPortletResponse((PortletResponse)actionResponse);
        PortletURL renderURL = liferayPortletResponse.createRenderURL();
        renderURL.setParameter("mvcPath", "/view_export_import.jsp");
        renderURL.setParameter("backgroundTaskId", String.valueOf(backgroundTaskId));
        actionRequest.setAttribute("REDIRECT", (Object)renderURL.toString());
    }

    protected ExportImportConfiguration updatePublishConfiguration(ActionRequest actionRequest) throws Exception {
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        boolean localPublishing = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"localPublishing");
        if (exportImportConfigurationId > 0L) {
            if (localPublishing) {
                return ExportImportConfigurationHelper.updatePublishLayoutLocalExportImportConfiguration((PortletRequest)actionRequest);
            }
            return ExportImportConfigurationHelper.updatePublishLayoutRemoteExportImportConfiguration((PortletRequest)actionRequest);
        }
        if (localPublishing) {
            return ExportImportConfigurationHelper.addPublishLayoutLocalExportImportConfiguration((PortletRequest)actionRequest);
        }
        return ExportImportConfigurationHelper.addPublishLayoutRemoteExportImportConfiguration((PortletRequest)actionRequest);
    }
}

