/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.web.internal.portlet.action;

import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.exception.LARFileException;
import com.liferay.exportimport.kernel.exception.LARFileSizeException;
import com.liferay.exportimport.kernel.exception.LARTypeException;
import com.liferay.exportimport.kernel.exception.LayoutImportException;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.kernel.service.ExportImportService;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.exception.LayoutPrototypeException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_exportimport_web_portlet_ImportPortlet", "mvc.command.name=importLayouts"}, service={ImportLayoutsMVCActionCommand.class, MVCActionCommand.class})
public class ImportLayoutsMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(ImportLayoutsMVCActionCommand.class);
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    private ExportImportService _exportImportService;
    private LayoutService _layoutService;
    @Reference
    private Portal _portal;
    @Reference
    private Staging _staging;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTempFileEntry(ActionRequest actionRequest, String folderName) throws Exception {
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        this.checkExceededSizeLimit((HttpServletRequest)uploadPortletRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        this.deleteTempFileEntry(groupId, folderName);
        InputStream inputStream = null;
        try {
            String sourceFileName = uploadPortletRequest.getFileName("file");
            inputStream = uploadPortletRequest.getFileAsStream("file");
            String contentType = uploadPortletRequest.getContentType("file");
            this._layoutService.addTempFileEntry(groupId, folderName, sourceFileName, inputStream, contentType);
        }
        catch (Exception e) {
            block8: {
                try {
                    UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                    if (uploadException != null) {
                        Throwable cause = uploadException.getCause();
                        if (cause instanceof FileUploadBase.IOFileUploadException && _log.isInfoEnabled()) {
                            _log.info((Object)"Temporary upload was cancelled");
                        }
                        if (uploadException.isExceededFileSizeLimit()) {
                            throw new FileSizeException(cause);
                        }
                        if (uploadException.isExceededUploadRequestSizeLimit()) {
                            throw new UploadRequestSizeException(cause);
                        }
                        break block8;
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected void checkExceededSizeLimit(HttpServletRequest request) throws PortalException {
        UploadException uploadException = (UploadException)request.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            Throwable cause = uploadException.getCause();
            if (uploadException.isExceededFileSizeLimit() || uploadException.isExceededUploadRequestSizeLimit()) {
                throw new LARFileSizeException(cause);
            }
            throw new PortalException(cause);
        }
    }

    protected void deleteTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
            this._layoutService.deleteTempFileEntry(themeDisplay.getScopeGroupId(), folderName, fileName);
            jsonObject.put("deleted", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            String errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", (Object)Boolean.FALSE);
            jsonObject.put("errorMessage", errorMessage);
        }
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }

    protected void deleteTempFileEntry(long groupId, String folderName) throws PortalException {
        String[] tempFileNames;
        for (String tempFileEntryName : tempFileNames = this._layoutService.getTempFileNames(groupId, folderName)) {
            this._layoutService.deleteTempFileEntry(groupId, folderName, tempFileEntryName);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add_temp")) {
                this.addTempFileEntry(actionRequest, ExportImportHelper.TEMP_FOLDER_NAME);
                this.validateFile(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            } else if (cmd.equals("delete_temp")) {
                this.deleteTempFileEntry(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME);
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            } else if (cmd.equals("import")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this.importData(actionRequest, ExportImportHelper.TEMP_FOLDER_NAME);
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e) {
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this.handleUploadException(actionRequest, actionResponse, ExportImportHelper.TEMP_FOLDER_NAME, e);
            }
            if (e instanceof LARFileException || e instanceof LARFileSizeException || e instanceof LARTypeException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof LayoutPrototypeException || e instanceof LocaleException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, (String)LayoutImportException.class.getName());
        }
    }

    protected void handleUploadException(ActionRequest actionRequest, ActionResponse actionResponse, String folderName, Exception e) throws Exception {
        HttpServletResponse response = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
        response.setContentType("text/html");
        response.setStatus(200);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.deleteTempFileEntry(themeDisplay.getScopeGroupId(), folderName);
        JSONObject jsonObject = this._staging.getExceptionMessagesJSONObject(themeDisplay.getLocale(), e, (ExportImportConfiguration)null);
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importData(ActionRequest actionRequest, String folderName) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        FileEntry fileEntry = this._exportImportHelper.getTempFileEntry(groupId, themeDisplay.getUserId(), folderName);
        InputStream inputStream = null;
        try {
            inputStream = this._dlFileEntryLocalService.getFileAsStream(fileEntry.getFileEntryId(), fileEntry.getVersion(), false);
            this.importData(actionRequest, fileEntry.getTitle(), inputStream);
            this.deleteTempFileEntry(groupId, folderName);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected void importData(ActionRequest actionRequest, String fileName, InputStream inputStream) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactory.buildImportLayoutSettingsMap((long)themeDisplay.getUserId(), (long)groupId, (boolean)privateLayout, null, (Map)actionRequest.getParameterMap(), (Locale)themeDisplay.getLocale(), (TimeZone)themeDisplay.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(themeDisplay.getUserId(), 6, importLayoutSettingsMap);
        this._exportImportService.importLayoutsInBackground(exportImportConfiguration, inputStream);
    }

    @Reference(unbind="-")
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this._exportImportConfigurationLocalService = exportImportConfigurationLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportService(ExportImportService exportImportService) {
        this._exportImportService = exportImportService;
    }

    @Reference(unbind="-")
    protected void setLayoutService(LayoutService layoutService) {
        this._layoutService = layoutService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateFile(ActionRequest actionRequest, ActionResponse actionResponse, String folderName) throws Exception {
        Map weakMissingReferences;
        InputStream inputStream;
        ThemeDisplay themeDisplay;
        block4: {
            themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            FileEntry fileEntry = this._exportImportHelper.getTempFileEntry(groupId, themeDisplay.getUserId(), folderName);
            inputStream = null;
            try {
                inputStream = this._dlFileEntryLocalService.getFileAsStream(fileEntry.getFileEntryId(), fileEntry.getVersion(), false);
                MissingReferences missingReferences = this.validateFile(actionRequest, inputStream);
                weakMissingReferences = missingReferences.getWeakMissingReferences();
                if (!weakMissingReferences.isEmpty()) break block4;
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            return;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (weakMissingReferences != null && !weakMissingReferences.isEmpty()) {
            jsonObject.put("warningMessages", this._staging.getWarningMessagesJSONArray(themeDisplay.getLocale(), weakMissingReferences));
        }
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
    }

    protected MissingReferences validateFile(ActionRequest actionRequest, InputStream inputStream) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        Map importLayoutSettingsMap = ExportImportConfigurationSettingsMapFactory.buildImportLayoutSettingsMap((long)themeDisplay.getUserId(), (long)groupId, (boolean)privateLayout, null, (Map)actionRequest.getParameterMap(), (Locale)themeDisplay.getLocale(), (TimeZone)themeDisplay.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.addDraftExportImportConfiguration(themeDisplay.getUserId(), 6, importLayoutSettingsMap);
        return this._exportImportService.validateImportLayoutsFile(exportImportConfiguration, inputStream);
    }
}

