/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.web.internal.portlet.action;

import com.liferay.exportimport.kernel.exception.RemoteExportException;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.exception.LayoutPrototypeException;
import com.liferay.portal.kernel.exception.RemoteOptionsException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.RemoteAuthException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.ui.util.SessionTreeJSClicks;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_exportimport_web_portlet_ExportImportPortlet", "mvc.command.name=publishLayouts"}, service={MVCActionCommand.class})
public class PublishLayoutsMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private Portal _portal;
    @Reference
    private Staging _staging;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (Validator.isNull((String)cmd)) {
            SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".forceSendRedirect"));
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            return;
        }
        try {
            if (cmd.equals("copy_from_live")) {
                this.setLayoutIdMap(actionRequest);
                this._staging.copyFromLive((PortletRequest)actionRequest);
            } else if (cmd.equals("publish_to_live")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this.setLayoutIdMap(actionRequest);
                this.setRedirect(actionRequest, actionResponse, this._staging.publishToLive((PortletRequest)actionRequest));
            } else if (cmd.equals("publish_to_remote")) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                this.setLayoutIdMap(actionRequest);
                this.setRedirect(actionRequest, actionResponse, this._staging.publishToRemote((PortletRequest)actionRequest));
            } else if (cmd.equals("schedule_copy_from_live")) {
                this.setLayoutIdMap(actionRequest);
                this._staging.scheduleCopyFromLive((PortletRequest)actionRequest);
            } else if (cmd.equals("schedule_publish_to_live")) {
                this.setLayoutIdMap(actionRequest);
                this._staging.schedulePublishToLive((PortletRequest)actionRequest);
            } else if (cmd.equals("schedule_publish_to_remote")) {
                this.setLayoutIdMap(actionRequest);
                this._staging.schedulePublishToRemote((PortletRequest)actionRequest);
            } else if (cmd.equals("unschedule_copy_from_live")) {
                this._staging.unscheduleCopyFromLive((PortletRequest)actionRequest);
            } else if (cmd.equals("unschedule_publish_to_live")) {
                this._staging.unschedulePublishToLive((PortletRequest)actionRequest);
            } else if (cmd.equals("unschedule_publish_to_remote")) {
                this._staging.unschedulePublishToRemote((PortletRequest)actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof AuthException || e instanceof DuplicateLockException || e instanceof LayoutPrototypeException || e instanceof RemoteAuthException || e instanceof RemoteExportException || e instanceof RemoteOptionsException || e instanceof SystemException) {
                if (e instanceof RemoteAuthException) {
                    SessionErrors.add((PortletRequest)actionRequest, AuthException.class, (Object)e);
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
                }
                this.sendRedirect(actionRequest, actionResponse);
            }
            throw e;
        }
    }

    protected void setLayoutIdMap(ActionRequest actionRequest) {
        HttpServletRequest portletRequest = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        String treeId = ParamUtil.getString((PortletRequest)actionRequest, (String)"treeId");
        String openNodes = SessionTreeJSClicks.getOpenNodes((HttpServletRequest)portletRequest, (String)(treeId + "SelectedNode"));
        String selectedLayoutsJSON = this._exportImportHelper.getSelectedLayoutsJSON(groupId, privateLayout, openNodes);
        actionRequest.setAttribute("layoutIdMap", (Object)selectedLayoutsJSON);
    }

    protected void setRedirect(ActionRequest actionRequest, ActionResponse actionResponse, long backgroundTaskId) {
        LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
        PortletURL renderURL = liferayPortletResponse.createRenderURL();
        renderURL.setParameter("mvcPath", "/view_export_import.jsp");
        renderURL.setParameter("backgroundTaskId", String.valueOf(backgroundTaskId));
        actionRequest.setAttribute("REDIRECT", (Object)renderURL.toString());
    }
}

