/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.web.internal.portlet.configuration.icon;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={PortletConfigurationIcon.class})
public class ExportImportPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    private static final Log _log = LogFactoryUtil.getLog(ExportImportPortletConfigurationIcon.class);

    public String getCssClass() {
        return "portlet-export-import portlet-export-import-icon";
    }

    public String getMessage(PortletRequest portletRequest) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)"export-import");
    }

    public String getMethod() {
        return "get";
    }

    public String getOnClick(PortletRequest portletRequest, PortletResponse portletResponse) {
        StringBundler sb = new StringBundler(12);
        sb.append("Liferay.Portlet.openWindow({bodyCssClass: ");
        sb.append("'dialog-with-footer', namespace: '");
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        sb.append(portletDisplay.getNamespace());
        sb.append("', portlet: '#p_p_id_");
        sb.append(portletDisplay.getId());
        sb.append("_', portletId: '");
        sb.append(portletDisplay.getId());
        sb.append("', title: '");
        sb.append(LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"export-import"));
        sb.append("', uri: '");
        sb.append(HtmlUtil.escapeJS((String)portletDisplay.getURLExportImport()));
        sb.append("'}); return false;");
        return sb.toString();
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return portletDisplay.getURLExportImport();
    }

    public double getWeight() {
        return 15.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        if (!portletDisplay.isShowExportImportIcon()) {
            return false;
        }
        try {
            return GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Group)themeDisplay.getScopeGroup(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }

    public boolean isToolTip() {
        return false;
    }
}

