/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.web.internal.trash;

import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.service.ExportImportConfigurationLocalService;
import com.liferay.exportimport.web.trash.ExportImportConfigurationTrashRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.trash.kernel.model.TrashEntry;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.exportimport.kernel.model.ExportImportConfiguration"}, service={TrashHandler.class})
public class ExportImportConfigurationTrashHandler
extends BaseTrashHandler {
    protected ServletContext servletContext;
    private ExportImportConfigurationLocalService _exportImportConfigurationLocalService;
    private GroupLocalService _groupLocalService;

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._exportImportConfigurationLocalService.deleteExportImportConfiguration(classPK);
    }

    public String getClassName() {
        return ExportImportConfiguration.class.getName();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.translate("export-import-template");
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(classPK);
        return exportImportConfiguration.getTrashEntry();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(classPK);
        ExportImportConfigurationTrashRenderer exportImportConfigurationTrashRenderer = new ExportImportConfigurationTrashRenderer(exportImportConfiguration);
        exportImportConfigurationTrashRenderer.setServletContext(this.servletContext);
        return exportImportConfigurationTrashRenderer;
    }

    public boolean isInTrash(long classPK) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(classPK);
        return exportImportConfiguration.isInTrash();
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        this._exportImportConfigurationLocalService.restoreExportImportConfigurationFromTrash(userId, classPK);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.exportimport.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this._exportImportConfigurationLocalService.getExportImportConfiguration(classPK);
        Group group = this._groupLocalService.getGroup(exportImportConfiguration.getGroupId());
        return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)actionId);
    }

    @Reference(unbind="-")
    protected void setExportImportConfigurationLocalService(ExportImportConfigurationLocalService exportImportConfigurationLocalService) {
        this._exportImportConfigurationLocalService = exportImportConfigurationLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }
}

