/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.util;

import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.util.tracker.ServiceTracker;

public class FragmentEntryRenderUtil {
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryRenderUtil.class);
    private static final ServiceTracker<PortletRegistry, PortletRegistry> _portletRegistryServiceTracler = ServiceTrackerFactory.open(PortletRegistry.class);
    private static final ServiceTracker<FragmentEntryProcessorRegistry, FragmentEntryProcessorRegistry> _serviceTracker = ServiceTrackerFactory.open(FragmentEntryProcessorRegistry.class);

    public static PortletRegistry getPortletRegistry() {
        return (PortletRegistry)_portletRegistryServiceTracler.getService();
    }

    public static FragmentEntryProcessorRegistry getService() {
        return (FragmentEntryProcessorRegistry)_serviceTracker.getService();
    }

    public static String renderFragmentEntry(FragmentEntry fragmentEntry) {
        return FragmentEntryRenderUtil.renderFragmentEntry(fragmentEntry.getFragmentEntryId(), 0L, fragmentEntry.getCss(), fragmentEntry.getHtml(), fragmentEntry.getJs());
    }

    public static String renderFragmentEntry(long fragmentEntryId, long fragmentEntryInstanceId, String css, String html, String js) {
        StringBundler sb = new StringBundler(14);
        sb.append("<div id=\"");
        StringBundler fragmentIdSB = new StringBundler(4);
        fragmentIdSB.append("fragment-");
        fragmentIdSB.append(fragmentEntryId);
        fragmentIdSB.append("-");
        fragmentIdSB.append(fragmentEntryInstanceId);
        sb.append(fragmentIdSB.toString());
        sb.append("\" >");
        sb.append(html);
        sb.append("</div>");
        if (Validator.isNotNull((String)css)) {
            sb.append("<style>");
            sb.append(css);
            sb.append("</style>");
        }
        if (Validator.isNotNull((String)js)) {
            sb.append("<script>(function() {");
            sb.append("var fragmentElement = document.querySelector('#");
            sb.append(fragmentIdSB.toString());
            sb.append("');");
            sb.append(js);
            sb.append(";}());</script>");
        }
        return sb.toString();
    }

    public static String renderFragmentEntryLink(FragmentEntryLink fragmentEntryLink, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        return FragmentEntryRenderUtil.renderFragmentEntryLink(fragmentEntryLink, "EDIT", request, response);
    }

    public static String renderFragmentEntryLink(FragmentEntryLink fragmentEntryLink, String mode, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        return FragmentEntryRenderUtil.renderFragmentEntryLink(fragmentEntryLink, mode, new HashMap<String, Object>(), request, response);
    }

    public static String renderFragmentEntryLink(FragmentEntryLink fragmentEntryLink, String mode, Map<String, Object> parameterMap, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        return FragmentEntryRenderUtil.renderFragmentEntryLink(fragmentEntryLink, mode, parameterMap, request, response, LocaleUtil.getMostRelevantLocale());
    }

    public static String renderFragmentEntryLink(FragmentEntryLink fragmentEntryLink, String mode, Map<String, Object> parameterMap, HttpServletRequest request, HttpServletResponse response, Locale locale) throws PortalException {
        FragmentEntryProcessorRegistry fragmentEntryProcessorRegistry = FragmentEntryRenderUtil.getService();
        String html = fragmentEntryProcessorRegistry.processFragmentEntryLinkHTML(fragmentEntryLink, mode, locale);
        if (request != null && Validator.isNotNull((String)html)) {
            html = FragmentEntryRenderUtil._processTemplate(html, parameterMap, request, response);
            html = FragmentEntryRenderUtil._writePortletPaths(fragmentEntryLink, html, request, response);
        }
        return FragmentEntryRenderUtil.renderFragmentEntry(fragmentEntryLink.getFragmentEntryId(), fragmentEntryLink.getPosition(), fragmentEntryLink.getCss(), html, fragmentEntryLink.getJs());
    }

    private static String _processTemplate(String html, Map<String, Object> parameterMap, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        UnsyncStringWriter unsyncStringWriter;
        block3: {
            html = "[#ftl]\n" + html;
            StringTemplateResource templateResource = new StringTemplateResource("template_id", html);
            Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)false);
            TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)"ftl");
            templateManager.addTaglibSupport((Map)template, request, response);
            templateManager.addTaglibTheme((Map)template, "taglibLiferay", request, response);
            unsyncStringWriter = new UnsyncStringWriter();
            template.put((Object)"writer", (Object)unsyncStringWriter);
            if (MapUtil.isNotEmpty(parameterMap)) {
                template.putAll(parameterMap);
            }
            template.prepare(request);
            try {
                template.processTemplate((Writer)unsyncStringWriter);
            }
            catch (TemplateException te) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to render fragment entry", (Throwable)te);
            }
        }
        return unsyncStringWriter.toString();
    }

    private static String _writePortletPaths(FragmentEntryLink fragmentEntryLink, String html, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        PortletRegistry portletRegistry = FragmentEntryRenderUtil.getPortletRegistry();
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingHttpServletResponse = new PipingServletResponse(httpServletResponse, (Writer)unsyncStringWriter);
        portletRegistry.writePortletPaths(fragmentEntryLink, httpServletRequest, (HttpServletResponse)pipingHttpServletResponse);
        unsyncStringWriter.append((CharSequence)html);
        return unsyncStringWriter.toString();
    }
}

