/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.util.configuration;

import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.site.navigation.taglib.servlet.taglib.NavigationMenuMode;
import java.util.Objects;

public class FragmentEntryMenuDisplayConfiguration {
    private static final Source _DEFAULT_SOURCE = new DefaultSource();
    private static final Log _log = LogFactoryUtil.getLog(FragmentEntryMenuDisplayConfiguration.class);
    private final Source _source;

    public FragmentEntryMenuDisplayConfiguration(String json) {
        Source source = _DEFAULT_SOURCE;
        if (JSONUtil.isJSONObject((String)json)) {
            JSONObject jsonObject = this._createJSONObject(json);
            if (jsonObject.has("contextualMenu")) {
                source = ContextualMenu.parse(jsonObject.getString("contextualMenu"));
            } else if (jsonObject.has("siteNavigationMenuId")) {
                source = new SiteNavigationMenuSource(jsonObject.getLong("parentSiteNavigationMenuItemId"), jsonObject.getBoolean("privateLayout"), jsonObject.getLong("siteNavigationMenuId"));
            }
        }
        this._source = source;
    }

    public NavigationMenuMode getNavigationMenuMode() {
        if (this._source instanceof SiteNavigationMenuSource) {
            SiteNavigationMenuSource siteNavigationMenuSource = (SiteNavigationMenuSource)this._source;
            if (siteNavigationMenuSource.isPrivateLayout()) {
                return NavigationMenuMode.PRIVATE_PAGES;
            }
            return NavigationMenuMode.PUBLIC_PAGES;
        }
        return NavigationMenuMode.PUBLIC_PAGES;
    }

    public String getRootItemId() {
        SiteNavigationMenuSource siteNavigationMenuSource;
        long parentSiteNavigationMenuItemId;
        if (this._source instanceof SiteNavigationMenuSource && (parentSiteNavigationMenuItemId = (siteNavigationMenuSource = (SiteNavigationMenuSource)this._source).getParentSiteNavigationMenuItemId()) > 0L) {
            if (siteNavigationMenuSource.getSiteNavigationMenuId() == 0L) {
                Layout layout = LayoutLocalServiceUtil.fetchLayout((long)parentSiteNavigationMenuItemId);
                return layout.getUuid();
            }
            return String.valueOf(parentSiteNavigationMenuItemId);
        }
        return null;
    }

    public int getRootItemLevel() {
        if (this._source instanceof ContextualMenu) {
            ContextualMenu contextualMenu = (ContextualMenu)this._source;
            if (contextualMenu == ContextualMenu.CHILDREN) {
                return 0;
            }
            if (contextualMenu == ContextualMenu.PARENT_AND_ITS_SIBLINGS) {
                return 2;
            }
            if (contextualMenu == ContextualMenu.SELF_AND_SIBLINGS) {
                return 1;
            }
        }
        return 1;
    }

    public String getRootItemType() {
        if (this._source instanceof ContextualMenu) {
            return "relative";
        }
        return "select";
    }

    public long getSiteNavigationMenuId() {
        if (this._source instanceof SiteNavigationMenuSource) {
            SiteNavigationMenuSource siteNavigationMenuSource = (SiteNavigationMenuSource)this._source;
            return siteNavigationMenuSource.getSiteNavigationMenuId();
        }
        return 0L;
    }

    private JSONObject _createJSONObject(String value) {
        try {
            return JSONFactoryUtil.createJSONObject((String)value);
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return JSONFactoryUtil.createJSONObject();
        }
    }

    private static interface Source {
    }

    private static enum ContextualMenu implements Source
    {
        CHILDREN("children"),
        PARENT_AND_ITS_SIBLINGS("parent-and-its-siblings"),
        SELF_AND_SIBLINGS("self-and-siblings");

        private final String _value;

        public static ContextualMenu parse(String stringValue) {
            for (ContextualMenu contextualMenu : ContextualMenu.values()) {
                if (!Objects.equals(contextualMenu.getValue(), stringValue)) continue;
                return contextualMenu;
            }
            return SELF_AND_SIBLINGS;
        }

        public String getValue() {
            return this._value;
        }

        private ContextualMenu(String value) {
            this._value = value;
        }
    }

    private static class SiteNavigationMenuSource
    implements Source {
        private final long _parentSiteNavigationMenuItemId;
        private final boolean _privateLayout;
        private final long _siteNavigationMenuId;

        public SiteNavigationMenuSource(long parentSiteNavigationMenuItemId, boolean privateLayout, long siteNavigationMenuId) {
            this._parentSiteNavigationMenuItemId = parentSiteNavigationMenuItemId;
            this._privateLayout = privateLayout;
            this._siteNavigationMenuId = siteNavigationMenuId;
        }

        public long getParentSiteNavigationMenuItemId() {
            return this._parentSiteNavigationMenuItemId;
        }

        public long getSiteNavigationMenuId() {
            return this._siteNavigationMenuId;
        }

        public boolean isPrivateLayout() {
            return this._privateLayout;
        }
    }

    private static class DefaultSource
    implements Source {
        private DefaultSource() {
        }
    }
}

