/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.fragment.util.configuration;

import com.liferay.info.item.InfoItemReference;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProviderTracker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class FragmentConfigurationField {
    private static final Log _log = LogFactoryUtil.getLog(FragmentConfigurationField.class);
    private static final ServiceTracker<LayoutDisplayPageProviderTracker, LayoutDisplayPageProviderTracker> _serviceTracker;
    private final String _dataType;
    private final String _defaultValue;
    private final String _name;
    private final String _type;

    public FragmentConfigurationField(JSONObject fieldJSONObject) {
        this._name = fieldJSONObject.getString("name");
        this._dataType = fieldJSONObject.getString("dataType");
        this._defaultValue = fieldJSONObject.getString("defaultValue");
        this._type = fieldJSONObject.getString("type");
    }

    public FragmentConfigurationField(String name, String dataType, String defaultValue, String type) {
        this._name = name;
        this._dataType = dataType;
        this._defaultValue = defaultValue;
        this._type = type;
    }

    public String getDataType() {
        return this._dataType;
    }

    public String getDefaultValue() {
        if (Validator.isNotNull((String)this._defaultValue) && !Objects.equals(this._type, "itemSelector")) {
            return this._defaultValue;
        }
        if (Objects.equals(this._type, "colorPalette")) {
            return this._getColorPaletteDefaultValue();
        }
        if (Objects.equals(this._type, "itemSelector")) {
            return this._getItemSelectorDefaultValue();
        }
        return "";
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    private String _getColorPaletteDefaultValue() {
        JSONObject defaultValueJSONObject = JSONUtil.put((String)"cssClass", (Object)"").put("rgbValue", "");
        return defaultValueJSONObject.toString();
    }

    private String _getItemSelectorDefaultValue() {
        if (Validator.isNull((String)this._defaultValue)) {
            return this._defaultValue;
        }
        try {
            JSONObject defaultValueJSONObject = JSONFactoryUtil.createJSONObject((String)this._defaultValue);
            if (defaultValueJSONObject.has("className") && defaultValueJSONObject.has("classPK")) {
                String className = defaultValueJSONObject.getString("className");
                LayoutDisplayPageProviderTracker layoutDisplayPageProviderTracker = (LayoutDisplayPageProviderTracker)_serviceTracker.getService();
                LayoutDisplayPageProvider layoutDisplayPageProvider = layoutDisplayPageProviderTracker.getLayoutDisplayPageProviderByClassName(className);
                if (layoutDisplayPageProvider == null) {
                    return this._defaultValue;
                }
                long classPK = defaultValueJSONObject.getLong("classPK");
                InfoItemReference infoItemReference = new InfoItemReference(className, classPK);
                LayoutDisplayPageObjectProvider layoutDisplayPageObjectProvider = layoutDisplayPageProvider.getLayoutDisplayPageObjectProvider(infoItemReference);
                defaultValueJSONObject.put("title", layoutDisplayPageObjectProvider.getTitle(LocaleUtil.getMostRelevantLocale()));
                return defaultValueJSONObject.toString();
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to parse default value JSON object", (Throwable)portalException);
        }
        return this._defaultValue;
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(FragmentConfigurationField.class);
        _serviceTracker = new ServiceTracker(bundle.getBundleContext(), LayoutDisplayPageProviderTracker.class, null);
        _serviceTracker.open();
    }
}

