/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.filter;

import com.liferay.frontend.data.set.filter.FDSFilter;
import com.liferay.frontend.data.set.filter.FDSFilterContextContributor;
import com.liferay.frontend.data.set.filter.FDSFilterContextContributorRegistry;
import com.liferay.frontend.data.set.filter.FDSFilterRegistry;
import com.liferay.frontend.data.set.filter.FDSFilterSerializer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={FDSFilterSerializer.class})
public class FDSFilterSerializerImpl
implements FDSFilterSerializer {
    @Reference
    private FDSFilterContextContributorRegistry _fdsFilterContextContributorRegistry;
    @Reference
    private FDSFilterRegistry _fdsFilterRegistry;
    @Reference
    private JSONFactory _jsonFactory;

    public JSONArray serialize(String fdsName, Locale locale) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        List fdsFilters = this._fdsFilterRegistry.getFDSFilters(fdsName);
        for (FDSFilter fdsFilter : fdsFilters) {
            String label = LanguageUtil.get((ResourceBundle)resourceBundle, (String)fdsFilter.getLabel());
            JSONObject jsonObject = JSONUtil.put((String)"id", (Object)fdsFilter.getId()).put("label", label).put("type", fdsFilter.getType());
            List fdsFilterContextContributors = this._fdsFilterContextContributorRegistry.getFDSFilterContextContributors(fdsFilter.getType());
            for (FDSFilterContextContributor fdsFilterContextContributor : fdsFilterContextContributors) {
                Map fdsFilterContext = fdsFilterContextContributor.getFDSFilterContext(fdsFilter, locale);
                if (fdsFilterContext == null) continue;
                for (Map.Entry entry : fdsFilterContext.entrySet()) {
                    jsonObject.put((String)entry.getKey(), entry.getValue());
                }
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }
}

