/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.data.set.internal.view.table;

import com.liferay.frontend.data.set.view.FDSView;
import com.liferay.frontend.data.set.view.FDSViewContextContributor;
import com.liferay.frontend.data.set.view.table.BaseTableFDSView;
import com.liferay.frontend.data.set.view.table.FDSTableSchema;
import com.liferay.frontend.data.set.view.table.FDSTableSchemaField;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"frontend.data.set.view.name=table"}, service={FDSViewContextContributor.class})
public class TableFDSViewContextContributor
implements FDSViewContextContributor {
    @Reference
    private JSONFactory _jsonFactory;

    public Map<String, Object> getFDSViewContext(FDSView fdsView, Locale locale) {
        if (fdsView instanceof BaseTableFDSView) {
            return this._serialize((BaseTableFDSView)fdsView, locale);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> _serialize(BaseTableFDSView baseTableFDSView, Locale locale) {
        JSONArray fieldsJSONArray = this._jsonFactory.createJSONArray();
        FDSTableSchema fdsTableSchema = baseTableFDSView.getFDSTableSchema(locale);
        Map fieldsMap = fdsTableSchema.getFDSTableSchemaFieldsMap();
        ResourceBundle resourceBundle = baseTableFDSView.getResourceBundle(locale);
        for (FDSTableSchemaField fdsTableSchemaField : fieldsMap.values()) {
            String label = LanguageUtil.get((ResourceBundle)resourceBundle, (String)fdsTableSchemaField.getLabel());
            if (Validator.isNull((String)label)) {
                label = "";
            }
            fieldsJSONArray.put(JSONUtil.put((String)"actionId", (Object)fdsTableSchemaField.getActionId()).put("contentRenderer", fdsTableSchemaField.getContentRenderer()).put("contentRendererModuleURL", fdsTableSchemaField.getContentRendererModuleURL()).put("expand", fdsTableSchemaField.isExpand()).put("fieldName", () -> {
                String fieldName = fdsTableSchemaField.getFieldName();
                if (fieldName.contains(".")) {
                    return StringUtil.split((String)fieldName, (String)".");
                }
                return fieldName;
            }).put("label", label).put("sortable", fdsTableSchemaField.isSortable()).put("sortingOrder", () -> {
                FDSTableSchemaField.SortingOrder sortingOrder = fdsTableSchemaField.getSortingOrder();
                if (sortingOrder != null) {
                    return StringUtil.toLowerCase((String)sortingOrder.toString());
                }
                return null;
            }));
        }
        return HashMapBuilder.put((Object)"schema", (Object)JSONUtil.put((String)"fields", (Object)fieldsJSONArray)).build();
    }
}

