function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
(function (A, Liferay) {
  A.use('aui-base-lang');
  var AArray = A.Array;
  var Lang = A.Lang;
  var EVENT_CLICK = 'click';
  var MAP_TOGGLE_STATE = {
    "false": {
      cssClass: 'controls-hidden',
      iconCssClass: 'hidden',
      state: 'hidden'
    },
    "true": {
      cssClass: 'controls-visible',
      iconCssClass: 'view',
      state: 'visible'
    }
  };
  var REGEX_SUB = /\{\s*([^|}]+?)\s*(?:\|([^}]*))?\s*\}/g;
  var SRC_HIDE_LINK = {
    src: 'hideLink'
  };
  var STR_RIGHT_SQUARE_BRACKET = ']';
  var TPL_LEXICON_ICON = '<svg class="lexicon-icon lexicon-icon-{0} {1}" focusable="false" role="image">' + '<use data-href="' + themeDisplay.getPathThemeImages() + '/lexicon/icons.svg#{0}" />' + '</svg>';
  var Window = {
    _map: {},
    getById: function getById(id) {
      var instance = this;
      return instance._map[id];
    }
  };
  var Util = {
    _getEditableInstance: function _getEditableInstance(title) {
      var editable = Util._EDITABLE;

      if (!editable) {
        editable = new A.Editable({
          after: {
            contentTextChange: function contentTextChange(event) {
              var instance = this;

              if (!event.initial) {
                var title = instance.get('node');
                var portletTitleEditOptions = title.getData('portletTitleEditOptions');
                Util.savePortletTitle({
                  doAsUserId: portletTitleEditOptions.doAsUserId,
                  plid: portletTitleEditOptions.plid,
                  portletId: portletTitleEditOptions.portletId,
                  title: event.newVal
                });
              }
            },
            startEditing: function startEditing() {
              var instance = this;
              var Layout = Liferay.Layout;

              if (Layout) {
                instance._dragListener = Layout.getLayoutHandler().on('drag:start', function () {
                  instance.fire('save');
                });
              }

              var title = instance.get('node');
              instance._titleListener = title.on('mouseupoutside', function (event) {
                var editable = Util._getEditableInstance(title);

                if (!editable.get('boundingBox').contains(event.target)) {
                  editable.save();
                }
              });
            },
            stopEditing: function stopEditing() {
              var instance = this;

              if (instance._dragListener) {
                instance._dragListener.detach();
              }

              if (instance._titleListener) {
                instance._titleListener.detach();
              }
            }
          },
          cssClass: 'lfr-portlet-title-editable',
          node: title
        });
        editable.get('cancelButton').icon = 'times';
        editable.get('saveButton').icon = 'check';
        Util._EDITABLE = editable;
      }

      return editable;
    },
    addInputCancel: function addInputCancel() {
      A.use('aui-button-search-cancel', function (A) {
        new A.ButtonSearchCancel({
          trigger: 'input[type=password], input[type=search], input.clearable, input.search-query'
        });
      });

      Util.addInputCancel = function () {};
    },
    checkAll: function checkAll(form, name, allBox, selectClassName) {
      if (form) {
        form = Util.getDOM(form);

        if (typeof form === 'string') {
          form = document.querySelector(form);
        }

        allBox = Util.getDOM(allBox);

        if (typeof allBox === 'string') {
          allBox = document.querySelector(allBox);
        }

        var selector;

        if (Array.isArray(name)) {
          selector = 'input[name=' + name.join('], input[name=') + STR_RIGHT_SQUARE_BRACKET;
        } else {
          selector = 'input[name=' + name + STR_RIGHT_SQUARE_BRACKET;
        }

        var allBoxChecked = allBox.checked;
        var uploadedItems = Array.from(form.querySelectorAll(selector));
        uploadedItems.forEach(function (item) {
          if (!item.disabled) {
            item.checked = allBoxChecked;
          }
        });

        if (selectClassName) {
          var selectItem = form.querySelector(selectClassName);

          if (allBoxChecked) {
            selectItem.classList.add('info');
          } else {
            selectItem.classList.remove('info');
          }
        }
      }
    },
    checkAllBox: function checkAllBox(form, name, allBox) {
      var totalOn = 0;

      if (form) {
        form = Util.getDOM(form);

        if (typeof form === 'string') {
          form = document.querySelector(form);
        }

        allBox = Util.getDOM(allBox);

        if (typeof allBox === 'string') {
          allBox = document.querySelector(allBox) || form.querySelector("input[name=\"".concat(allBox, "\"]"));
        }

        var inputs = Array.from(form.querySelectorAll('input[type=checkbox]'));

        if (!Array.isArray(name)) {
          name = [name];
        }

        var totalBoxes = 0;
        inputs.forEach(function (input) {
          if (input.id !== allBox.id || input.id !== allBox.name && name.indexOf(input.name) > -1) {
            totalBoxes++;

            if (input.checked) {
              totalOn++;
            }
          }
        });
        allBox.checked = totalBoxes === totalOn;
      }

      return totalOn;
    },
    checkTab: function checkTab(box) {
      if (document.all && window.event.keyCode == 9) {
        box.selection = document.selection.createRange();
        setTimeout(function () {
          Util.processTab(box.id);
        }, 0);
      }
    },
    disableElements: function disableElements(el) {
      var currentElement = Util.getElement(el);

      if (currentElement) {
        var children = currentElement.getElementsByTagName('*');

        var emptyFnFalse = function emptyFnFalse() {
          return false;
        };

        for (var i = children.length - 1; i >= 0; i--) {
          var item = children[i];
          item.style.cursor = 'default';
          item.onclick = emptyFnFalse;
          item.onmouseover = emptyFnFalse;
          item.onmouseout = emptyFnFalse;
          item.onmouseenter = emptyFnFalse;
          item.onmouseleave = emptyFnFalse;
          item.action = '';
          item.disabled = true;
          item.href = 'javascript:;';
          item.onsubmit = emptyFnFalse;
        }
      }
    },
    disableFormButtons: function disableFormButtons(inputs, form) {
      inputs.attr('disabled', true);
      inputs.setStyle('opacity', 0.5);

      if (A.UA.gecko) {
        A.getWin().on('unload', function () {
          inputs.attr('disabled', false);
        });
      } else if (A.UA.safari) {
        A.use('node-event-html5', function (A) {
          A.getWin().on('pagehide', function () {
            Util.enableFormButtons(inputs, form);
          });
        });
      }
    },
    disableToggleBoxes: function disableToggleBoxes(checkBoxId, toggleBoxId, checkDisabled) {
      var checkBox = document.getElementById(checkBoxId);
      var toggleBox = document.getElementById(toggleBoxId);

      if (checkBox && toggleBox) {
        toggleBox.disabled = checkDisabled && checkBox.checked;
        checkBox.addEventListener(EVENT_CLICK, function () {
          toggleBox.disabled = !toggleBox.disabled;
        });
      }
    },
    enableFormButtons: function enableFormButtons(inputs) {
      Util._submitLocked = null;
      Util.toggleDisabled(inputs, false);
    },

    /**
     * @deprecated As of Athanasius (7.3.x), with no direct replacement
     */
    escapeCDATA: function escapeCDATA(str) {
      return str.replace(/<!\[CDATA\[|\]\]>/gi, function (match) {
        var str = '';

        if (match == ']]>') {
          str = ']]&gt;';
        } else if (match == '<![CDATA[') {
          str = '&lt;![CDATA[';
        }

        return str;
      });
    },
    forcePost: function forcePost(link) {
      var currentElement = Util.getElement(link);

      if (currentElement) {
        var url = currentElement.getAttribute('href');
        var newWindow = currentElement.getAttribute('target') == '_blank';
        var hrefFm = document.hrefFm;

        if (newWindow) {
          hrefFm.setAttribute('target', '_blank');
        }

        submitForm(hrefFm, url, !newWindow);
        Util._submitLocked = null;
      }
    },
    getAttributes: function getAttributes(el, attributeGetter) {
      var result = null;

      if (el) {
        el = Util.getDOM(el);

        if (el.jquery) {
          el = el[0];
        }

        result = {};
        var getterFn = typeof attributeGetter === 'function';
        var getterString = typeof attributeGetter === 'string';
        var attrs = el.attributes;
        var length = attrs.length;

        while (length--) {
          var attr = attrs[length];
          var name = attr.nodeName.toLowerCase();
          var value = attr.nodeValue;

          if (getterString) {
            if (name.indexOf(attributeGetter) === 0) {
              name = name.substr(attributeGetter.length);
            } else {
              continue;
            }
          } else if (getterFn) {
            value = attributeGetter(value, name, attrs);

            if (value === false) {
              continue;
            }
          }

          result[name] = value;
        }
      }

      return result;
    },
    getColumnId: function getColumnId(str) {
      var columnId = str.replace(/layout-column_/, '');
      return columnId;
    },
    getGeolocation: function getGeolocation(success, fallback, options) {
      if (success && navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function (position) {
          success(position.coords.latitude, position.coords.longitude, position);
        }, fallback, options);
      } else if (fallback) {
        fallback();
      }
    },
    getLexiconIcon: function getLexiconIcon(icon, cssClass) {
      var instance = this;
      var tempElement = document.createElement('div');
      tempElement.innerHTML = instance.getLexiconIconTpl(icon, cssClass);
      return tempElement.firstChild;
    },
    getLexiconIconTpl: function getLexiconIconTpl(icon, cssClass) {
      return Liferay.Util.sub(TPL_LEXICON_ICON, icon, cssClass || '');
    },
    getOpener: function getOpener() {
      var openingWindow = Window._opener;

      if (!openingWindow) {
        var topUtil = Liferay.Util.getTop().Liferay.Util;
        var windowName = Liferay.Util.getWindowName();
        var dialog = topUtil.Window.getById(windowName);

        if (dialog) {
          openingWindow = dialog._opener;
          Window._opener = openingWindow;
        }
      }

      return openingWindow || window.opener || window.parent;
    },
    getTop: function getTop() {
      var topWindow = Util._topWindow;

      if (!topWindow) {
        var parentWindow = window.parent;
        var parentThemeDisplay;

        while (parentWindow != window) {
          try {
            if (typeof parentWindow.location.href == 'undefined') {
              break;
            }

            parentThemeDisplay = parentWindow.themeDisplay;
          } catch (e) {
            break;
          }

          if (!parentThemeDisplay || window.name === 'simulationDeviceIframe') {
            break;
          } else if (!parentThemeDisplay.isStatePopUp() || parentWindow == parentWindow.parent) {
            topWindow = parentWindow;
            break;
          }

          parentWindow = parentWindow.parent;
        }

        if (!topWindow) {
          topWindow = window;
        }

        Util._topWindow = topWindow;
      }

      return topWindow;
    },
    getURLWithSessionId: function getURLWithSessionId(url) {
      if (!themeDisplay.isAddSessionIdToURL()) {
        return url;
      } // LEP-4787


      var x = url.indexOf(';');

      if (x > -1) {
        return url;
      }

      var sessionId = ';jsessionid=' + themeDisplay.getSessionId();
      x = url.indexOf('?');

      if (x > -1) {
        return url.substring(0, x) + sessionId + url.substring(x);
      } // In IE6, http://www.abc.com;jsessionid=XYZ does not work, but
      // http://www.abc.com/;jsessionid=XYZ does work.


      x = url.indexOf('//');

      if (x > -1) {
        var y = url.lastIndexOf('/');

        if (x + 1 == y) {
          return url + '/' + sessionId;
        }
      }

      return url + sessionId;
    },
    getWindow: function getWindow(id) {
      if (!id) {
        id = Util.getWindowName();
      }

      return Util.getTop().Liferay.Util.Window.getById(id);
    },
    getWindowName: function getWindowName() {
      return window.name || Window._name || '';
    },

    /**
     * @deprecated As of Athanasius (7.3.x), replaced by `window.innerWidth`
     */
    getWindowWidth: function getWindowWidth() {
      return window.innerWidth;
    },

    /**
     * @deprecated As of Athanasius (7.3.x), replaced by `typeof val === 'function'`
     */
    isFunction: function isFunction(val) {
      return typeof val === 'function';
    },
    listCheckboxesExcept: function listCheckboxesExcept(form, except, name, checked) {
      form = Util.getDOM(form);

      if (typeof form === 'string') {
        form = document.querySelector(form);
      }

      var selector = 'input[type=checkbox]';

      if (name) {
        selector += '[name=' + name + ']';
      }

      var checkboxes = Array.from(form.querySelectorAll(selector));
      return checkboxes.reduce(function (prev, item) {
        var value = item.value;

        if (value && item.name !== except && item.checked === checked && !item.disabled) {
          prev.push(value);
        }

        return prev;
      }, []).join();
    },
    listCheckedExcept: function listCheckedExcept(form, except, name) {
      return Util.listCheckboxesExcept(form, except, name, true);
    },
    listSelect: function listSelect(select, delimeter) {
      select = Util.getElement(select);
      return Array.from(select.querySelectorAll('option')).reduce(function (prev, item) {
        var val = item.value;

        if (val) {
          prev.push(val);
        }

        return prev;
      }, []).join(delimeter || ',');
    },
    listUncheckedExcept: function listUncheckedExcept(form, except, name) {
      return Util.listCheckboxesExcept(form, except, name, false);
    },
    openInDialog: function openInDialog(event, config) {
      event.preventDefault();
      var currentTarget = Util.getElement(event.currentTarget);
      config = A.mix(A.merge({}, currentTarget.dataset), config);

      if (!config.uri) {
        config.uri = currentTarget.dataset.href || currentTarget.getAttribute('href');
      }

      if (!config.title) {
        config.title = currentTarget.getAttribute('title');
      }

      Liferay.Util.openWindow(config);
    },
    openWindow: function openWindow(config, callback) {
      config.openingWindow = window;
      var top = Util.getTop();
      var topUtil = top.Liferay.Util;

      topUtil._openWindowProvider(config, callback);
    },
    processTab: function processTab(id) {
      document.all[id].selection.text = String.fromCharCode(9);
      document.all[id].focus();
    },

    /**
     * @deprecated As of Athanasius (7.3.x), with no direct replacement
     */
    randomInt: function randomInt() {
      return Math.ceil(Math.random() * new Date().getTime());
    },
    removeEntitySelection: function removeEntitySelection(entityIdString, entityNameString, removeEntityButton, namespace) {
      var elementByEntityId = document.getElementById("".concat(namespace).concat(entityIdString));

      if (elementByEntityId) {
        elementByEntityId.value = 0;
      }

      var elementByEntityName = document.getElementById("".concat(namespace).concat(entityNameString));

      if (elementByEntityName) {
        elementByEntityName.value = '';
      }

      Liferay.Util.toggleDisabled(removeEntityButton, true);
      Liferay.fire('entitySelectionRemoved');
    },
    reorder: function reorder(box, down) {
      box = Util.getElement(box);

      if (box) {
        if (box.getAttribute('selectedIndex') == -1) {
          box.setAttribute('selectedIndex', 0);
        } else {
          var selectedItems = Array.from(box.querySelectorAll('option:checked'));
          var items = Array.from(box.querySelectorAll('option'));

          if (down) {
            selectedItems.reverse().forEach(function (item) {
              var itemIndex = items.indexOf(item);
              var lastIndex = items.length - 1;

              if (itemIndex === lastIndex) {
                box.insertBefore(item, box.firstChild);
              } else {
                var nextItem = item.nextElementSibling.nextElementSibling;
                box.insertBefore(item, nextItem);
              }
            });
          } else {
            selectedItems.forEach(function (item) {
              var itemIndex = items.indexOf(item);

              if (itemIndex === 0) {
                box.appendChild(item);
              } else {
                box.insertBefore(item, item.previousElementSibling);
              }
            });
          }
        }
      }
    },
    rowCheckerCheckAllBox: function rowCheckerCheckAllBox(ancestorTable, ancestorRow, checkboxesIds, checkboxAllIds, cssClass) {
      Util.checkAllBox(ancestorTable, checkboxesIds, checkboxAllIds);

      if (ancestorRow) {
        ancestorRow.toggleClass(cssClass);
      }
    },
    savePortletTitle: function savePortletTitle(params) {
      params = _objectSpread({
        doAsUserId: 0,
        plid: 0,
        portletId: 0,
        title: '',
        url: themeDisplay.getPathMain() + '/portal/update_portlet_title'
      }, params);
      var data = {
        doAsUserId: params.doAsUserId,
        p_auth: Liferay.authToken,
        p_l_id: params.plid,
        portletId: params.portletId,
        title: params.title
      };
      Liferay.Util.fetch(params.url, {
        body: Liferay.Util.objectToFormData(data),
        method: 'POST'
      });
    },
    selectFolder: function selectFolder(folderData, namespace) {
      var folderDataElement = document.getElementById(namespace + folderData.idString);

      if (folderDataElement) {
        folderDataElement.value = folderData.idValue;
      }

      var folderNameElement = document.getElementById(namespace + folderData.nameString);

      if (folderNameElement) {
        folderNameElement.value = this.unescape(folderData.nameValue);
      }

      var removeFolderButton = document.getElementById("".concat(namespace, "removeFolderButton"));

      if (removeFolderButton) {
        this.toggleDisabled(removeFolderButton, false);
      }
    },
    setCursorPosition: function setCursorPosition(el, position) {
      var instance = this;
      instance.setSelectionRange(el, position, position);
    },
    setSelectionRange: function setSelectionRange(el, selectionStart, selectionEnd) {
      el = Util.getDOM(el);

      if (el.jquery) {
        el = el[0];
      }

      if (el.setSelectionRange) {
        el.focus();
        el.setSelectionRange(selectionStart, selectionEnd);
      } else if (el.createTextRange) {
        var textRange = el.createTextRange();
        textRange.collapse(true);
        textRange.moveEnd('character', selectionEnd);
        textRange.moveEnd('character', selectionStart);
        textRange.select();
      }
    },
    showCapsLock: function showCapsLock(event, spanId) {
      var span = document.getElementById(spanId);

      if (span) {
        var keyCode = event.keyCode ? event.keyCode : event.which;
        var shiftKeyCode = keyCode === 16;
        var shiftKey = event.shiftKey ? event.shiftKey : shiftKeyCode;
        var display = 'none';

        if (keyCode >= 65 && keyCode <= 90 && !shiftKey || keyCode >= 97 && keyCode <= 122 && shiftKey) {
          display = '';
        }

        span.style.display = display;
      }
    },

    /**
     * @deprecated As of Athanasius (7.3.x), with no direct replacement
     */
    sortByAscending: function sortByAscending(a, b) {
      a = a[1].toLowerCase();
      b = b[1].toLowerCase();

      if (a > b) {
        return 1;
      }

      if (a < b) {
        return -1;
      }

      return 0;
    },
    sub: function sub(string, data) {
      if (arguments.length > 2 || _typeof(data) !== 'object' && typeof data !== 'function') {
        data = Array.prototype.slice.call(arguments, 1);
      }

      return string.replace ? string.replace(REGEX_SUB, function (match, key) {
        return data[key] === undefined ? match : data[key];
      }) : string;
    },
    submitCountdown: 0,
    submitForm: function submitForm(form) {
      form.submit();
    },

    /**
     * @deprecated As of Athanasius (7.3.x), replaced by `parseInt()`
     */
    toNumber: function toNumber(value) {
      return parseInt(value, 10) || 0;
    },
    toggleBoxes: function toggleBoxes(checkBoxId, toggleBoxId, displayWhenUnchecked, toggleChildCheckboxes) {
      var checkBox = document.getElementById(checkBoxId);
      var toggleBox = document.getElementById(toggleBoxId);

      if (checkBox && toggleBox) {
        var checked = checkBox.checked;

        if (displayWhenUnchecked) {
          checked = !checked;
        }

        if (checked) {
          toggleBox.classList.remove('hide');
        } else {
          toggleBox.classList.add('hide');
        }

        checkBox.addEventListener(EVENT_CLICK, function () {
          toggleBox.classList.toggle('hide');

          if (toggleChildCheckboxes) {
            var childCheckboxes = toggleBox.querySelectorAll('input[type=checkbox]');
            childCheckboxes.forEach(function (childCheckbox) {
              childCheckbox.checked = checkBox.checked;
            });
          }
        });
      }
    },
    toggleRadio: function toggleRadio(radioId, showBoxIds, hideBoxIds) {
      var radioButton = document.getElementById(radioId);

      if (radioButton) {
        var showBoxes;

        if (showBoxIds) {
          if (Array.isArray(showBoxIds)) {
            showBoxIds = showBoxIds.join(',#');
          }

          showBoxes = document.querySelectorAll('#' + showBoxIds);
          showBoxes.forEach(function (showBox) {
            if (radioButton.checked) {
              showBox.classList.remove('hide');
            } else {
              showBox.classList.add('hide');
            }
          });
        }

        radioButton.addEventListener('change', function () {
          if (showBoxes) {
            showBoxes.forEach(function (showBox) {
              showBox.classList.remove('hide');
            });
          }

          if (hideBoxIds) {
            if (Array.isArray(hideBoxIds)) {
              hideBoxIds = hideBoxIds.join(',#');
            }

            var hideBoxes = document.querySelectorAll('#' + hideBoxIds);
            hideBoxes.forEach(function (hideBox) {
              hideBox.classList.add('hide');
            });
          }
        });
      }
    },

    /*
     * @deprecated As of Athanasius (7.3.x), with no direct replacement
     */
    toggleSearchContainerButton: function toggleSearchContainerButton(buttonId, searchContainerId, form, ignoreFieldName) {
      A.one(searchContainerId).delegate(EVENT_CLICK, function () {
        Util.toggleDisabled(buttonId, !Util.listCheckedExcept(form, ignoreFieldName));
      }, 'input[type=checkbox]');
    },
    toggleSelectBox: function toggleSelectBox(selectBoxId, value, toggleBoxId) {
      var selectBox = document.getElementById(selectBoxId);
      var toggleBox = document.getElementById(toggleBoxId);

      if (selectBox && toggleBox) {
        var dynamicValue = typeof value === 'function';

        var toggle = function toggle() {
          var currentValue = selectBox.value;
          var visible = value == currentValue;

          if (dynamicValue) {
            visible = value(currentValue, value);
          }

          if (visible) {
            toggleBox.classList.remove('hide');
          } else {
            toggleBox.classList.add('hide');
          }
        };

        toggle();
        selectBox.addEventListener('change', toggle);
      }
    }
  };
  Liferay.provide(Util, 'afterIframeLoaded', function (event) {
    var nodeInstances = A.Node._instances;
    var docEl = event.doc;
    var docUID = docEl._yuid;

    if (docUID in nodeInstances) {
      delete nodeInstances[docUID];
    }

    var iframeDocument = A.one(docEl);
    var iframeBody = iframeDocument.one('body');
    var dialog = event.dialog;
    var lfrFormContent = iframeBody.one('.lfr-form-content');
    iframeBody.addClass('dialog-iframe-popup');

    if (lfrFormContent && iframeBody.one('.button-holder.dialog-footer')) {
      iframeBody.addClass('dialog-with-footer');
      var stagingAlert = iframeBody.one('.portlet-body > .lfr-portlet-message-staging-alert');

      if (stagingAlert) {
        stagingAlert.remove();
        lfrFormContent.prepend(stagingAlert);
      }
    }

    iframeBody.addClass(dialog.iframeConfig.bodyCssClass);
    event.win.focus();

    var detachEventHandles = function detachEventHandles() {
      AArray.invoke(eventHandles, 'detach');
      iframeDocument.purge(true);
    };

    var eventHandles = [iframeBody.delegate('submit', detachEventHandles, 'form'), iframeBody.delegate(EVENT_CLICK, function (event) {
      dialog.set('visible', false, event.currentTarget.hasClass('lfr-hide-dialog') ? SRC_HIDE_LINK : null);
      detachEventHandles();
    }, '.btn-cancel,.lfr-hide-dialog')];
    Liferay.fire('modalIframeLoaded', {
      src: event.dialog.iframe.node.getAttribute('src')
    });
  }, ['aui-base']);
  Liferay.provide(Util, 'openDDMPortlet', function (config, callback) {
    var defaultValues = {
      eventName: 'selectStructure'
    };
    config = A.merge(defaultValues, config);
    var params = {
      classNameId: config.classNameId,
      classPK: config.classPK,
      doAsGroupId: config.doAsGroupId || themeDisplay.getScopeGroupId(),
      eventName: config.eventName,
      groupId: config.groupId,
      mvcPath: config.mvcPath || '/view.jsp',
      p_p_state: 'pop_up',
      portletResourceNamespace: config.portletResourceNamespace,
      resourceClassNameId: config.resourceClassNameId,
      scopeTitle: config.title,
      structureAvailableFields: config.structureAvailableFields,
      templateId: config.templateId
    };

    if ('mode' in config) {
      params.mode = config.mode;
    }

    if ('navigationStartsOn' in config) {
      params.navigationStartsOn = config.navigationStartsOn;
    }

    if ('redirect' in config) {
      params.redirect = config.redirect;
    }

    if ('refererPortletName' in config) {
      params.refererPortletName = config.refererPortletName;
    }

    if ('refererWebDAVToken' in config) {
      params.refererWebDAVToken = config.refererWebDAVToken;
    }

    if ('searchRestriction' in config) {
      params.searchRestriction = config.searchRestriction;
      params.searchRestrictionClassNameId = config.searchRestrictionClassNameId;
      params.searchRestrictionClassPK = config.searchRestrictionClassPK;
    }

    if ('showAncestorScopes' in config) {
      params.showAncestorScopes = config.showAncestorScopes;
    }

    if ('showBackURL' in config) {
      params.showBackURL = config.showBackURL;
    }

    if ('showCacheableInput' in config) {
      params.showCacheableInput = config.showCacheableInput;
    }

    if ('showHeader' in config) {
      params.showHeader = config.showHeader;
    }

    if ('showManageTemplates' in config) {
      params.showManageTemplates = config.showManageTemplates;
    }

    var url = Liferay.Util.PortletURL.createRenderURL(config.basePortletURL, params);
    config.uri = url.toString();
    var dialogConfig = config.dialog;

    if (!dialogConfig) {
      dialogConfig = {};
      config.dialog = dialogConfig;
    }

    var eventHandles = [];

    if (callback) {
      eventHandles.push(Liferay.once(config.eventName, callback));
    }

    var detachSelectionOnHideFn = function detachSelectionOnHideFn(event) {
      Liferay.fire(config.eventName);

      if (!event.newVal) {
        new A.EventHandle(eventHandles).detach();
      }
    };

    Util.openWindow(config, function (dialogWindow) {
      eventHandles.push(dialogWindow.after(['destroy', 'visibleChange'], detachSelectionOnHideFn));
    });
  }, ['aui-base']);
  Liferay.provide(Util, 'openDocument', function (webDavUrl, onSuccess, onError) {
    if (A.UA.ie) {
      try {
        var executor = new A.config.win.ActiveXObject('SharePoint.OpenDocuments');
        executor.EditDocument(webDavUrl);

        if (Lang.isFunction(onSuccess)) {
          onSuccess();
        }
      } catch (e) {
        if (Lang.isFunction(onError)) {
          onError(e);
        }
      }
    }
  }, ['aui-base']);
  Liferay.provide(Util, 'selectEntityHandler', function (containerSelector, selectEventName, disableButton) {
    var container = A.one(containerSelector);

    if (!container) {
      return;
    }

    var openingLiferay = Util.getOpener().Liferay;
    var selectorButtons = container.getDOM().querySelectorAll('.selector-button');
    container.delegate(EVENT_CLICK, function (event) {
      var currentTarget = event.currentTarget.getDOM();

      if (currentTarget.disabled || currentTarget.dataset['preventSelection']) {
        return;
      }

      var confirmSelection = currentTarget.dataset['confirmSelection'] === 'true';

      if (!confirmSelection || confirm(currentTarget.dataset['confirmSelectionMessage'])) {
        if (disableButton) {
          selectorButtons.forEach(function (selectorButton) {
            selectorButton.disabled = false;
          });
          currentTarget.disabled = true;
        }

        var result = Util.getAttributes(currentTarget, 'data-');
        openingLiferay.fire(selectEventName, result);

        var _window = Util.getWindow();

        if (_window) {
          _window.hide();
        }
      }
    }, '.selector-button');
    openingLiferay.on('entitySelectionRemoved', function () {
      selectorButtons.forEach(function (selectorButton) {
        selectorButton.disabled = false;
      });
    });
  }, ['aui-base']);
  Liferay.provide(Util, 'portletTitleEdit', function (options) {
    var obj = options.obj;
    A.Event.defineOutside('mouseup');

    if (obj) {
      var title = obj.one('.portlet-title-text');

      if (title && !title.hasClass('not-editable')) {
        title.addClass('portlet-title-editable');
        title.on(EVENT_CLICK, function (event) {
          var editable = Util._getEditableInstance(title);

          var rendered = editable.get('rendered');

          if (rendered) {
            editable.fire('stopEditing');
          }

          editable.set('node', event.currentTarget);

          if (rendered) {
            editable.syncUI();
          }

          editable._startEditing(event);

          if (!rendered) {
            var defaultIconsTpl = A.ToolbarRenderer.prototype.TEMPLATES.icon;
            A.ToolbarRenderer.prototype.TEMPLATES.icon = Liferay.Util.getLexiconIconTpl('{cssClass}');

            editable._comboBox.icons.destroy();

            editable._comboBox._renderIcons();

            A.ToolbarRenderer.prototype.TEMPLATES.icon = defaultIconsTpl;
          }
        });
        title.setData('portletTitleEditOptions', options);
      }
    }
  }, ['aui-editable-deprecated', 'event-outside']);
  Liferay.provide(Util, 'editEntity', function (config, callback) {
    var dialog = Util.getWindow(config.id);
    var eventName = config.eventName || config.id;
    var eventHandles = [Liferay.on(eventName, callback)];

    var detachSelectionOnHideFn = function detachSelectionOnHideFn(event) {
      if (!event.newVal) {
        new A.EventHandle(eventHandles).detach();
      }
    };

    if (dialog) {
      eventHandles.push(dialog.after(['destroy', 'visibleChange'], detachSelectionOnHideFn));
      dialog.show();
    } else {
      var destroyDialog = function destroyDialog(event) {
        var dialogId = config.id;
        var dialogWindow = Util.getWindow(dialogId);

        if (dialogWindow && Util.getPortletId(dialogId) === event.portletId) {
          dialogWindow.destroy();
          Liferay.detach('destroyPortlet', destroyDialog);
        }
      };

      var editURL = new Liferay.Util.PortletURL.createPortletURL(config.uri, A.merge({
        eventName: eventName
      }, config.urlParams));
      config.uri = editURL.toString();
      config.dialogIframe = A.merge({
        bodyCssClass: 'dialog-with-footer'
      }, config.dialogIframe || {});
      Util.openWindow(config, function (dialogWindow) {
        eventHandles.push(dialogWindow.after(['destroy', 'visibleChange'], detachSelectionOnHideFn));
        Liferay.on('destroyPortlet', destroyDialog);
      });
    }
  }, ['aui-base', 'liferay-util-window']);
  Liferay.provide(Util, 'selectEntity', function (config, callback) {
    var dialog = Util.getWindow(config.id);
    var eventName = config.eventName || config.id;
    var eventHandles = [Liferay.on(eventName, callback)];
    var selectedData = config.selectedData;

    if (selectedData) {
      config.dialog.destroyOnHide = true;
    }

    var detachSelectionOnHideFn = function detachSelectionOnHideFn(event) {
      if (!event.newVal) {
        new A.EventHandle(eventHandles).detach();
      }
    };

    var disableSelectedAssets = function disableSelectedAssets(event) {
      if (selectedData && selectedData.length) {
        var currentWindow = event.currentTarget.node.get('contentWindow.document');
        var selectorButtons = currentWindow.all('.lfr-search-container-wrapper .selector-button');
        A.some(selectorButtons, function (item) {
          var assetEntryId = item.attr('data-entityid') || item.attr('data-entityname');
          var assetEntryIndex = selectedData.indexOf(assetEntryId);

          if (assetEntryIndex > -1) {
            item.attr('data-prevent-selection', true);
            item.attr('disabled', true);
            selectedData.splice(assetEntryIndex, 1);
          }

          return !selectedData.length;
        });
      }
    };

    if (dialog) {
      eventHandles.push(dialog.after(['destroy', 'visibleChange'], detachSelectionOnHideFn));
      dialog.show();
    } else {
      var destroyDialog = function destroyDialog(event) {
        var dialogId = config.id;
        var dialogWindow = Util.getWindow(dialogId);

        if (dialogWindow && Util.getPortletId(dialogId) === event.portletId) {
          dialogWindow.destroy();
          Liferay.detach('destroyPortlet', destroyDialog);
        }
      };

      Util.openWindow(config, function (dialogWindow) {
        eventHandles.push(dialogWindow.after(['destroy', 'visibleChange'], detachSelectionOnHideFn), dialogWindow.iframe.after(['load'], disableSelectedAssets));
        Liferay.on('destroyPortlet', destroyDialog);
      });
    }
  }, ['aui-base', 'liferay-util-window']);
  Liferay.provide(Util, 'toggleControls', function (node) {
    var docBody = A.getBody();
    node = node || docBody;
    var trigger = node.one('.toggle-controls');

    if (trigger) {
      var controlsVisible = Liferay._editControlsState === 'visible';
      var currentState = MAP_TOGGLE_STATE[controlsVisible];
      var icon = trigger.one('.lexicon-icon');

      if (icon) {
        currentState.icon = icon;
      }

      docBody.addClass(currentState.cssClass);
      Liferay.fire('toggleControls', {
        enabled: controlsVisible
      });
      trigger.on('tap', function () {
        controlsVisible = !controlsVisible;
        var prevState = currentState;
        currentState = MAP_TOGGLE_STATE[controlsVisible];
        docBody.toggleClass(prevState.cssClass);
        docBody.toggleClass(currentState.cssClass);
        var editControlsIconClass = currentState.iconCssClass;
        var editControlsState = currentState.state;

        if (icon) {
          var newIcon = currentState.icon;

          if (!newIcon) {
            newIcon = Util.getLexiconIcon(editControlsIconClass);
            newIcon = A.one(newIcon);
            currentState.icon = newIcon;
          }

          icon.replace(newIcon);
          icon = newIcon;
        }

        Liferay._editControlsState = editControlsState;
        Liferay.Util.Session.set('com.liferay.frontend.js.web_toggleControls', editControlsState);
        Liferay.fire('toggleControls', {
          enabled: controlsVisible,
          src: 'ui'
        });
      });
    }
  }, ['event-tap']);
  Liferay.provide(Util, '_openWindowProvider', function (config, callback) {
    var dialog = Window.getWindow(config);

    if (Lang.isFunction(callback)) {
      callback(dialog);
    }
  }, ['liferay-util-window']);
  Util.Window = Window;
  Liferay.Util = Util;
  Liferay.STATUS_CODE = {
    BAD_REQUEST: 400,
    INTERNAL_SERVER_ERROR: 500,
    OK: 200,
    SC_DUPLICATE_FILE_EXCEPTION: 490,
    SC_FILE_ANTIVIRUS_EXCEPTION: 494,
    SC_FILE_CUSTOM_EXCEPTION: 499,
    SC_FILE_EXTENSION_EXCEPTION: 491,
    SC_FILE_NAME_EXCEPTION: 492,
    SC_FILE_SIZE_EXCEPTION: 493,
    SC_UPLOAD_REQUEST_SIZE_EXCEPTION: 495
  }; // 0-200: Theme Developer
  // 200-400: Portlet Developer
  // 400+: Liferay

  Liferay.zIndex = {
    ALERT: 430,
    DOCK: 10,
    DOCK_PARENT: 20,
    DRAG_ITEM: 460,
    DROP_AREA: 440,
    DROP_POSITION: 450,
    MENU: 5000,
    OVERLAY: 1000,
    POPOVER: 1600,
    TOOLTIP: 10000,
    WINDOW: 1200
  };
})(AUI(), Liferay);
//# sourceMappingURL=util.js.map