if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/node-screen/node-screen.js']) {
   __coverage__['build/node-screen/node-screen.js'] = {"path":"build/node-screen/node-screen.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0],"15":[0,0],"16":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":23},"end":{"line":1,"column":42}}},"2":{"name":"(anonymous_2)","line":55,"loc":{"start":{"line":55,"column":4},"end":{"line":55,"column":19}}},"3":{"name":"(anonymous_3)","line":57,"loc":{"start":{"line":57,"column":20},"end":{"line":57,"column":31}}},"4":{"name":"(anonymous_4)","line":68,"loc":{"start":{"line":68,"column":12},"end":{"line":68,"column":23}}},"5":{"name":"(anonymous_5)","line":73,"loc":{"start":{"line":73,"column":12},"end":{"line":73,"column":26}}},"6":{"name":"(anonymous_6)","line":87,"loc":{"start":{"line":87,"column":12},"end":{"line":87,"column":23}}},"7":{"name":"(anonymous_7)","line":92,"loc":{"start":{"line":92,"column":12},"end":{"line":92,"column":26}}},"8":{"name":"(anonymous_8)","line":173,"loc":{"start":{"line":173,"column":12},"end":{"line":173,"column":23}}},"9":{"name":"(anonymous_9)","line":197,"loc":{"start":{"line":197,"column":12},"end":{"line":197,"column":23}}},"10":{"name":"(anonymous_10)","line":213,"loc":{"start":{"line":213,"column":29},"end":{"line":213,"column":56}}},"11":{"name":"(anonymous_11)","line":229,"loc":{"start":{"line":229,"column":28},"end":{"line":229,"column":60}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":238,"column":59}},"2":{"start":{"line":11,"column":0},"end":{"line":65,"column":2}},"3":{"start":{"line":56,"column":8},"end":{"line":63,"column":10}},"4":{"start":{"line":58,"column":16},"end":{"line":58,"column":65}},"5":{"start":{"line":59,"column":16},"end":{"line":59,"column":54}},"6":{"start":{"line":61,"column":16},"end":{"line":61,"column":53}},"7":{"start":{"line":67,"column":0},"end":{"line":84,"column":2}},"8":{"start":{"line":69,"column":8},"end":{"line":69,"column":43}},"9":{"start":{"line":70,"column":8},"end":{"line":70,"column":81}},"10":{"start":{"line":74,"column":8},"end":{"line":74,"column":43}},"11":{"start":{"line":75,"column":8},"end":{"line":82,"column":9}},"12":{"start":{"line":76,"column":12},"end":{"line":80,"column":13}},"13":{"start":{"line":77,"column":16},"end":{"line":77,"column":38}},"14":{"start":{"line":78,"column":19},"end":{"line":80,"column":13}},"15":{"start":{"line":79,"column":16},"end":{"line":79,"column":74}},"16":{"start":{"line":86,"column":0},"end":{"line":103,"column":2}},"17":{"start":{"line":88,"column":8},"end":{"line":88,"column":43}},"18":{"start":{"line":89,"column":8},"end":{"line":89,"column":79}},"19":{"start":{"line":93,"column":8},"end":{"line":93,"column":43}},"20":{"start":{"line":94,"column":8},"end":{"line":101,"column":9}},"21":{"start":{"line":95,"column":12},"end":{"line":99,"column":13}},"22":{"start":{"line":96,"column":16},"end":{"line":96,"column":37}},"23":{"start":{"line":97,"column":19},"end":{"line":99,"column":13}},"24":{"start":{"line":98,"column":16},"end":{"line":98,"column":74}},"25":{"start":{"line":105,"column":0},"end":{"line":159,"column":3}},"26":{"start":{"line":172,"column":0},"end":{"line":189,"column":2}},"27":{"start":{"line":174,"column":8},"end":{"line":175,"column":19}},"28":{"start":{"line":177,"column":8},"end":{"line":181,"column":9}},"29":{"start":{"line":178,"column":12},"end":{"line":180,"column":13}},"30":{"start":{"line":179,"column":16},"end":{"line":179,"column":44}},"31":{"start":{"line":182,"column":8},"end":{"line":186,"column":9}},"32":{"start":{"line":183,"column":12},"end":{"line":183,"column":48}},"33":{"start":{"line":185,"column":12},"end":{"line":185,"column":40}},"34":{"start":{"line":187,"column":8},"end":{"line":187,"column":22}},"35":{"start":{"line":196,"column":0},"end":{"line":200,"column":2}},"36":{"start":{"line":198,"column":8},"end":{"line":198,"column":61}},"37":{"start":{"line":202,"column":0},"end":{"line":202,"column":47}},"38":{"start":{"line":213,"column":0},"end":{"line":219,"column":2}},"39":{"start":{"line":214,"column":4},"end":{"line":214,"column":40}},"40":{"start":{"line":215,"column":4},"end":{"line":217,"column":5}},"41":{"start":{"line":216,"column":8},"end":{"line":216,"column":41}},"42":{"start":{"line":218,"column":4},"end":{"line":218,"column":52}},"43":{"start":{"line":229,"column":0},"end":{"line":235,"column":2}},"44":{"start":{"line":230,"column":4},"end":{"line":230,"column":40}},"45":{"start":{"line":231,"column":4},"end":{"line":233,"column":5}},"46":{"start":{"line":232,"column":8},"end":{"line":232,"column":41}},"47":{"start":{"line":234,"column":4},"end":{"line":234,"column":56}}},"branchMap":{"1":{"line":70,"type":"cond-expr","locations":[{"start":{"line":70,"column":40},"end":{"line":70,"column":55}},{"start":{"line":70,"column":58},"end":{"line":70,"column":80}}]},"2":{"line":75,"type":"if","locations":[{"start":{"line":75,"column":8},"end":{"line":75,"column":8}},{"start":{"line":75,"column":8},"end":{"line":75,"column":8}}]},"3":{"line":76,"type":"if","locations":[{"start":{"line":76,"column":12},"end":{"line":76,"column":12}},{"start":{"line":76,"column":12},"end":{"line":76,"column":12}}]},"4":{"line":78,"type":"if","locations":[{"start":{"line":78,"column":19},"end":{"line":78,"column":19}},{"start":{"line":78,"column":19},"end":{"line":78,"column":19}}]},"5":{"line":78,"type":"binary-expr","locations":[{"start":{"line":78,"column":23},"end":{"line":78,"column":36}},{"start":{"line":78,"column":40},"end":{"line":78,"column":59}}]},"6":{"line":89,"type":"cond-expr","locations":[{"start":{"line":89,"column":39},"end":{"line":89,"column":53}},{"start":{"line":89,"column":56},"end":{"line":89,"column":78}}]},"7":{"line":94,"type":"if","locations":[{"start":{"line":94,"column":8},"end":{"line":94,"column":8}},{"start":{"line":94,"column":8},"end":{"line":94,"column":8}}]},"8":{"line":95,"type":"if","locations":[{"start":{"line":95,"column":12},"end":{"line":95,"column":12}},{"start":{"line":95,"column":12},"end":{"line":95,"column":12}}]},"9":{"line":97,"type":"if","locations":[{"start":{"line":97,"column":19},"end":{"line":97,"column":19}},{"start":{"line":97,"column":19},"end":{"line":97,"column":19}}]},"10":{"line":97,"type":"binary-expr","locations":[{"start":{"line":97,"column":23},"end":{"line":97,"column":36}},{"start":{"line":97,"column":40},"end":{"line":97,"column":59}}]},"11":{"line":177,"type":"if","locations":[{"start":{"line":177,"column":8},"end":{"line":177,"column":8}},{"start":{"line":177,"column":8},"end":{"line":177,"column":8}}]},"12":{"line":177,"type":"binary-expr","locations":[{"start":{"line":177,"column":12},"end":{"line":177,"column":16}},{"start":{"line":177,"column":20},"end":{"line":177,"column":33}}]},"13":{"line":178,"type":"if","locations":[{"start":{"line":178,"column":12},"end":{"line":178,"column":12}},{"start":{"line":178,"column":12},"end":{"line":178,"column":12}}]},"14":{"line":182,"type":"if","locations":[{"start":{"line":182,"column":8},"end":{"line":182,"column":8}},{"start":{"line":182,"column":8},"end":{"line":182,"column":8}}]},"15":{"line":215,"type":"if","locations":[{"start":{"line":215,"column":4},"end":{"line":215,"column":4}},{"start":{"line":215,"column":4},"end":{"line":215,"column":4}}]},"16":{"line":231,"type":"if","locations":[{"start":{"line":231,"column":4},"end":{"line":231,"column":4}},{"start":{"line":231,"column":4},"end":{"line":231,"column":4}}]}},"code":["(function () { YUI.add('node-screen', function (Y, NAME) {","","/**"," * Extended Node interface for managing regions and screen positioning."," * Adds support for positioning elements and normalizes window size and scroll detection."," * @module node"," * @submodule node-screen"," */","","// these are all \"safe\" returns, no wrapping required","Y.each([","    /**","     * Returns the inner width of the viewport (exludes scrollbar).","     * @config winWidth","     * @for Node","     * @type {Number}","     */","    'winWidth',","","    /**","     * Returns the inner height of the viewport (exludes scrollbar).","     * @config winHeight","     * @type {Number}","     */","    'winHeight',","","    /**","     * Document width","     * @config docWidth","     * @type {Number}","     */","    'docWidth',","","    /**","     * Document height","     * @config docHeight","     * @type {Number}","     */","    'docHeight',","","    /**","     * Pixel distance the page has been scrolled horizontally","     * @config docScrollX","     * @type {Number}","     */","    'docScrollX',","","    /**","     * Pixel distance the page has been scrolled vertically","     * @config docScrollY","     * @type {Number}","     */","    'docScrollY'","    ],","    function(name) {","        Y.Node.ATTRS[name] = {","            getter: function() {","                var args = Array.prototype.slice.call(arguments);","                args.unshift(Y.Node.getDOMNode(this));","","                return Y.DOM[name].apply(this, args);","            }","        };","    }",");","","Y.Node.ATTRS.scrollLeft = {","    getter: function() {","        var node = Y.Node.getDOMNode(this);","        return ('scrollLeft' in node) ? node.scrollLeft : Y.DOM.docScrollX(node);","    },","","    setter: function(val) {","        var node = Y.Node.getDOMNode(this);","        if (node) {","            if ('scrollLeft' in node) {","                node.scrollLeft = val;","            } else if (node.document || node.nodeType === 9) {","                Y.DOM._getWin(node).scrollTo(val, Y.DOM.docScrollY(node)); // scroll window if win or doc","            }","        } else {","        }","    }","};","","Y.Node.ATTRS.scrollTop = {","    getter: function() {","        var node = Y.Node.getDOMNode(this);","        return ('scrollTop' in node) ? node.scrollTop : Y.DOM.docScrollY(node);","    },","","    setter: function(val) {","        var node = Y.Node.getDOMNode(this);","        if (node) {","            if ('scrollTop' in node) {","                node.scrollTop = val;","            } else if (node.document || node.nodeType === 9) {","                Y.DOM._getWin(node).scrollTo(Y.DOM.docScrollX(node), val); // scroll window if win or doc","            }","        } else {","        }","    }","};","","Y.Node.importMethod(Y.DOM, [","/**"," * Gets the current position of the node in page coordinates."," * @method getXY"," * @for Node"," * @return {Array} The XY position of the node","*/","    'getXY',","","/**"," * Set the position of the node in page coordinates, regardless of how the node is positioned."," * @method setXY"," * @param {Array} xy Contains X & Y values for new position (coordinates are page-based)"," * @chainable"," */","    'setXY',","","/**"," * Gets the current position of the node in page coordinates."," * @method getX"," * @return {Number} The X position of the node","*/","    'getX',","","/**"," * Set the position of the node in page coordinates, regardless of how the node is positioned."," * @method setX"," * @param {Number} x X value for new position (coordinates are page-based)"," * @chainable"," */","    'setX',","","/**"," * Gets the current position of the node in page coordinates."," * @method getY"," * @return {Number} The Y position of the node","*/","    'getY',","","/**"," * Set the position of the node in page coordinates, regardless of how the node is positioned."," * @method setY"," * @param {Number} y Y value for new position (coordinates are page-based)"," * @chainable"," */","    'setY',","","/**"," * Swaps the XY position of this node with another node."," * @method swapXY"," * @param {Node | HTMLElement} otherNode The node to swap with."," * @chainable"," */","    'swapXY'","]);","","/**"," * @module node"," * @submodule node-screen"," */","","/**"," * Returns a region object for the node"," * @config region"," * @for Node"," * @type Node"," */","Y.Node.ATTRS.region = {","    getter: function() {","        var node = this.getDOMNode(),","            region;","","        if (node && !node.tagName) {","            if (node.nodeType === 9) { // document","                node = node.documentElement;","            }","        }","        if (Y.DOM.isWindow(node)) {","            region = Y.DOM.viewportRegion(node);","        } else {","            region = Y.DOM.region(node);","        }","        return region;","    }","};","","/**"," * Returns a region object for the node's viewport"," * @config viewportRegion"," * @type Node"," */","Y.Node.ATTRS.viewportRegion = {","    getter: function() {","        return Y.DOM.viewportRegion(Y.Node.getDOMNode(this));","    }","};","","Y.Node.importMethod(Y.DOM, 'inViewportRegion');","","// these need special treatment to extract 2nd node arg","/**"," * Compares the intersection of the node with another node or region"," * @method intersect"," * @for Node"," * @param {Node|Object} node2 The node or region to compare with."," * @param {Object} altRegion An alternate region to use (rather than this node's)."," * @return {Object} An object representing the intersection of the regions."," */","Y.Node.prototype.intersect = function(node2, altRegion) {","    var node1 = Y.Node.getDOMNode(this);","    if (Y.instanceOf(node2, Y.Node)) { // might be a region object","        node2 = Y.Node.getDOMNode(node2);","    }","    return Y.DOM.intersect(node1, node2, altRegion);","};","","/**"," * Determines whether or not the node is within the given region."," * @method inRegion"," * @param {Node|Object} node2 The node or region to compare with."," * @param {Boolean} all Whether or not all of the node must be in the region."," * @param {Object} altRegion An alternate region to use (rather than this node's)."," * @return {Boolean} True if in region, false if not."," */","Y.Node.prototype.inRegion = function(node2, all, altRegion) {","    var node1 = Y.Node.getDOMNode(this);","    if (Y.instanceOf(node2, Y.Node)) { // might be a region object","        node2 = Y.Node.getDOMNode(node2);","    }","    return Y.DOM.inRegion(node1, node2, all, altRegion);","};","","","}, 'patched-v3.20.6', {\"requires\": [\"dom-screen\", \"node-base\"]});","","}());"]};
}
var __cov_XkqlpMAiAd1S49v_bBnOnQ = __coverage__['build/node-screen/node-screen.js'];
__cov_XkqlpMAiAd1S49v_bBnOnQ.s['1']++;YUI.add('node-screen',function(Y,NAME){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['1']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['2']++;Y.each(['winWidth','winHeight','docWidth','docHeight','docScrollX','docScrollY'],function(name){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['2']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['3']++;Y.Node.ATTRS[name]={getter:function(){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['3']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['4']++;var args=Array.prototype.slice.call(arguments);__cov_XkqlpMAiAd1S49v_bBnOnQ.s['5']++;args.unshift(Y.Node.getDOMNode(this));__cov_XkqlpMAiAd1S49v_bBnOnQ.s['6']++;return Y.DOM[name].apply(this,args);}};});__cov_XkqlpMAiAd1S49v_bBnOnQ.s['7']++;Y.Node.ATTRS.scrollLeft={getter:function(){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['4']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['8']++;var node=Y.Node.getDOMNode(this);__cov_XkqlpMAiAd1S49v_bBnOnQ.s['9']++;return'scrollLeft'in node?(__cov_XkqlpMAiAd1S49v_bBnOnQ.b['1'][0]++,node.scrollLeft):(__cov_XkqlpMAiAd1S49v_bBnOnQ.b['1'][1]++,Y.DOM.docScrollX(node));},setter:function(val){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['5']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['10']++;var node=Y.Node.getDOMNode(this);__cov_XkqlpMAiAd1S49v_bBnOnQ.s['11']++;if(node){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['2'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['12']++;if('scrollLeft'in node){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['3'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['13']++;node.scrollLeft=val;}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['3'][1]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['14']++;if((__cov_XkqlpMAiAd1S49v_bBnOnQ.b['5'][0]++,node.document)||(__cov_XkqlpMAiAd1S49v_bBnOnQ.b['5'][1]++,node.nodeType===9)){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['4'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['15']++;Y.DOM._getWin(node).scrollTo(val,Y.DOM.docScrollY(node));}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['4'][1]++;}}}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['2'][1]++;}}};__cov_XkqlpMAiAd1S49v_bBnOnQ.s['16']++;Y.Node.ATTRS.scrollTop={getter:function(){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['6']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['17']++;var node=Y.Node.getDOMNode(this);__cov_XkqlpMAiAd1S49v_bBnOnQ.s['18']++;return'scrollTop'in node?(__cov_XkqlpMAiAd1S49v_bBnOnQ.b['6'][0]++,node.scrollTop):(__cov_XkqlpMAiAd1S49v_bBnOnQ.b['6'][1]++,Y.DOM.docScrollY(node));},setter:function(val){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['7']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['19']++;var node=Y.Node.getDOMNode(this);__cov_XkqlpMAiAd1S49v_bBnOnQ.s['20']++;if(node){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['7'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['21']++;if('scrollTop'in node){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['8'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['22']++;node.scrollTop=val;}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['8'][1]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['23']++;if((__cov_XkqlpMAiAd1S49v_bBnOnQ.b['10'][0]++,node.document)||(__cov_XkqlpMAiAd1S49v_bBnOnQ.b['10'][1]++,node.nodeType===9)){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['9'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['24']++;Y.DOM._getWin(node).scrollTo(Y.DOM.docScrollX(node),val);}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['9'][1]++;}}}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['7'][1]++;}}};__cov_XkqlpMAiAd1S49v_bBnOnQ.s['25']++;Y.Node.importMethod(Y.DOM,['getXY','setXY','getX','setX','getY','setY','swapXY']);__cov_XkqlpMAiAd1S49v_bBnOnQ.s['26']++;Y.Node.ATTRS.region={getter:function(){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['8']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['27']++;var node=this.getDOMNode(),region;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['28']++;if((__cov_XkqlpMAiAd1S49v_bBnOnQ.b['12'][0]++,node)&&(__cov_XkqlpMAiAd1S49v_bBnOnQ.b['12'][1]++,!node.tagName)){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['11'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['29']++;if(node.nodeType===9){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['13'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['30']++;node=node.documentElement;}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['13'][1]++;}}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['11'][1]++;}__cov_XkqlpMAiAd1S49v_bBnOnQ.s['31']++;if(Y.DOM.isWindow(node)){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['14'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['32']++;region=Y.DOM.viewportRegion(node);}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['14'][1]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['33']++;region=Y.DOM.region(node);}__cov_XkqlpMAiAd1S49v_bBnOnQ.s['34']++;return region;}};__cov_XkqlpMAiAd1S49v_bBnOnQ.s['35']++;Y.Node.ATTRS.viewportRegion={getter:function(){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['9']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['36']++;return Y.DOM.viewportRegion(Y.Node.getDOMNode(this));}};__cov_XkqlpMAiAd1S49v_bBnOnQ.s['37']++;Y.Node.importMethod(Y.DOM,'inViewportRegion');__cov_XkqlpMAiAd1S49v_bBnOnQ.s['38']++;Y.Node.prototype.intersect=function(node2,altRegion){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['10']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['39']++;var node1=Y.Node.getDOMNode(this);__cov_XkqlpMAiAd1S49v_bBnOnQ.s['40']++;if(Y.instanceOf(node2,Y.Node)){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['15'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['41']++;node2=Y.Node.getDOMNode(node2);}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['15'][1]++;}__cov_XkqlpMAiAd1S49v_bBnOnQ.s['42']++;return Y.DOM.intersect(node1,node2,altRegion);};__cov_XkqlpMAiAd1S49v_bBnOnQ.s['43']++;Y.Node.prototype.inRegion=function(node2,all,altRegion){__cov_XkqlpMAiAd1S49v_bBnOnQ.f['11']++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['44']++;var node1=Y.Node.getDOMNode(this);__cov_XkqlpMAiAd1S49v_bBnOnQ.s['45']++;if(Y.instanceOf(node2,Y.Node)){__cov_XkqlpMAiAd1S49v_bBnOnQ.b['16'][0]++;__cov_XkqlpMAiAd1S49v_bBnOnQ.s['46']++;node2=Y.Node.getDOMNode(node2);}else{__cov_XkqlpMAiAd1S49v_bBnOnQ.b['16'][1]++;}__cov_XkqlpMAiAd1S49v_bBnOnQ.s['47']++;return Y.DOM.inRegion(node1,node2,all,altRegion);};},'patched-v3.20.6',{'requires':['dom-screen','node-base']});
