if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/recordset-indexer/recordset-indexer.js']) {
   __coverage__['build/recordset-indexer/recordset-indexer.js'] = {"path":"build/recordset-indexer/recordset-indexer.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":29},"end":{"line":1,"column":48}}},"2":{"name":"RecordsetIndexer","line":13,"loc":{"start":{"line":13,"column":0},"end":{"line":13,"column":34}}},"3":{"name":"(anonymous_3)","line":49,"loc":{"start":{"line":49,"column":17},"end":{"line":49,"column":34}}},"4":{"name":"(anonymous_4)","line":59,"loc":{"start":{"line":59,"column":16},"end":{"line":59,"column":33}}},"5":{"name":"(anonymous_5)","line":72,"loc":{"start":{"line":72,"column":19},"end":{"line":72,"column":33}}},"6":{"name":"(anonymous_6)","line":94,"loc":{"start":{"line":94,"column":17},"end":{"line":94,"column":29}}},"7":{"name":"(anonymous_7)","line":101,"loc":{"start":{"line":101,"column":8},"end":{"line":101,"column":25}}},"8":{"name":"(anonymous_8)","line":103,"loc":{"start":{"line":103,"column":12},"end":{"line":103,"column":24}}},"9":{"name":"(anonymous_9)","line":119,"loc":{"start":{"line":119,"column":20},"end":{"line":119,"column":32}}},"10":{"name":"(anonymous_10)","line":126,"loc":{"start":{"line":126,"column":8},"end":{"line":126,"column":25}}},"11":{"name":"(anonymous_11)","line":128,"loc":{"start":{"line":128,"column":12},"end":{"line":128,"column":24}}},"12":{"name":"(anonymous_12)","line":145,"loc":{"start":{"line":145,"column":20},"end":{"line":145,"column":32}}},"13":{"name":"(anonymous_13)","line":197,"loc":{"start":{"line":197,"column":17},"end":{"line":197,"column":31}}},"14":{"name":"(anonymous_14)","line":214,"loc":{"start":{"line":214,"column":14},"end":{"line":214,"column":28}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":227,"column":60}},"2":{"start":{"line":13,"column":0},"end":{"line":15,"column":1}},"3":{"start":{"line":14,"column":4},"end":{"line":14,"column":67}},"4":{"start":{"line":17,"column":0},"end":{"line":44,"column":3}},"5":{"start":{"line":47,"column":0},"end":{"line":222,"column":3}},"6":{"start":{"line":50,"column":8},"end":{"line":50,"column":36}},"7":{"start":{"line":53,"column":8},"end":{"line":53,"column":67}},"8":{"start":{"line":54,"column":8},"end":{"line":54,"column":73}},"9":{"start":{"line":55,"column":8},"end":{"line":55,"column":73}},"10":{"start":{"line":73,"column":8},"end":{"line":76,"column":31}},"11":{"start":{"line":78,"column":8},"end":{"line":80,"column":9}},"12":{"start":{"line":79,"column":12},"end":{"line":79,"column":63}},"13":{"start":{"line":81,"column":8},"end":{"line":81,"column":19}},"14":{"start":{"line":95,"column":8},"end":{"line":95,"column":41}},"15":{"start":{"line":100,"column":8},"end":{"line":109,"column":11}},"16":{"start":{"line":102,"column":12},"end":{"line":108,"column":15}},"17":{"start":{"line":105,"column":16},"end":{"line":107,"column":17}},"18":{"start":{"line":106,"column":20},"end":{"line":106,"column":43}},"19":{"start":{"line":120,"column":8},"end":{"line":121,"column":15}},"20":{"start":{"line":125,"column":8},"end":{"line":136,"column":11}},"21":{"start":{"line":127,"column":12},"end":{"line":135,"column":15}},"22":{"start":{"line":129,"column":16},"end":{"line":129,"column":41}},"23":{"start":{"line":132,"column":16},"end":{"line":134,"column":17}},"24":{"start":{"line":133,"column":20},"end":{"line":133,"column":37}},"25":{"start":{"line":148,"column":8},"end":{"line":148,"column":28}},"26":{"start":{"line":149,"column":8},"end":{"line":149,"column":34}},"27":{"start":{"line":150,"column":8},"end":{"line":150,"column":28}},"28":{"start":{"line":151,"column":8},"end":{"line":151,"column":31}},"29":{"start":{"line":198,"column":8},"end":{"line":198,"column":42}},"30":{"start":{"line":199,"column":8},"end":{"line":199,"column":44}},"31":{"start":{"line":200,"column":8},"end":{"line":200,"column":37}},"32":{"start":{"line":202,"column":8},"end":{"line":202,"column":25}},"33":{"start":{"line":215,"column":8},"end":{"line":215,"column":43}},"34":{"start":{"line":223,"column":0},"end":{"line":223,"column":58}}},"branchMap":{"1":{"line":102,"type":"binary-expr","locations":[{"start":{"line":102,"column":19},"end":{"line":102,"column":26}},{"start":{"line":102,"column":30},"end":{"line":102,"column":39}}]},"2":{"line":105,"type":"if","locations":[{"start":{"line":105,"column":16},"end":{"line":105,"column":16}},{"start":{"line":105,"column":16},"end":{"line":105,"column":16}}]},"3":{"line":127,"type":"binary-expr","locations":[{"start":{"line":127,"column":19},"end":{"line":127,"column":28}},{"start":{"line":127,"column":32},"end":{"line":127,"column":45}}]},"4":{"line":132,"type":"if","locations":[{"start":{"line":132,"column":16},"end":{"line":132,"column":16}},{"start":{"line":132,"column":16},"end":{"line":132,"column":16}}]},"5":{"line":132,"type":"binary-expr","locations":[{"start":{"line":132,"column":20},"end":{"line":132,"column":26}},{"start":{"line":132,"column":30},"end":{"line":132,"column":45}}]}},"code":["(function () { YUI.add('recordset-indexer', function (Y, NAME) {","","/**"," * Provides the ability to store multiple custom hash tables referencing records in the recordset."," * @module recordset"," * @submodule recordset-indexer"," */","/**"," * Plugin that provides the ability to store multiple custom hash tables referencing records in the recordset."," * This utility does not support any collision handling. New hash table entries with a used key overwrite older ones."," * @class RecordsetIndexer"," */","function RecordsetIndexer(config) {","    RecordsetIndexer.superclass.constructor.apply(this, arguments);","}","","Y.mix(RecordsetIndexer, {","    NS: \"indexer\",","","    NAME: \"recordsetIndexer\",","","    ATTRS: {","        /**","        * @description Collection of all the hashTables created by the plugin.","        * The individual tables can be accessed by the key they are hashing against.","        *","        * @attribute hashTables","        * @public","        * @type object","        */","        hashTables: {","            value: {","","            }","        },","","","        keys: {","            value: {","","            }","        }","    }","});","","","Y.extend(RecordsetIndexer, Y.Plugin.Base, {","","    initializer: function(config) {","        var host = this.get('host');","","        //setup listeners on recordset events","        this.onHostEvent('add', Y.bind(\"_defAddHash\", this), host);","        this.onHostEvent('remove', Y.bind('_defRemoveHash', this), host);","        this.onHostEvent('update', Y.bind('_defUpdateHash', this), host);","","    },","","    destructor: function(config) {","","    },","","","    /**","     * @description Setup the hash table for a given key with all existing records in the recordset","     *","     * @method _setHashTable","     * @param key {string} A key to hash by.","     * @return obj {object} The created hash table","     * @private","     */","    _setHashTable: function(key) {","        var host = this.get('host'),","        obj = {},","        i = 0,","        len = host.getLength();","","        for (; i < len; i++) {","            obj[host._items[i].getValue(key)] = host._items[i];","        }","        return obj;","    },","","    //---------------------------------------------","    // Syncing Methods","    //---------------------------------------------","","    /**","     * @description Updates all hash tables when a record is added to the recordset","     *","     * @method _defAddHash","     * @private","     */","    _defAddHash: function(e) {","        var tbl = this.get('hashTables');","","","        //Go through every hashtable that is stored.","        //in each hashtable, look to see if the key is represented in the object being added.","        Y.each(tbl,","        function(v, key) {","            Y.each(e.added || e.updated,","            function(o) {","                //if the object being added has a key which is being stored by hashtable v, add it into the table.","                if (o.getValue(key)) {","                    v[o.getValue(key)] = o;","                }","            });","        });","","    },","","    /**","     * @description Updates all hash tables when a record is removed from the recordset","     *","     * @method _defRemoveHash","     * @private","     */","    _defRemoveHash: function(e) {","        var tbl = this.get('hashTables'),","        reckey;","","        //Go through every hashtable that is stored.","        //in each hashtable, look to see if the key is represented in the object being deleted.","        Y.each(tbl,","        function(v, key) {","            Y.each(e.removed || e.overwritten,","            function(o) {","                reckey = o.getValue(key);","","                //if the hashtable has a key storing a record, and the key and the record both match the record being deleted, delete that row from the hashtable","                if (reckey && v[reckey] === o) {","                    delete v[reckey];","                }","            });","        });","    },","","    /**","     * @description Updates all hash tables when the recordset is updated (a combination of add and remove)","     *","     * @method _defUpdateHash","     * @private","     */","    _defUpdateHash: function(e) {","","        //TODO: It will be more performant to create a new method rather than using _defAddHash, _defRemoveHash, due to the number of loops. See commented code.","        e.added = e.updated;","        e.removed = e.overwritten;","        this._defAddHash(e);","        this._defRemoveHash(e);","","        /*","                    var tbl = this.get('hashTables'), reckey;","","                    Y.each(tbl, function(v, key) {","                        Y.each(e.updated, function(o, i) {","","                            //delete record from hashtable if it has been overwritten","                            reckey = o.getValue(key);","","                            if (reckey) {","                                v[reckey] = o;","                            }","","                            //the undefined case is if more records are updated than currently exist in the recordset.","                            if (e.overwritten[i] && (v[e.overwritten[i].getValue(key)] === e.overwritten[i])) {","                                delete v[e.overwritten[i].getValue(key)];","                            }","","                            // if (v[reckey] === o) {","                            //  delete v[reckey];","                            // }","                            //","                            // //add the new updated record if it has a key that corresponds to a hash table","                            // if (o.getValue(key)) {","                            //  v[o.getValue(key)] = o;","                            // }","","                        });","                    });","            */","    },","","    //---------------------------------------------","    // Public Methods","    //---------------------------------------------","","    /**","     * @description Creates a new hash table.","     *","     * @method createTable","     * @param key {string} A key to hash by.","     * @return tbls[key] {object} The created hash table","     * @public","     */","    createTable: function(key) {","        var tbls = this.get('hashTables');","        tbls[key] = this._setHashTable(key);","        this.set('hashTables', tbls);","","        return tbls[key];","    },","","","    /**","     * @description Get a hash table that hashes records by a given key.","     *","     * @method getTable","     * @param key {string} A key to hash by.","     * @return table {object} The created hash table","     * @public","     */","    getTable: function(key) {","        return this.get('hashTables')[key];","    }","","","","","","});","Y.namespace(\"Plugin\").RecordsetIndexer = RecordsetIndexer;","","","","}, 'patched-v3.20.6', {\"requires\": [\"recordset-base\", \"plugin\"]});","","}());"]};
}
var __cov_M5zRLEUB28v6Psvoto8_ow = __coverage__['build/recordset-indexer/recordset-indexer.js'];
__cov_M5zRLEUB28v6Psvoto8_ow.s['1']++;YUI.add('recordset-indexer',function(Y,NAME){__cov_M5zRLEUB28v6Psvoto8_ow.f['1']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['2']++;function RecordsetIndexer(config){__cov_M5zRLEUB28v6Psvoto8_ow.f['2']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['3']++;RecordsetIndexer.superclass.constructor.apply(this,arguments);}__cov_M5zRLEUB28v6Psvoto8_ow.s['4']++;Y.mix(RecordsetIndexer,{NS:'indexer',NAME:'recordsetIndexer',ATTRS:{hashTables:{value:{}},keys:{value:{}}}});__cov_M5zRLEUB28v6Psvoto8_ow.s['5']++;Y.extend(RecordsetIndexer,Y.Plugin.Base,{initializer:function(config){__cov_M5zRLEUB28v6Psvoto8_ow.f['3']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['6']++;var host=this.get('host');__cov_M5zRLEUB28v6Psvoto8_ow.s['7']++;this.onHostEvent('add',Y.bind('_defAddHash',this),host);__cov_M5zRLEUB28v6Psvoto8_ow.s['8']++;this.onHostEvent('remove',Y.bind('_defRemoveHash',this),host);__cov_M5zRLEUB28v6Psvoto8_ow.s['9']++;this.onHostEvent('update',Y.bind('_defUpdateHash',this),host);},destructor:function(config){__cov_M5zRLEUB28v6Psvoto8_ow.f['4']++;},_setHashTable:function(key){__cov_M5zRLEUB28v6Psvoto8_ow.f['5']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['10']++;var host=this.get('host'),obj={},i=0,len=host.getLength();__cov_M5zRLEUB28v6Psvoto8_ow.s['11']++;for(;i<len;i++){__cov_M5zRLEUB28v6Psvoto8_ow.s['12']++;obj[host._items[i].getValue(key)]=host._items[i];}__cov_M5zRLEUB28v6Psvoto8_ow.s['13']++;return obj;},_defAddHash:function(e){__cov_M5zRLEUB28v6Psvoto8_ow.f['6']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['14']++;var tbl=this.get('hashTables');__cov_M5zRLEUB28v6Psvoto8_ow.s['15']++;Y.each(tbl,function(v,key){__cov_M5zRLEUB28v6Psvoto8_ow.f['7']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['16']++;Y.each((__cov_M5zRLEUB28v6Psvoto8_ow.b['1'][0]++,e.added)||(__cov_M5zRLEUB28v6Psvoto8_ow.b['1'][1]++,e.updated),function(o){__cov_M5zRLEUB28v6Psvoto8_ow.f['8']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['17']++;if(o.getValue(key)){__cov_M5zRLEUB28v6Psvoto8_ow.b['2'][0]++;__cov_M5zRLEUB28v6Psvoto8_ow.s['18']++;v[o.getValue(key)]=o;}else{__cov_M5zRLEUB28v6Psvoto8_ow.b['2'][1]++;}});});},_defRemoveHash:function(e){__cov_M5zRLEUB28v6Psvoto8_ow.f['9']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['19']++;var tbl=this.get('hashTables'),reckey;__cov_M5zRLEUB28v6Psvoto8_ow.s['20']++;Y.each(tbl,function(v,key){__cov_M5zRLEUB28v6Psvoto8_ow.f['10']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['21']++;Y.each((__cov_M5zRLEUB28v6Psvoto8_ow.b['3'][0]++,e.removed)||(__cov_M5zRLEUB28v6Psvoto8_ow.b['3'][1]++,e.overwritten),function(o){__cov_M5zRLEUB28v6Psvoto8_ow.f['11']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['22']++;reckey=o.getValue(key);__cov_M5zRLEUB28v6Psvoto8_ow.s['23']++;if((__cov_M5zRLEUB28v6Psvoto8_ow.b['5'][0]++,reckey)&&(__cov_M5zRLEUB28v6Psvoto8_ow.b['5'][1]++,v[reckey]===o)){__cov_M5zRLEUB28v6Psvoto8_ow.b['4'][0]++;__cov_M5zRLEUB28v6Psvoto8_ow.s['24']++;delete v[reckey];}else{__cov_M5zRLEUB28v6Psvoto8_ow.b['4'][1]++;}});});},_defUpdateHash:function(e){__cov_M5zRLEUB28v6Psvoto8_ow.f['12']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['25']++;e.added=e.updated;__cov_M5zRLEUB28v6Psvoto8_ow.s['26']++;e.removed=e.overwritten;__cov_M5zRLEUB28v6Psvoto8_ow.s['27']++;this._defAddHash(e);__cov_M5zRLEUB28v6Psvoto8_ow.s['28']++;this._defRemoveHash(e);},createTable:function(key){__cov_M5zRLEUB28v6Psvoto8_ow.f['13']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['29']++;var tbls=this.get('hashTables');__cov_M5zRLEUB28v6Psvoto8_ow.s['30']++;tbls[key]=this._setHashTable(key);__cov_M5zRLEUB28v6Psvoto8_ow.s['31']++;this.set('hashTables',tbls);__cov_M5zRLEUB28v6Psvoto8_ow.s['32']++;return tbls[key];},getTable:function(key){__cov_M5zRLEUB28v6Psvoto8_ow.f['14']++;__cov_M5zRLEUB28v6Psvoto8_ow.s['33']++;return this.get('hashTables')[key];}});__cov_M5zRLEUB28v6Psvoto8_ow.s['34']++;Y.namespace('Plugin').RecordsetIndexer=RecordsetIndexer;},'patched-v3.20.6',{'requires':['recordset-base','plugin']});
