if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/history-html5/history-html5.js']) {
   __coverage__['build/history-html5/history-html5.js'] = {"path":"build/history-html5/history-html5.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0,0],"5":[0,0],"6":[0,0],"7":[0,0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":25},"end":{"line":1,"column":44}}},"2":{"name":"HistoryHTML5","line":57,"loc":{"start":{"line":57,"column":0},"end":{"line":57,"column":24}}},"3":{"name":"(anonymous_3)","line":63,"loc":{"start":{"line":63,"column":11},"end":{"line":63,"column":29}}},"4":{"name":"(anonymous_4)","line":110,"loc":{"start":{"line":110,"column":17},"end":{"line":110,"column":51}}},"5":{"name":"(anonymous_5)","line":131,"loc":{"start":{"line":131,"column":17},"end":{"line":131,"column":30}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":189,"column":97}},"2":{"start":{"line":49,"column":0},"end":{"line":55,"column":46}},"3":{"start":{"line":57,"column":0},"end":{"line":59,"column":1}},"4":{"start":{"line":58,"column":4},"end":{"line":58,"column":63}},"5":{"start":{"line":61,"column":0},"end":{"line":148,"column":3}},"6":{"start":{"line":64,"column":8},"end":{"line":64,"column":28}},"7":{"start":{"line":66,"column":8},"end":{"line":70,"column":9}},"8":{"start":{"line":67,"column":12},"end":{"line":67,"column":48}},"9":{"start":{"line":69,"column":12},"end":{"line":69,"column":35}},"10":{"start":{"line":73,"column":8},"end":{"line":75,"column":9}},"11":{"start":{"line":74,"column":12},"end":{"line":74,"column":35}},"12":{"start":{"line":77,"column":8},"end":{"line":77,"column":32}},"13":{"start":{"line":81,"column":8},"end":{"line":91,"column":9}},"14":{"start":{"line":85,"column":12},"end":{"line":85,"column":79}},"15":{"start":{"line":90,"column":12},"end":{"line":90,"column":49}},"16":{"start":{"line":93,"column":8},"end":{"line":93,"column":54}},"17":{"start":{"line":95,"column":8},"end":{"line":95,"column":61}},"18":{"start":{"line":111,"column":8},"end":{"line":117,"column":9}},"19":{"start":{"line":112,"column":12},"end":{"line":116,"column":14}},"20":{"start":{"line":119,"column":8},"end":{"line":119,"column":67}},"21":{"start":{"line":132,"column":8},"end":{"line":132,"column":67}},"22":{"start":{"line":150,"column":0},"end":{"line":152,"column":1}},"23":{"start":{"line":151,"column":4},"end":{"line":151,"column":35}},"24":{"start":{"line":154,"column":0},"end":{"line":154,"column":30}},"25":{"start":{"line":183,"column":0},"end":{"line":186,"column":1}},"26":{"start":{"line":185,"column":4},"end":{"line":185,"column":29}}},"branchMap":{"1":{"line":73,"type":"if","locations":[{"start":{"line":73,"column":8},"end":{"line":73,"column":8}},{"start":{"line":73,"column":8},"end":{"line":73,"column":8}}]},"2":{"line":77,"type":"binary-expr","locations":[{"start":{"line":77,"column":8},"end":{"line":77,"column":14}},{"start":{"line":77,"column":19},"end":{"line":77,"column":30}}]},"3":{"line":81,"type":"if","locations":[{"start":{"line":81,"column":8},"end":{"line":81,"column":8}},{"start":{"line":81,"column":8},"end":{"line":81,"column":8}}]},"4":{"line":81,"type":"binary-expr","locations":[{"start":{"line":81,"column":12},"end":{"line":81,"column":31}},{"start":{"line":82,"column":19},"end":{"line":82,"column":62}},{"start":{"line":83,"column":19},"end":{"line":83,"column":58}}]},"5":{"line":111,"type":"if","locations":[{"start":{"line":111,"column":8},"end":{"line":111,"column":8}},{"start":{"line":111,"column":8},"end":{"line":111,"column":8}}]},"6":{"line":112,"type":"cond-expr","locations":[{"start":{"line":112,"column":46},"end":{"line":112,"column":60}},{"start":{"line":112,"column":63},"end":{"line":112,"column":74}}]},"7":{"line":114,"type":"binary-expr","locations":[{"start":{"line":114,"column":16},"end":{"line":114,"column":29}},{"start":{"line":114,"column":33},"end":{"line":114,"column":51}},{"start":{"line":114,"column":55},"end":{"line":114,"column":57}}]},"8":{"line":115,"type":"binary-expr","locations":[{"start":{"line":115,"column":16},"end":{"line":115,"column":27}},{"start":{"line":115,"column":31},"end":{"line":115,"column":47}}]},"9":{"line":132,"type":"binary-expr","locations":[{"start":{"line":132,"column":43},"end":{"line":132,"column":57}},{"start":{"line":132,"column":61},"end":{"line":132,"column":65}}]},"10":{"line":150,"type":"if","locations":[{"start":{"line":150,"column":0},"end":{"line":150,"column":0}},{"start":{"line":150,"column":0},"end":{"line":150,"column":0}}]},"11":{"line":183,"type":"if","locations":[{"start":{"line":183,"column":0},"end":{"line":183,"column":0}},{"start":{"line":183,"column":0},"end":{"line":183,"column":0}}]},"12":{"line":183,"type":"binary-expr","locations":[{"start":{"line":183,"column":4},"end":{"line":183,"column":28}},{"start":{"line":183,"column":33},"end":{"line":183,"column":58}},{"start":{"line":184,"column":8},"end":{"line":184,"column":25}}]}},"code":["(function () { YUI.add('history-html5', function (Y, NAME) {","","/**"," * Provides browser history management using the HTML5 history API."," *"," * @module history"," * @submodule history-html5"," * @since 3.2.0"," */","","/**"," * <p>"," * Provides browser history management using the HTML5 history API."," * </p>"," *"," * <p>"," * When calling the <code>add()</code>, <code>addValue()</code>,"," * <code>replace()</code>, or <code>replaceValue()</code> methods on"," * <code>HistoryHTML5</code>, the following additional options are supported:"," * </p>"," *"," * <dl>"," *   <dt><strong>title (String)</strong></dt>"," *   <dd>"," *     Title to use for the new history entry. Browsers will typically display"," *     this title to the user in the detailed history window or in a dropdown"," *     menu attached to the back/forward buttons. If not specified, the title"," *     of the current document will be used."," *   </dd>"," *"," *   <dt><strong>url (String)</strong></dt>"," *   <dd>"," *     URL to display to the user for the new history entry. This URL will be"," *     visible in the browser's address bar and will be the bookmarked URL if"," *     the user bookmarks the page. It may be a relative path (\"foo/bar\"), an"," *     absolute path (\"/foo/bar\"), or a full URL (\"http://example.com/foo/bar\")."," *     If you specify a full URL, the origin <i>must</i> be the same as the"," *     origin of the current page, or an error will occur. If no URL is"," *     specified, the current URL will not be changed."," *   </dd>"," * </dl>"," *"," * @class HistoryHTML5"," * @extends HistoryBase"," * @constructor"," * @param {Object} config (optional) Configuration object."," */","","var HistoryBase     = Y.HistoryBase,","    Lang            = Y.Lang,","    win             = Y.config.win,","    useHistoryHTML5 = Y.config.useHistoryHTML5,","","    SRC_POPSTATE    = 'popstate',","    SRC_REPLACE     = HistoryBase.SRC_REPLACE;","","function HistoryHTML5() {","    HistoryHTML5.superclass.constructor.apply(this, arguments);","}","","Y.extend(HistoryHTML5, HistoryBase, {","    // -- Initialization -------------------------------------------------------","    _init: function (config) {","        var bookmarkedState;","","        try {","            bookmarkedState = win.history.state;","        } catch(e) {","            bookmarkedState = null;","        }","","        // Treat empty state objects as `null` so they're not processed further.","        if (Y.Object.isEmpty(bookmarkedState)) {","            bookmarkedState = null;","        }","","        config || (config = {});","","        // If both the initial state and the bookmarked state are objects, merge","        // them (bookmarked state wins).","        if (config.initialState","                && Lang.type(config.initialState) === 'object'","                && Lang.type(bookmarkedState) === 'object') {","","            this._initialState = Y.merge(config.initialState, bookmarkedState);","        } else {","            // Otherwise, the bookmarked state always wins if there is one. If","            // there isn't a bookmarked state, history-base will take care of","            // falling back to config.initialState or null.","            this._initialState = bookmarkedState;","        }","","        Y.on('popstate', this._onPopState, win, this);","","        HistoryHTML5.superclass._init.apply(this, arguments);","    },","","    // -- Protected Methods ----------------------------------------------------","","    /**","     * Overrides HistoryBase's <code>_storeState()</code> and pushes or replaces","     * a history entry using the HTML5 history API when necessary.","     *","     * @method _storeState","     * @param {String} src Source of the changes.","     * @param {Object} newState New state to store.","     * @param {Object} options Zero or more options.","     * @protected","     */","    _storeState: function (src, newState, options) {","        if (src !== SRC_POPSTATE) {","            win.history[src === SRC_REPLACE ? 'replaceState' : 'pushState'](","                newState,","                options.title || Y.config.doc.title || '',","                options.url || Y.config.doc.URL","            );","        }","","        HistoryHTML5.superclass._storeState.apply(this, arguments);","    },","","    // -- Protected Event Handlers ---------------------------------------------","","    /**","     * Handler for popstate events.","     *","     * @method _onPopState","     * @param {Event} e","     * @protected","     */","    _onPopState: function (e) {","        this._resolveChanges(SRC_POPSTATE, e._event.state || null);","    }","}, {","    // -- Public Static Properties ---------------------------------------------","    NAME: 'historyhtml5',","","    /**","     * Constant used to identify state changes originating from","     * <code>popstate</code> events.","     *","     * @property SRC_POPSTATE","     * @type String","     * @static","     * @final","     */","    SRC_POPSTATE: SRC_POPSTATE","});","","if (!Y.Node.DOM_EVENTS.popstate) {","    Y.Node.DOM_EVENTS.popstate = 1;","}","","Y.HistoryHTML5 = HistoryHTML5;","","/**"," * <p>"," * If <code>true</code>, the <code>Y.History</code> alias will always point to"," * <code>Y.HistoryHTML5</code> when the history-html5 module is loaded, even if"," * the current browser doesn't support HTML5 history."," * </p>"," *"," * <p>"," * If <code>false</code>, the <code>Y.History</code> alias will always point to"," * <code>Y.HistoryHash</code> when the history-hash module is loaded, even if"," * the current browser supports HTML5 history."," * </p>"," *"," * <p>"," * If neither <code>true</code> nor <code>false</code>, the"," * <code>Y.History</code> alias will point to the best available history adapter"," * that the browser supports. This is the default behavior."," * </p>"," *"," * @property useHistoryHTML5"," * @type boolean"," * @for config"," * @since 3.2.0"," */","","// HistoryHTML5 will always win over HistoryHash unless useHistoryHTML5 is false","// or HTML5 history is not supported.","if (useHistoryHTML5 === true || (useHistoryHTML5 !== false &&","        HistoryBase.html5)) {","    Y.History = HistoryHTML5;","}","","","}, 'patched-v3.19.2', {\"optional\": [\"json\"], \"requires\": [\"event-base\", \"history-base\", \"node-base\"]});","","}());"]};
}
var __cov_NFPIa1bKbyM4xoYxYAMxhQ = __coverage__['build/history-html5/history-html5.js'];
__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['1']++;YUI.add('history-html5',function(Y,NAME){__cov_NFPIa1bKbyM4xoYxYAMxhQ.f['1']++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['2']++;var HistoryBase=Y.HistoryBase,Lang=Y.Lang,win=Y.config.win,useHistoryHTML5=Y.config.useHistoryHTML5,SRC_POPSTATE='popstate',SRC_REPLACE=HistoryBase.SRC_REPLACE;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['3']++;function HistoryHTML5(){__cov_NFPIa1bKbyM4xoYxYAMxhQ.f['2']++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['4']++;HistoryHTML5.superclass.constructor.apply(this,arguments);}__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['5']++;Y.extend(HistoryHTML5,HistoryBase,{_init:function(config){__cov_NFPIa1bKbyM4xoYxYAMxhQ.f['3']++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['6']++;var bookmarkedState;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['7']++;try{__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['8']++;bookmarkedState=win.history.state;}catch(e){__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['9']++;bookmarkedState=null;}__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['10']++;if(Y.Object.isEmpty(bookmarkedState)){__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['1'][0]++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['11']++;bookmarkedState=null;}else{__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['1'][1]++;}__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['12']++;(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['2'][0]++,config)||(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['2'][1]++,config={});__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['13']++;if((__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['4'][0]++,config.initialState)&&(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['4'][1]++,Lang.type(config.initialState)==='object')&&(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['4'][2]++,Lang.type(bookmarkedState)==='object')){__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['3'][0]++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['14']++;this._initialState=Y.merge(config.initialState,bookmarkedState);}else{__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['3'][1]++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['15']++;this._initialState=bookmarkedState;}__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['16']++;Y.on('popstate',this._onPopState,win,this);__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['17']++;HistoryHTML5.superclass._init.apply(this,arguments);},_storeState:function(src,newState,options){__cov_NFPIa1bKbyM4xoYxYAMxhQ.f['4']++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['18']++;if(src!==SRC_POPSTATE){__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['5'][0]++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['19']++;win.history[src===SRC_REPLACE?(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['6'][0]++,'replaceState'):(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['6'][1]++,'pushState')](newState,(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['7'][0]++,options.title)||(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['7'][1]++,Y.config.doc.title)||(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['7'][2]++,''),(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['8'][0]++,options.url)||(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['8'][1]++,Y.config.doc.URL));}else{__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['5'][1]++;}__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['20']++;HistoryHTML5.superclass._storeState.apply(this,arguments);},_onPopState:function(e){__cov_NFPIa1bKbyM4xoYxYAMxhQ.f['5']++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['21']++;this._resolveChanges(SRC_POPSTATE,(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['9'][0]++,e._event.state)||(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['9'][1]++,null));}},{NAME:'historyhtml5',SRC_POPSTATE:SRC_POPSTATE});__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['22']++;if(!Y.Node.DOM_EVENTS.popstate){__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['10'][0]++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['23']++;Y.Node.DOM_EVENTS.popstate=1;}else{__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['10'][1]++;}__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['24']++;Y.HistoryHTML5=HistoryHTML5;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['25']++;if((__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['12'][0]++,useHistoryHTML5===true)||(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['12'][1]++,useHistoryHTML5!==false)&&(__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['12'][2]++,HistoryBase.html5)){__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['11'][0]++;__cov_NFPIa1bKbyM4xoYxYAMxhQ.s['26']++;Y.History=HistoryHTML5;}else{__cov_NFPIa1bKbyM4xoYxYAMxhQ.b['11'][1]++;}},'patched-v3.19.2',{'optional':['json'],'requires':['event-base','history-base','node-base']});
