if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/series-candlestick/series-candlestick.js']) {
   __coverage__['build/series-candlestick/series-candlestick.js'] = {"path":"build/series-candlestick/series-candlestick.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0,0,0,0],"7":[0,0],"8":[0,0,0],"9":[0,0],"10":[0,0],"11":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":30},"end":{"line":1,"column":49}}},"2":{"name":"CandlestickSeries","line":19,"loc":{"start":{"line":19,"column":0},"end":{"line":20,"column":0}}},"3":{"name":"(anonymous_3)","line":48,"loc":{"start":{"line":48,"column":16},"end":{"line":48,"column":30}}},"4":{"name":"(anonymous_4)","line":159,"loc":{"start":{"line":159,"column":18},"end":{"line":160,"column":4}}},"5":{"name":"(anonymous_5)","line":227,"loc":{"start":{"line":227,"column":20},"end":{"line":228,"column":4}}},"6":{"name":"(anonymous_6)","line":240,"loc":{"start":{"line":240,"column":16},"end":{"line":241,"column":4}}},"7":{"name":"(anonymous_7)","line":267,"loc":{"start":{"line":267,"column":23},"end":{"line":268,"column":4}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":314,"column":48}},"2":{"start":{"line":19,"column":0},"end":{"line":22,"column":1}},"3":{"start":{"line":21,"column":4},"end":{"line":21,"column":68}},"4":{"start":{"line":24,"column":0},"end":{"line":24,"column":45}},"5":{"start":{"line":26,"column":0},"end":{"line":141,"column":2}},"6":{"start":{"line":50,"column":12},"end":{"line":52,"column":13}},"7":{"start":{"line":51,"column":16},"end":{"line":51,"column":43}},"8":{"start":{"line":53,"column":12},"end":{"line":55,"column":16}},"9":{"start":{"line":56,"column":12},"end":{"line":58,"column":16}},"10":{"start":{"line":59,"column":12},"end":{"line":61,"column":16}},"11":{"start":{"line":62,"column":12},"end":{"line":62,"column":23}},"12":{"start":{"line":143,"column":0},"end":{"line":310,"column":3}},"13":{"start":{"line":161,"column":8},"end":{"line":180,"column":39}},"14":{"start":{"line":181,"column":8},"end":{"line":181,"column":38}},"15":{"start":{"line":182,"column":8},"end":{"line":182,"column":42}},"16":{"start":{"line":183,"column":8},"end":{"line":187,"column":11}},"17":{"start":{"line":188,"column":8},"end":{"line":188,"column":25}},"18":{"start":{"line":189,"column":8},"end":{"line":189,"column":27}},"19":{"start":{"line":190,"column":8},"end":{"line":190,"column":21}},"20":{"start":{"line":191,"column":8},"end":{"line":213,"column":9}},"21":{"start":{"line":193,"column":12},"end":{"line":193,"column":54}},"22":{"start":{"line":194,"column":12},"end":{"line":194,"column":34}},"23":{"start":{"line":195,"column":12},"end":{"line":195,"column":35}},"24":{"start":{"line":196,"column":12},"end":{"line":196,"column":50}},"25":{"start":{"line":197,"column":12},"end":{"line":197,"column":50}},"26":{"start":{"line":198,"column":12},"end":{"line":198,"column":48}},"27":{"start":{"line":199,"column":12},"end":{"line":199,"column":52}},"28":{"start":{"line":200,"column":12},"end":{"line":200,"column":40}},"29":{"start":{"line":201,"column":12},"end":{"line":201,"column":46}},"30":{"start":{"line":202,"column":12},"end":{"line":202,"column":49}},"31":{"start":{"line":203,"column":12},"end":{"line":203,"column":34}},"32":{"start":{"line":204,"column":12},"end":{"line":204,"column":48}},"33":{"start":{"line":205,"column":12},"end":{"line":208,"column":13}},"34":{"start":{"line":207,"column":16},"end":{"line":207,"column":58}},"35":{"start":{"line":209,"column":12},"end":{"line":212,"column":13}},"36":{"start":{"line":211,"column":16},"end":{"line":211,"column":92}},"37":{"start":{"line":214,"column":8},"end":{"line":214,"column":23}},"38":{"start":{"line":215,"column":8},"end":{"line":215,"column":25}},"39":{"start":{"line":216,"column":8},"end":{"line":216,"column":19}},"40":{"start":{"line":217,"column":8},"end":{"line":217,"column":22}},"41":{"start":{"line":229,"column":8},"end":{"line":229,"column":53}},"42":{"start":{"line":230,"column":8},"end":{"line":230,"column":55}},"43":{"start":{"line":231,"column":8},"end":{"line":231,"column":49}},"44":{"start":{"line":242,"column":8},"end":{"line":244,"column":36}},"45":{"start":{"line":245,"column":8},"end":{"line":248,"column":9}},"46":{"start":{"line":247,"column":12},"end":{"line":247,"column":31}},"47":{"start":{"line":249,"column":8},"end":{"line":252,"column":9}},"48":{"start":{"line":251,"column":12},"end":{"line":251,"column":33}},"49":{"start":{"line":253,"column":8},"end":{"line":256,"column":9}},"50":{"start":{"line":255,"column":12},"end":{"line":255,"column":27}},"51":{"start":{"line":269,"column":8},"end":{"line":307,"column":10}},"52":{"start":{"line":308,"column":8},"end":{"line":308,"column":91}},"53":{"start":{"line":311,"column":0},"end":{"line":311,"column":40}}},"branchMap":{"1":{"line":50,"type":"if","locations":[{"start":{"line":50,"column":12},"end":{"line":50,"column":12}},{"start":{"line":50,"column":12},"end":{"line":50,"column":12}}]},"2":{"line":201,"type":"cond-expr","locations":[{"start":{"line":201,"column":23},"end":{"line":201,"column":33}},{"start":{"line":201,"column":36},"end":{"line":201,"column":45}}]},"3":{"line":202,"type":"cond-expr","locations":[{"start":{"line":202,"column":26},"end":{"line":202,"column":35}},{"start":{"line":202,"column":38},"end":{"line":202,"column":48}}]},"4":{"line":204,"type":"cond-expr","locations":[{"start":{"line":204,"column":26},"end":{"line":204,"column":34}},{"start":{"line":204,"column":37},"end":{"line":204,"column":47}}]},"5":{"line":205,"type":"if","locations":[{"start":{"line":205,"column":12},"end":{"line":205,"column":12}},{"start":{"line":205,"column":12},"end":{"line":205,"column":12}}]},"6":{"line":205,"type":"binary-expr","locations":[{"start":{"line":205,"column":15},"end":{"line":205,"column":21}},{"start":{"line":205,"column":25},"end":{"line":205,"column":39}},{"start":{"line":205,"column":43},"end":{"line":205,"column":56}},{"start":{"line":205,"column":60},"end":{"line":205,"column":75}},{"start":{"line":205,"column":79},"end":{"line":205,"column":95}}]},"7":{"line":209,"type":"if","locations":[{"start":{"line":209,"column":12},"end":{"line":209,"column":12}},{"start":{"line":209,"column":12},"end":{"line":209,"column":12}}]},"8":{"line":209,"type":"binary-expr","locations":[{"start":{"line":209,"column":15},"end":{"line":209,"column":27}},{"start":{"line":209,"column":31},"end":{"line":209,"column":50}},{"start":{"line":209,"column":54},"end":{"line":209,"column":72}}]},"9":{"line":245,"type":"if","locations":[{"start":{"line":245,"column":8},"end":{"line":245,"column":8}},{"start":{"line":245,"column":8},"end":{"line":245,"column":8}}]},"10":{"line":249,"type":"if","locations":[{"start":{"line":249,"column":8},"end":{"line":249,"column":8}},{"start":{"line":249,"column":8},"end":{"line":249,"column":8}}]},"11":{"line":253,"type":"if","locations":[{"start":{"line":253,"column":8},"end":{"line":253,"column":8}},{"start":{"line":253,"column":8},"end":{"line":253,"column":8}}]}},"code":["(function () { YUI.add('series-candlestick', function (Y, NAME) {","","/**"," * Provides functionality for creating a candlestick series."," *"," * @module charts"," * @submodule series-candlestick"," */","/**"," * The CandlestickSeries class renders columns (candles) and lines (wicks) representing the open, high, low and close"," * values for a chart."," *"," * @class CandlestickSeries"," * @extends RangeSeries"," * @constructor"," * @param {Object} config (optional) Configuration parameters."," * @submodule series-candlestick"," */","function CandlestickSeries()","{","    CandlestickSeries.superclass.constructor.apply(this, arguments);","}","","CandlestickSeries.NAME = \"candlestickSeries\";","","CandlestickSeries.ATTRS = {","    /**","     * Read-only attribute indicating the type of series.","     *","     * @attribute type","     * @type String","     * @readOnly","     * @default candlestick","     */","    type: {","        value: \"candlestick\"","    },","","    /**","     * The graphic in which drawings will be rendered.","     *","     * @attribute graphic","     * @type Graphic","     */","    graphic: {","        lazyAdd: false,","","        setter: function(val) {","            //woraround for Attribute order of operations bug","            if(!this.get(\"rendered\")) {","                this.set(\"rendered\", true);","            }","            this.set(\"upcandle\", val.addShape({","               type: \"path\"","            }));","            this.set(\"downcandle\", val.addShape({","               type: \"path\"","            }));","            this.set(\"wick\", val.addShape({","               type: \"path\"","            }));","            return val;","        }","    },","","    /**","     * Reference to the candlestick used when the close value is higher than the open value.","     *","     * @attribute upcandle","     * @type Path","     */","    upcandle: {},","","    /**","     * Reference to the candlestick used when the open value is higher than the close value.","     *","     * @attribute downcandle","     * @type Path","     */","    downcandle: {},","","    /**","     * Reference to the line drawn between the high and low values.","     *","     * @attribute wick","     * @type Path","     */","    wick: {}","","    /**","     * Style properties used for drawing candles and wicks. This attribute is inherited from `RangeSeries`. Below are the default values:","     *  <dl>","     *      <dt>upcandle</dt><dd>Properties for a candle representing a period that closes higher than it opens.","     *          <dl>","     *              <dt>fill</dt><dd>A hash containing the following values:","     *                  <dl>","     *                      <dt>color</dt><dd>Color of the fill. The default value is \"#00aa00\".</dd>","     *                      </dd>","     *                      <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>","     *                  </dl>","     *              </dd>","     *              <dt>border</dt><dd>A hash containing the following values:","     *                  <dl>","     *                      <dt>color</dt><dd>Color of the border. The default value is \"#000000\".</dd>","     *                      <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>","     *                      <dt>weight</dt><dd>Number indicating the width of the border. The default value is 0.</dd>","     *                  </dl>","     *              </dd>","     *          </dl>","     *      </dd>","     *      <dt>downcandle</dt><dd>Properties for a candle representing a period that opens higher than it closes.","     *          <dl>","     *              <dt>fill</dt><dd>A hash containing the following values:","     *                  <dl>","     *                      <dt>color</dt><dd>Color of the fill. The default value is \"#aa0000\".</dd>","     *                      </dd>","     *                      <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker fill. The default value is 1.</dd>","     *                  </dl>","     *              </dd>","     *              <dt>border</dt><dd>A hash containing the following values:","     *                  <dl>","     *                      <dt>color</dt><dd>Color of the border. The default value is \"#000000\".</dd>","     *                      <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the marker border. The default value is 1.</dd>","     *                      <dt>weight</dt><dd>Number indicating the width of the border. The default value is 0.</dd>","     *                  </dl>","     *              </dd>","     *          </dl>","     *      </dd>","     *      <dt>wick</dt><dd>Properties for the wick, which is a line drawn from the high point of the period to the low point of the period.","     *          <dl>","     *              <dt>color</dt><dd>The color of the wick. The default value is \"#000000\".</dd>","     *              <dt>weight</dt><dd>The weight of the wick. The default value is 1.</dd>","     *              <dt>alpha</dt><dd>Number from 0 to 1 indicating the opacity of the wick. The default value is 1.</dd>","     *          </dl>","     *      </dd>","     *  </dl>","     *","     * @attribute styles","     * @type Object","     */","};","","Y.extend(CandlestickSeries, Y.RangeSeries, {","    /**","     * Draws markers for an Candlestick series.","     *","     * @method","     * @param {Array} xcoords The xcoordinates to be plotted.","     * @param {Array} opencoords The coordinates representing the open values.","     * @param {Array} highcoords The coordinates representing the high values.","     * @param {Array} lowcoords The coordinates representing the low values.","     * @param {Array} closecoords The coordinates representing the close values.","     * @param {Number} len The number of x coordinates to plot.","     * @param {Number} width The width of each candlestick marker.","     * @param {Number} halfwidth Half the width of each candlestick marker.","     * @param {Object} styles The styles for the series.","     * @private","     */","    _drawMarkers: function(xcoords, opencoords, highcoords, lowcoords, closecoords, len, width, halfwidth, styles)","    {","        var upcandle = this.get(\"upcandle\"),","            downcandle = this.get(\"downcandle\"),","            candle,","            wick = this.get(\"wick\"),","            wickStyles = styles.wick,","            wickWidth = wickStyles.width,","            cx,","            opencoord,","            highcoord,","            lowcoord,","            closecoord,","            left,","            right,","            top,","            bottom,","            height,","            leftPadding = styles.padding.left,","            up,","            i,","            isNumber = Y.Lang.isNumber;","        upcandle.set(styles.upcandle);","        downcandle.set(styles.downcandle);","        wick.set({","            fill: wickStyles.fill,","            stroke: wickStyles.stroke,","            shapeRendering: wickStyles.shapeRendering","        });","        upcandle.clear();","        downcandle.clear();","        wick.clear();","        for(i = 0; i < len; i = i + 1)","        {","            cx = Math.round(xcoords[i] + leftPadding);","            left = cx - halfwidth;","            right = cx + halfwidth;","            opencoord = Math.round(opencoords[i]);","            highcoord = Math.round(highcoords[i]);","            lowcoord = Math.round(lowcoords[i]);","            closecoord = Math.round(closecoords[i]);","            up = opencoord > closecoord;","            top = up ? closecoord : opencoord;","            bottom = up ? opencoord : closecoord;","            height = bottom - top;","            candle = up ? upcandle : downcandle;","            if(candle && isNumber(left) && isNumber(top) && isNumber(width) && isNumber(height))","            {","                candle.drawRect(left, top, width, height);","            }","            if(isNumber(cx) && isNumber(highcoord) && isNumber(lowcoord))","            {","                wick.drawRect(cx - wickWidth/2, highcoord, wickWidth, lowcoord - highcoord);","            }","        }","        upcandle.end();","        downcandle.end();","        wick.end();","        wick.toBack();","    },","","    /**","     * Toggles visibility","     *","     * @method _toggleVisible","     * @param {Boolean} visible indicates visibilitye","     * @private","     */","    _toggleVisible: function(visible)","    {","        this.get(\"upcandle\").set(\"visible\", visible);","        this.get(\"downcandle\").set(\"visible\", visible);","        this.get(\"wick\").set(\"visible\", visible);","    },","","    /**","     * Destructor implementation for the CartesianSeries class. Calls destroy on all Graphic instances.","     *","     * @method destructor","     * @protected","     */","    destructor: function()","    {","        var upcandle = this.get(\"upcandle\"),","            downcandle = this.get(\"downcandle\"),","            wick = this.get(\"wick\");","        if(upcandle)","        {","            upcandle.destroy();","        }","        if(downcandle)","        {","            downcandle.destroy();","        }","        if(wick)","        {","            wick.destroy();","        }","    },","","    /**","     * Gets the default value for the `styles` attribute. Overrides","     * base implementation.","     *","     * @method _getDefaultStyles","     * @return Object","     * @private","     */","    _getDefaultStyles: function()","    {","        var styles = {","            upcandle: {","                shapeRendering: \"crispEdges\",","                fill: {","                    color: \"#00aa00\",","                    alpha: 1","                },","                stroke: {","                    color: \"#000000\",","                    alpha: 1,","                    weight: 0","                }","            },","            downcandle: {","                shapeRendering: \"crispEdges\",","                fill: {","                    color: \"#aa0000\",","                    alpha: 1","                },","                stroke: {","                    color: \"#000000\",","                    alpha: 1,","                    weight: 0","                }","            },","            wick: {","                shapeRendering: \"crispEdges\",","                width: 1,","                fill: {","                    color: \"#000000\",","                    alpha: 1","                },","                stroke: {","                    color: \"#000000\",","                    alpha: 1,","                    weight: 0","                }","            }","        };","        return this._mergeStyles(styles, CandlestickSeries.superclass._getDefaultStyles());","    }","});","Y.CandlestickSeries = CandlestickSeries;","","","}, 'patched-v3.19.2', {\"requires\": [\"series-range\"]});","","}());"]};
}
var __cov_XXJ1k8LcGyiJb$amn$bW9A = __coverage__['build/series-candlestick/series-candlestick.js'];
__cov_XXJ1k8LcGyiJb$amn$bW9A.s['1']++;YUI.add('series-candlestick',function(Y,NAME){__cov_XXJ1k8LcGyiJb$amn$bW9A.f['1']++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['2']++;function CandlestickSeries(){__cov_XXJ1k8LcGyiJb$amn$bW9A.f['2']++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['3']++;CandlestickSeries.superclass.constructor.apply(this,arguments);}__cov_XXJ1k8LcGyiJb$amn$bW9A.s['4']++;CandlestickSeries.NAME='candlestickSeries';__cov_XXJ1k8LcGyiJb$amn$bW9A.s['5']++;CandlestickSeries.ATTRS={type:{value:'candlestick'},graphic:{lazyAdd:false,setter:function(val){__cov_XXJ1k8LcGyiJb$amn$bW9A.f['3']++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['6']++;if(!this.get('rendered')){__cov_XXJ1k8LcGyiJb$amn$bW9A.b['1'][0]++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['7']++;this.set('rendered',true);}else{__cov_XXJ1k8LcGyiJb$amn$bW9A.b['1'][1]++;}__cov_XXJ1k8LcGyiJb$amn$bW9A.s['8']++;this.set('upcandle',val.addShape({type:'path'}));__cov_XXJ1k8LcGyiJb$amn$bW9A.s['9']++;this.set('downcandle',val.addShape({type:'path'}));__cov_XXJ1k8LcGyiJb$amn$bW9A.s['10']++;this.set('wick',val.addShape({type:'path'}));__cov_XXJ1k8LcGyiJb$amn$bW9A.s['11']++;return val;}},upcandle:{},downcandle:{},wick:{}};__cov_XXJ1k8LcGyiJb$amn$bW9A.s['12']++;Y.extend(CandlestickSeries,Y.RangeSeries,{_drawMarkers:function(xcoords,opencoords,highcoords,lowcoords,closecoords,len,width,halfwidth,styles){__cov_XXJ1k8LcGyiJb$amn$bW9A.f['4']++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['13']++;var upcandle=this.get('upcandle'),downcandle=this.get('downcandle'),candle,wick=this.get('wick'),wickStyles=styles.wick,wickWidth=wickStyles.width,cx,opencoord,highcoord,lowcoord,closecoord,left,right,top,bottom,height,leftPadding=styles.padding.left,up,i,isNumber=Y.Lang.isNumber;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['14']++;upcandle.set(styles.upcandle);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['15']++;downcandle.set(styles.downcandle);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['16']++;wick.set({fill:wickStyles.fill,stroke:wickStyles.stroke,shapeRendering:wickStyles.shapeRendering});__cov_XXJ1k8LcGyiJb$amn$bW9A.s['17']++;upcandle.clear();__cov_XXJ1k8LcGyiJb$amn$bW9A.s['18']++;downcandle.clear();__cov_XXJ1k8LcGyiJb$amn$bW9A.s['19']++;wick.clear();__cov_XXJ1k8LcGyiJb$amn$bW9A.s['20']++;for(i=0;i<len;i=i+1){__cov_XXJ1k8LcGyiJb$amn$bW9A.s['21']++;cx=Math.round(xcoords[i]+leftPadding);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['22']++;left=cx-halfwidth;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['23']++;right=cx+halfwidth;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['24']++;opencoord=Math.round(opencoords[i]);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['25']++;highcoord=Math.round(highcoords[i]);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['26']++;lowcoord=Math.round(lowcoords[i]);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['27']++;closecoord=Math.round(closecoords[i]);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['28']++;up=opencoord>closecoord;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['29']++;top=up?(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['2'][0]++,closecoord):(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['2'][1]++,opencoord);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['30']++;bottom=up?(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['3'][0]++,opencoord):(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['3'][1]++,closecoord);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['31']++;height=bottom-top;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['32']++;candle=up?(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['4'][0]++,upcandle):(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['4'][1]++,downcandle);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['33']++;if((__cov_XXJ1k8LcGyiJb$amn$bW9A.b['6'][0]++,candle)&&(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['6'][1]++,isNumber(left))&&(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['6'][2]++,isNumber(top))&&(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['6'][3]++,isNumber(width))&&(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['6'][4]++,isNumber(height))){__cov_XXJ1k8LcGyiJb$amn$bW9A.b['5'][0]++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['34']++;candle.drawRect(left,top,width,height);}else{__cov_XXJ1k8LcGyiJb$amn$bW9A.b['5'][1]++;}__cov_XXJ1k8LcGyiJb$amn$bW9A.s['35']++;if((__cov_XXJ1k8LcGyiJb$amn$bW9A.b['8'][0]++,isNumber(cx))&&(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['8'][1]++,isNumber(highcoord))&&(__cov_XXJ1k8LcGyiJb$amn$bW9A.b['8'][2]++,isNumber(lowcoord))){__cov_XXJ1k8LcGyiJb$amn$bW9A.b['7'][0]++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['36']++;wick.drawRect(cx-wickWidth/2,highcoord,wickWidth,lowcoord-highcoord);}else{__cov_XXJ1k8LcGyiJb$amn$bW9A.b['7'][1]++;}}__cov_XXJ1k8LcGyiJb$amn$bW9A.s['37']++;upcandle.end();__cov_XXJ1k8LcGyiJb$amn$bW9A.s['38']++;downcandle.end();__cov_XXJ1k8LcGyiJb$amn$bW9A.s['39']++;wick.end();__cov_XXJ1k8LcGyiJb$amn$bW9A.s['40']++;wick.toBack();},_toggleVisible:function(visible){__cov_XXJ1k8LcGyiJb$amn$bW9A.f['5']++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['41']++;this.get('upcandle').set('visible',visible);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['42']++;this.get('downcandle').set('visible',visible);__cov_XXJ1k8LcGyiJb$amn$bW9A.s['43']++;this.get('wick').set('visible',visible);},destructor:function(){__cov_XXJ1k8LcGyiJb$amn$bW9A.f['6']++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['44']++;var upcandle=this.get('upcandle'),downcandle=this.get('downcandle'),wick=this.get('wick');__cov_XXJ1k8LcGyiJb$amn$bW9A.s['45']++;if(upcandle){__cov_XXJ1k8LcGyiJb$amn$bW9A.b['9'][0]++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['46']++;upcandle.destroy();}else{__cov_XXJ1k8LcGyiJb$amn$bW9A.b['9'][1]++;}__cov_XXJ1k8LcGyiJb$amn$bW9A.s['47']++;if(downcandle){__cov_XXJ1k8LcGyiJb$amn$bW9A.b['10'][0]++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['48']++;downcandle.destroy();}else{__cov_XXJ1k8LcGyiJb$amn$bW9A.b['10'][1]++;}__cov_XXJ1k8LcGyiJb$amn$bW9A.s['49']++;if(wick){__cov_XXJ1k8LcGyiJb$amn$bW9A.b['11'][0]++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['50']++;wick.destroy();}else{__cov_XXJ1k8LcGyiJb$amn$bW9A.b['11'][1]++;}},_getDefaultStyles:function(){__cov_XXJ1k8LcGyiJb$amn$bW9A.f['7']++;__cov_XXJ1k8LcGyiJb$amn$bW9A.s['51']++;var styles={upcandle:{shapeRendering:'crispEdges',fill:{color:'#00aa00',alpha:1},stroke:{color:'#000000',alpha:1,weight:0}},downcandle:{shapeRendering:'crispEdges',fill:{color:'#aa0000',alpha:1},stroke:{color:'#000000',alpha:1,weight:0}},wick:{shapeRendering:'crispEdges',width:1,fill:{color:'#000000',alpha:1},stroke:{color:'#000000',alpha:1,weight:0}}};__cov_XXJ1k8LcGyiJb$amn$bW9A.s['52']++;return this._mergeStyles(styles,CandlestickSeries.superclass._getDefaultStyles());}});__cov_XXJ1k8LcGyiJb$amn$bW9A.s['53']++;Y.CandlestickSeries=CandlestickSeries;},'patched-v3.19.2',{'requires':['series-range']});
