if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/widget-anim/widget-anim.js']) {
   __coverage__['build/widget-anim/widget-anim.js'] = {"path":"build/widget-anim/widget-anim.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":23},"end":{"line":1,"column":42}}},"2":{"name":"WidgetAnim","line":38,"loc":{"start":{"line":38,"column":0},"end":{"line":38,"column":28}}},"3":{"name":"(anonymous_3)","line":75,"loc":{"start":{"line":75,"column":13},"end":{"line":75,"column":24}}},"4":{"name":"(anonymous_4)","line":93,"loc":{"start":{"line":93,"column":25},"end":{"line":93,"column":36}}},"5":{"name":"(anonymous_5)","line":100,"loc":{"start":{"line":100,"column":14},"end":{"line":100,"column":25}}},"6":{"name":"(anonymous_6)","line":162,"loc":{"start":{"line":162,"column":18},"end":{"line":162,"column":35}}},"7":{"name":"(anonymous_7)","line":179,"loc":{"start":{"line":179,"column":17},"end":{"line":179,"column":28}}},"8":{"name":"(anonymous_8)","line":196,"loc":{"start":{"line":196,"column":24},"end":{"line":196,"column":38}}},"9":{"name":"(anonymous_9)","line":218,"loc":{"start":{"line":218,"column":20},"end":{"line":218,"column":34}}},"10":{"name":"(anonymous_10)","line":231,"loc":{"start":{"line":231,"column":20},"end":{"line":231,"column":31}}},"11":{"name":"(anonymous_11)","line":234,"loc":{"start":{"line":234,"column":19},"end":{"line":234,"column":30}}},"12":{"name":"(anonymous_12)","line":245,"loc":{"start":{"line":245,"column":20},"end":{"line":245,"column":31}}},"13":{"name":"(anonymous_13)","line":248,"loc":{"start":{"line":248,"column":19},"end":{"line":248,"column":30}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":257,"column":65}},"2":{"start":{"line":8,"column":0},"end":{"line":29,"column":40}},"3":{"start":{"line":38,"column":0},"end":{"line":40,"column":1}},"4":{"start":{"line":39,"column":4},"end":{"line":39,"column":61}},"5":{"start":{"line":51,"column":0},"end":{"line":51,"column":23}},"6":{"start":{"line":62,"column":0},"end":{"line":62,"column":37}},"7":{"start":{"line":73,"column":0},"end":{"line":107,"column":2}},"8":{"start":{"line":77,"column":8},"end":{"line":84,"column":15}},"9":{"start":{"line":87,"column":8},"end":{"line":89,"column":9}},"10":{"start":{"line":88,"column":12},"end":{"line":88,"column":45}},"11":{"start":{"line":93,"column":8},"end":{"line":95,"column":11}},"12":{"start":{"line":94,"column":12},"end":{"line":94,"column":72}},"13":{"start":{"line":97,"column":8},"end":{"line":97,"column":20}},"14":{"start":{"line":101,"column":8},"end":{"line":105,"column":11}},"15":{"start":{"line":117,"column":0},"end":{"line":151,"column":2}},"16":{"start":{"line":153,"column":0},"end":{"line":252,"column":3}},"17":{"start":{"line":163,"column":8},"end":{"line":163,"column":29}},"18":{"start":{"line":164,"column":8},"end":{"line":164,"column":29}},"19":{"start":{"line":166,"column":8},"end":{"line":166,"column":57}},"20":{"start":{"line":167,"column":8},"end":{"line":167,"column":57}},"21":{"start":{"line":170,"column":8},"end":{"line":170,"column":71}},"22":{"start":{"line":180,"column":8},"end":{"line":180,"column":38}},"23":{"start":{"line":181,"column":8},"end":{"line":181,"column":38}},"24":{"start":{"line":197,"column":8},"end":{"line":206,"column":9}},"25":{"start":{"line":198,"column":12},"end":{"line":204,"column":13}},"26":{"start":{"line":199,"column":16},"end":{"line":199,"column":43}},"27":{"start":{"line":200,"column":16},"end":{"line":200,"column":42}},"28":{"start":{"line":202,"column":16},"end":{"line":202,"column":43}},"29":{"start":{"line":203,"column":16},"end":{"line":203,"column":42}},"30":{"start":{"line":205,"column":12},"end":{"line":205,"column":38}},"31":{"start":{"line":219,"column":8},"end":{"line":220,"column":52}},"32":{"start":{"line":222,"column":8},"end":{"line":222,"column":62}},"33":{"start":{"line":233,"column":8},"end":{"line":236,"column":22}},"34":{"start":{"line":235,"column":16},"end":{"line":235,"column":41}},"35":{"start":{"line":247,"column":8},"end":{"line":250,"column":22}},"36":{"start":{"line":249,"column":16},"end":{"line":249,"column":42}},"37":{"start":{"line":254,"column":0},"end":{"line":254,"column":46}}},"branchMap":{"1":{"line":87,"type":"if","locations":[{"start":{"line":87,"column":8},"end":{"line":87,"column":8}},{"start":{"line":87,"column":8},"end":{"line":87,"column":8}}]},"2":{"line":94,"type":"cond-expr","locations":[{"start":{"line":94,"column":57},"end":{"line":94,"column":58}},{"start":{"line":94,"column":61},"end":{"line":94,"column":70}}]},"3":{"line":197,"type":"if","locations":[{"start":{"line":197,"column":8},"end":{"line":197,"column":8}},{"start":{"line":197,"column":8},"end":{"line":197,"column":8}}]},"4":{"line":198,"type":"if","locations":[{"start":{"line":198,"column":12},"end":{"line":198,"column":12}},{"start":{"line":198,"column":12},"end":{"line":198,"column":12}}]}},"code":["(function () { YUI.add('widget-anim', function (Y, NAME) {","","/**"," * Provides a plugin which can be used to animate widget visibility changes."," *"," * @module widget-anim"," */","var BOUNDING_BOX = \"boundingBox\",","    HOST = \"host\",","    NODE = \"node\",","    OPACITY = \"opacity\",","    EMPTY_STR = \"\",","    VISIBLE = \"visible\",","    DESTROY = \"destroy\",","    HIDDEN = \"hidden\",","","    RENDERED = \"rendered\",","","    START = \"start\",","    END = \"end\",","","    DURATION = \"duration\",","    ANIM_SHOW = \"animShow\",","    ANIM_HIDE = \"animHide\",","","    _UI_SET_VISIBLE = \"_uiSetVisible\",","","    ANIM_SHOW_CHANGE = \"animShowChange\",","    ANIM_HIDE_CHANGE = \"animHideChange\";","","/**"," * A plugin class which can be used to animate widget visibility changes."," *"," * @class WidgetAnim"," * @extends Plugin.Base"," * @namespace Plugin"," */","function WidgetAnim(config) {","    WidgetAnim.superclass.constructor.apply(this, arguments);","}","","/**"," * The namespace for the plugin. This will be the property on the widget, which will"," * reference the plugin instance, when it's plugged in."," *"," * @property NS"," * @static"," * @type String"," * @default \"anim\""," */","WidgetAnim.NS = \"anim\";","","/**"," * The NAME of the WidgetAnim class. Used to prefix events generated"," * by the plugin class."," *"," * @property NAME"," * @static"," * @type String"," * @default \"pluginWidgetAnim\""," */","WidgetAnim.NAME = \"pluginWidgetAnim\";","","/**"," * Pre-Packaged Animation implementations, which can be used for animShow and animHide attribute"," * values."," *"," * @property ANIMATIONS"," * @static"," * @type Object"," * @default \"pluginWidgetAnim\""," */","WidgetAnim.ANIMATIONS = {","","    fadeIn : function() {","","        var widget = this.get(HOST),","            boundingBox = widget.get(BOUNDING_BOX),","","            anim = new Y.Anim({","                node: boundingBox,","                to: { opacity: 1 },","                duration: this.get(DURATION)","            });","","        // Set initial opacity, to avoid initial flicker","        if (!widget.get(VISIBLE)) {","            boundingBox.setStyle(OPACITY, 0);","        }","","        // Clean up, on destroy. Where supported, remove","        // opacity set using style. Else make 100% opaque","        anim.on(DESTROY, function() {","            this.get(NODE).setStyle(OPACITY, (Y.UA.ie) ? 1 : EMPTY_STR);","        });","","        return anim;","    },","","    fadeOut : function() {","        return new Y.Anim({","            node: this.get(HOST).get(BOUNDING_BOX),","            to: { opacity: 0 },","            duration: this.get(DURATION)","        });","    }","};","","/**"," * Static property used to define the default attribute"," * configuration for the plugin."," *"," * @property ATTRS"," * @type Object"," * @static"," */","WidgetAnim.ATTRS = {","","    /**","     * Default duration in seconds. Used as the default duration for the default animation implementations","     *","     * @attribute duration","     * @type Number","     * @default 0.2 (seconds","     */","    duration : {","        value: 0.2","    },","","    /**","     * Default animation instance used for showing the widget (opacity fade-in)","     *","     * @attribute animShow","     * @type Anim","     * @default WidgetAnim.ANIMATIONS.fadeIn","     */","    animShow : {","        valueFn: WidgetAnim.ANIMATIONS.fadeIn","    },","","    /**","     * Default animation instance used for hiding the widget (opacity fade-out)","     *","     * @attribute animHide","     * @type Anim","     * @default WidgetAnim.ANIMATIONS.fadeOut","     */","    animHide : {","        valueFn: WidgetAnim.ANIMATIONS.fadeOut","    }","};","","Y.extend(WidgetAnim, Y.Plugin.Base, {","","    /**","     * The initializer lifecycle implementation. Modifies the host widget's","     * visibililty implementation to add animation.","     *","     * @method initializer","     * @param {Object} config The user configuration for the plugin","     */","    initializer : function(config) {","        this._bindAnimShow();","        this._bindAnimHide();","","        this.after(ANIM_SHOW_CHANGE, this._bindAnimShow);","        this.after(ANIM_HIDE_CHANGE, this._bindAnimHide);","","        // Override default _uiSetVisible method, with custom animated method","        this.beforeHostMethod(_UI_SET_VISIBLE, this._uiAnimSetVisible);","    },","","    /**","     * The initializer destructor implementation. Responsible for destroying the configured","     * animation instances.","     *","     * @method destructor","     */","    destructor : function() {","        this.get(ANIM_SHOW).destroy();","        this.get(ANIM_HIDE).destroy();","    },","","    /**","     * The injected method used to override the host widget's _uiSetVisible implementation with","     * an animated version of the same.","     *","     * <p>This method replaces the default _uiSetVisible handler","     * Widget provides, by injecting itself before _uiSetVisible,","     * and preventing the default behavior. </p>","     *","     * @method _uiAnimSetVisible","     * @protected","     * @param {boolean} val true, if making the widget visible. false, if hiding it.","     */","    _uiAnimSetVisible : function(val) {","        if (this.get(HOST).get(RENDERED)) {","            if (val) {","                this.get(ANIM_HIDE).stop();","                this.get(ANIM_SHOW).run();","            } else {","                this.get(ANIM_SHOW).stop();","                this.get(ANIM_HIDE).run();","            }","            return new Y.Do.Prevent();","        }","    },","","    /**","     * The original Widget _uiSetVisible implementation. This currently needs to be replicated,","     * so it can be invoked before or after the animation starts or stops, since the original","     * methods is not available to the AOP implementation.","     *","     * @method _uiSetVisible","     * @param {boolean} val true, if making the widget visible. false, if hiding it.","     * @private","     */","    _uiSetVisible : function(val) {","        var host = this.get(HOST),","            hiddenClass = host.getClassName(HIDDEN);","","        host.get(BOUNDING_BOX).toggleClass(hiddenClass, !val);","    },","","    /**","     * Binds a listener to invoke the original visibility handling when the animShow animation is started","     *","     * @method _bindAnimShow","     * @private","     */","    _bindAnimShow : function() {","        // Setup original visibility handling (for show) before starting to animate","        this.get(ANIM_SHOW).on(START,","            Y.bind(function() {","                this._uiSetVisible(true);","            }, this));","    },","","    /**","     * Binds a listener to invoke the original visibility handling when the animHide animation is complete","     *","     * @method _bindAnimHide","     * @private","     */","    _bindAnimHide : function() {","        // Setup original visibility handling (for hide) after completing animation","        this.get(ANIM_HIDE).after(END,","            Y.bind(function() {","                this._uiSetVisible(false);","            }, this));","    }","});","","Y.namespace(\"Plugin\").WidgetAnim = WidgetAnim;","","","}, 'patched-v3.19.2', {\"requires\": [\"anim-base\", \"plugin\", \"widget\"]});","","}());"]};
}
var __cov_DMnV4JHDl$AJggF5ZOVL4A = __coverage__['build/widget-anim/widget-anim.js'];
__cov_DMnV4JHDl$AJggF5ZOVL4A.s['1']++;YUI.add('widget-anim',function(Y,NAME){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['1']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['2']++;var BOUNDING_BOX='boundingBox',HOST='host',NODE='node',OPACITY='opacity',EMPTY_STR='',VISIBLE='visible',DESTROY='destroy',HIDDEN='hidden',RENDERED='rendered',START='start',END='end',DURATION='duration',ANIM_SHOW='animShow',ANIM_HIDE='animHide',_UI_SET_VISIBLE='_uiSetVisible',ANIM_SHOW_CHANGE='animShowChange',ANIM_HIDE_CHANGE='animHideChange';__cov_DMnV4JHDl$AJggF5ZOVL4A.s['3']++;function WidgetAnim(config){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['2']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['4']++;WidgetAnim.superclass.constructor.apply(this,arguments);}__cov_DMnV4JHDl$AJggF5ZOVL4A.s['5']++;WidgetAnim.NS='anim';__cov_DMnV4JHDl$AJggF5ZOVL4A.s['6']++;WidgetAnim.NAME='pluginWidgetAnim';__cov_DMnV4JHDl$AJggF5ZOVL4A.s['7']++;WidgetAnim.ANIMATIONS={fadeIn:function(){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['3']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['8']++;var widget=this.get(HOST),boundingBox=widget.get(BOUNDING_BOX),anim=new Y.Anim({node:boundingBox,to:{opacity:1},duration:this.get(DURATION)});__cov_DMnV4JHDl$AJggF5ZOVL4A.s['9']++;if(!widget.get(VISIBLE)){__cov_DMnV4JHDl$AJggF5ZOVL4A.b['1'][0]++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['10']++;boundingBox.setStyle(OPACITY,0);}else{__cov_DMnV4JHDl$AJggF5ZOVL4A.b['1'][1]++;}__cov_DMnV4JHDl$AJggF5ZOVL4A.s['11']++;anim.on(DESTROY,function(){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['4']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['12']++;this.get(NODE).setStyle(OPACITY,Y.UA.ie?(__cov_DMnV4JHDl$AJggF5ZOVL4A.b['2'][0]++,1):(__cov_DMnV4JHDl$AJggF5ZOVL4A.b['2'][1]++,EMPTY_STR));});__cov_DMnV4JHDl$AJggF5ZOVL4A.s['13']++;return anim;},fadeOut:function(){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['5']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['14']++;return new Y.Anim({node:this.get(HOST).get(BOUNDING_BOX),to:{opacity:0},duration:this.get(DURATION)});}};__cov_DMnV4JHDl$AJggF5ZOVL4A.s['15']++;WidgetAnim.ATTRS={duration:{value:0.2},animShow:{valueFn:WidgetAnim.ANIMATIONS.fadeIn},animHide:{valueFn:WidgetAnim.ANIMATIONS.fadeOut}};__cov_DMnV4JHDl$AJggF5ZOVL4A.s['16']++;Y.extend(WidgetAnim,Y.Plugin.Base,{initializer:function(config){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['6']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['17']++;this._bindAnimShow();__cov_DMnV4JHDl$AJggF5ZOVL4A.s['18']++;this._bindAnimHide();__cov_DMnV4JHDl$AJggF5ZOVL4A.s['19']++;this.after(ANIM_SHOW_CHANGE,this._bindAnimShow);__cov_DMnV4JHDl$AJggF5ZOVL4A.s['20']++;this.after(ANIM_HIDE_CHANGE,this._bindAnimHide);__cov_DMnV4JHDl$AJggF5ZOVL4A.s['21']++;this.beforeHostMethod(_UI_SET_VISIBLE,this._uiAnimSetVisible);},destructor:function(){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['7']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['22']++;this.get(ANIM_SHOW).destroy();__cov_DMnV4JHDl$AJggF5ZOVL4A.s['23']++;this.get(ANIM_HIDE).destroy();},_uiAnimSetVisible:function(val){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['8']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['24']++;if(this.get(HOST).get(RENDERED)){__cov_DMnV4JHDl$AJggF5ZOVL4A.b['3'][0]++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['25']++;if(val){__cov_DMnV4JHDl$AJggF5ZOVL4A.b['4'][0]++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['26']++;this.get(ANIM_HIDE).stop();__cov_DMnV4JHDl$AJggF5ZOVL4A.s['27']++;this.get(ANIM_SHOW).run();}else{__cov_DMnV4JHDl$AJggF5ZOVL4A.b['4'][1]++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['28']++;this.get(ANIM_SHOW).stop();__cov_DMnV4JHDl$AJggF5ZOVL4A.s['29']++;this.get(ANIM_HIDE).run();}__cov_DMnV4JHDl$AJggF5ZOVL4A.s['30']++;return new Y.Do.Prevent();}else{__cov_DMnV4JHDl$AJggF5ZOVL4A.b['3'][1]++;}},_uiSetVisible:function(val){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['9']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['31']++;var host=this.get(HOST),hiddenClass=host.getClassName(HIDDEN);__cov_DMnV4JHDl$AJggF5ZOVL4A.s['32']++;host.get(BOUNDING_BOX).toggleClass(hiddenClass,!val);},_bindAnimShow:function(){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['10']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['33']++;this.get(ANIM_SHOW).on(START,Y.bind(function(){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['11']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['34']++;this._uiSetVisible(true);},this));},_bindAnimHide:function(){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['12']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['35']++;this.get(ANIM_HIDE).after(END,Y.bind(function(){__cov_DMnV4JHDl$AJggF5ZOVL4A.f['13']++;__cov_DMnV4JHDl$AJggF5ZOVL4A.s['36']++;this._uiSetVisible(false);},this));}});__cov_DMnV4JHDl$AJggF5ZOVL4A.s['37']++;Y.namespace('Plugin').WidgetAnim=WidgetAnim;},'patched-v3.19.2',{'requires':['anim-base','plugin','widget']});
