'use strict';

Liferay.Loader.define('frontend-js-metal-web$metal-jsx@2.16.8/src/DangerouslySetHTML', ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	var global = window;
	{
		import Component from './JSXComponent';
		import { Config } from 'metal-state';

		/**
   * JSXComponent that renders html passed in.
   * @class
   */
		class DangerouslySetHTML extends Component {
			/**
    * @return {Component}
    */
			render() {
				const { content, tag } = this.props;

				IncrementalDOM.elementOpen(tag, null, null);

				const node = IncrementalDOM.elementClose(tag);

				node.innerHTML = content;

				return node;
			}
		}

		DangerouslySetHTML.PROPS = {
			content: Config.string(),
			tag: Config.string().value('span')
		};

		export default DangerouslySetHTML;
	}
});
//# sourceMappingURL=DangerouslySetHTML.js.map