/*
 * Decompiled with CFR 0.152.
 */
package com.frontend.js.minifier;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.SourceFile;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.minifier.JavaScriptMinifier;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.ranking:Integer=100"}, service={JavaScriptMinifier.class})
public class GoogleJavaScriptMinifier
implements JavaScriptMinifier {
    private static final Log _log = LogFactoryUtil.getLog(GoogleJavaScriptMinifier.class);
    private static final Set<String> _ignoredErrors = new HashSet<String>(Arrays.asList("JSC_BAD_JSDOC_ANNOTATION", "JSC_DUPLICATE_OBJECT_KEY", "JSC_GOOG_MODULE_IN_NON_MODULE", "JSC_INVALID_PARAM", "JSC_JSDOC_IN_BLOCK_COMMENT", "JSC_JSDOC_MISSING_BRACES_WARNING", "JSC_MISPLACED_ANNOTATION"));
    private Method _clearThreadTraceMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compress(String resourceName, String content) {
        try {
            Compiler compiler = new Compiler((ErrorManager)new LogErrorManager(resourceName));
            compiler.disableThreads();
            SourceFile sourceFile = SourceFile.fromCode((String)resourceName, (String)content);
            CompilerOptions compilerOptions = new CompilerOptions();
            CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(compilerOptions);
            compilerOptions.setEmitUseStrict(false);
            compilerOptions.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_NEXT);
            compiler.compile(SourceFile.fromCode((String)"extern", (String)""), sourceFile, compilerOptions);
            if (compiler.hasErrors()) {
                String string = content;
                return string;
            }
            String string = compiler.toSource();
            return string;
        }
        finally {
            block12: {
                if (this._clearThreadTraceMethod != null) {
                    try {
                        this._clearThreadTraceMethod.invoke(null, new Object[0]);
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        if (!_log.isWarnEnabled()) break block12;
                        _log.warn((Object)"Unable to clear thread local for ThreadTrace", (Throwable)reflectiveOperationException);
                    }
                }
            }
        }
    }

    @Activate
    protected void activate() {
        block2: {
            try {
                ClassLoader classLoader = Compiler.class.getClassLoader();
                this._clearThreadTraceMethod = ReflectionUtil.getDeclaredMethod(classLoader.loadClass("com.google.javascript.jscomp.Tracer"), (String)"clearThreadTrace", (Class[])new Class[0]);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to find clear ThreadTrace method", (Throwable)exception);
            }
        }
    }

    private class LogErrorManager
    extends BasicErrorManager {
        private int _ignoredErrorCount;
        private int _ignoredWarningCount;
        private final String _resourceName;
        private final MessageFormatter _simpleMessageFormatter = new SimpleMessageFormatter();

        public LogErrorManager(String resourceName) {
            this._resourceName = resourceName;
        }

        public void println(CheckLevel checkLevel, JSError jsError) {
            DiagnosticType diagnosticType = jsError.getType();
            if (_ignoredErrors.contains(diagnosticType.key)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)jsError.format(checkLevel, this._simpleMessageFormatter));
                }
                if (checkLevel == CheckLevel.ERROR) {
                    ++this._ignoredErrorCount;
                } else if (checkLevel == CheckLevel.WARNING) {
                    ++this._ignoredWarningCount;
                }
            } else if (checkLevel == CheckLevel.ERROR) {
                _log.error((Object)jsError.format(checkLevel, this._simpleMessageFormatter));
            } else if (checkLevel == CheckLevel.WARNING && _log.isWarnEnabled()) {
                _log.warn((Object)jsError.format(checkLevel, this._simpleMessageFormatter));
            }
        }

        protected void printSummary() {
            int errorCount = this.getErrorCount() - this._ignoredErrorCount;
            int warningCount = this.getWarningCount() - this._ignoredWarningCount;
            if (errorCount > 0) {
                _log.error((Object)this._buildMessage(errorCount, warningCount));
            } else if (_log.isWarnEnabled() && warningCount > 0) {
                _log.warn((Object)this._buildMessage(errorCount, warningCount));
            }
        }

        private String _buildMessage(int errorCount, int warningCount) {
            return String.format("(%s): %d error(s), %d warning(s)", this._resourceName, errorCount, warningCount);
        }
    }

    private static class SimpleMessageFormatter
    implements MessageFormatter {
        private SimpleMessageFormatter() {
        }

        public String formatError(JSError jsError) {
            DiagnosticType diagnosticType = jsError.getType();
            return String.format("(%s:%d): %s [%s]", jsError.sourceName, jsError.lineNumber, jsError.description, diagnosticType.key);
        }

        public String formatWarning(JSError jsError) {
            return this.formatError(jsError);
        }
    }
}

