/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.spa.web.internal.servlet.taglib.util;

import com.liferay.frontend.js.spa.web.configuration.SPAConfiguration;
import com.liferay.frontend.js.spa.web.configuration.SPAConfigurationActivator;
import com.liferay.frontend.js.spa.web.configuration.SPAConfigurationUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.servlet.ServletResponseConstants;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={SPAUtil.class})
public class SPAUtil {
    private static final String _VALID_STATUS_CODES;
    private static final String _redirectParamName;
    private static final String _spaExcludedPaths;
    private PortletLocalService _portletLocalService;
    private SPAConfigurationActivator _spaConfigurationActivator;

    public long getCacheExpirationTime(long companyId) {
        long cacheExpirationTime = 0L;
        SPAConfiguration spaConfiguration = this._spaConfigurationActivator.getSPAConfiguration();
        cacheExpirationTime = GetterUtil.getLong((String)spaConfiguration.cacheExpirationTime(), (long)cacheExpirationTime);
        if (cacheExpirationTime > 0L) {
            cacheExpirationTime *= 60000L;
        }
        return cacheExpirationTime;
    }

    public String getExcludedPaths() {
        return _spaExcludedPaths;
    }

    public ResourceBundle getLanguageResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
    }

    public String getLoginRedirect(HttpServletRequest request) {
        return ParamUtil.getString((HttpServletRequest)request, (String)_redirectParamName);
    }

    public String getPortletsBlacklist(ThemeDisplay themeDisplay) {
        StringBundler sb = new StringBundler();
        sb.append("{");
        this._portletLocalService.visitPortlets(themeDisplay.getCompanyId(), portlet -> {
            if (!portlet.isSinglePageApplication() && !portlet.isUndeployedPortlet() && portlet.isActive() && portlet.isReady()) {
                sb.append("\"");
                sb.append(portlet.getPortletId());
                sb.append("\":true,");
            }
        });
        if (sb.index() == 1) {
            sb.append("}");
        } else {
            sb.setIndex(sb.index() - 1);
            sb.append("\":true}");
        }
        return sb.toString();
    }

    public int getRequestTimeout() {
        int requestTimeout = 0;
        SPAConfiguration spaConfiguration = this._spaConfigurationActivator.getSPAConfiguration();
        requestTimeout = GetterUtil.getInteger((String)spaConfiguration.requestTimeout(), (int)requestTimeout);
        return requestTimeout;
    }

    public int getUserNotificationTimeout() {
        int userNotificationTimeout = 0;
        SPAConfiguration spaConfiguration = this._spaConfigurationActivator.getSPAConfiguration();
        userNotificationTimeout = GetterUtil.getInteger((String)spaConfiguration.userNotificationTimeout(), (int)userNotificationTimeout);
        return userNotificationTimeout;
    }

    public String getValidStatusCodes() {
        return _VALID_STATUS_CODES;
    }

    public boolean isClearScreensCache(HttpServletRequest request, HttpSession session) {
        boolean singlePageApplicationClearCache = GetterUtil.getBoolean((Object)request.getAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE"));
        if (singlePageApplicationClearCache) {
            return true;
        }
        String portletId = request.getParameter("p_p_id");
        if (Validator.isNull((String)portletId)) {
            return false;
        }
        String singlePageApplicationLastPortletId = (String)session.getAttribute("SINGLE_PAGE_APPLICATION_LAST_PORTLET_ID");
        return Validator.isNotNull((String)singlePageApplicationLastPortletId) && !Objects.equals(portletId, singlePageApplicationLastPortletId);
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSPAConfigurationActivator(SPAConfigurationActivator spaConfigurationActivator) {
        this._spaConfigurationActivator = spaConfigurationActivator;
    }

    protected void unsetSPAConfigurationActivator(SPAConfigurationActivator spaConfigurationActivator) {
        this._spaConfigurationActivator = null;
    }

    static {
        String[] excludedPaths;
        Class<ServletResponseConstants> clazz = ServletResponseConstants.class;
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                jsonArray.put(field.getInt(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        _VALID_STATUS_CODES = jsonArray.toJSONString();
        String portletNamespace = PortalUtil.getPortletNamespace((String)PropsUtil.get((String)"auth.login.portlet.name"));
        _redirectParamName = portletNamespace.concat("redirect");
        jsonArray = JSONFactoryUtil.createJSONArray();
        for (String excludedPath : excludedPaths = StringUtil.split((String)SPAConfigurationUtil.get("spa.excluded.paths"))) {
            jsonArray.put(PortalUtil.getPathContext() + excludedPath);
        }
        _spaExcludedPaths = jsonArray.toString();
    }
}

