Liferay.Loader.define("frontend-js-spa-web@1.0.34/liferay/app/App.es", ['exports', 'senna/src/app/App', 'metal/src/core', 'metal-dom/src/dom', '../surface/Surface.es', '../util/Utils.es', 'metal-promise/src/promise/Promise'], function (exports, _App2, _core, _dom, _Surface, _Utils, _Promise) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _App3 = _interopRequireDefault(_App2);

	var _core2 = _interopRequireDefault(_core);

	var _dom2 = _interopRequireDefault(_dom);

	var _Surface2 = _interopRequireDefault(_Surface);

	var _Utils2 = _interopRequireDefault(_Utils);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;
		var desc = Object.getOwnPropertyDescriptor(object, property);

		if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);

			if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;

			if (getter === undefined) {
				return undefined;
			}

			return getter.call(receiver);
		}
	};

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var LiferayApp = function (_App) {
		_inherits(LiferayApp, _App);

		function LiferayApp() {
			_classCallCheck(this, LiferayApp);

			var _this = _possibleConstructorReturn(this, (LiferayApp.__proto__ || Object.getPrototypeOf(LiferayApp)).call(this));

			_this.portletsBlacklist = {};
			_this.validStatusCodes = [];

			_this.timeout = Math.max(Liferay.SPA.requestTimeout, 0) || _Utils2.default.getMaxTimeout();
			_this.timeoutAlert = null;

			_this.setShouldUseFacade(true);

			var exceptionsSelector = ':not([target="_blank"]):not([data-senna-off]):not([data-resource-href])';

			_this.setFormSelector('form' + exceptionsSelector);
			_this.setLinkSelector('a' + exceptionsSelector);
			_this.setLoadingCssClass('lfr-spa-loading');

			_this.on('beforeNavigate', _this.onBeforeNavigate);
			_this.on('endNavigate', _this.onEndNavigate);
			_this.on('startNavigate', _this.onStartNavigate);

			Liferay.on('beforeScreenFlip', _Utils2.default.resetAllPortlets);
			Liferay.on('io:complete', _this.onLiferayIOComplete, _this);

			var body = document.body;

			if (!body.id) {
				body.id = 'senna_surface' + _core2.default.getUid();
			}

			_this.addSurfaces(new _Surface2.default(body.id));

			_dom2.default.append(body, '<div class="lfr-spa-loading-bar"></div>');
			return _this;
		}

		_createClass(LiferayApp, [{
			key: 'getCacheExpirationTime',
			value: function getCacheExpirationTime() {
				return Liferay.SPA.cacheExpirationTime;
			}
		}, {
			key: 'getValidStatusCodes',
			value: function getValidStatusCodes() {
				return this.validStatusCodes;
			}
		}, {
			key: 'isCacheEnabled',
			value: function isCacheEnabled() {
				return this.getCacheExpirationTime() > -1;
			}
		}, {
			key: 'isInPortletBlacklist',
			value: function isInPortletBlacklist(element) {
				return Object.keys(this.portletsBlacklist).some(function (portletId) {
					var boundaryId = _Utils2.default.getPortletBoundaryId(portletId);

					var portlets = document.querySelectorAll('[id^="' + boundaryId + '"]');

					return Array.prototype.slice.call(portlets).some(function (portlet) {
						return _dom2.default.contains(portlet, element);
					});
				});
			}
		}, {
			key: 'isScreenCacheExpired',
			value: function isScreenCacheExpired(screen) {
				if (this.getCacheExpirationTime() === 0) {
					return false;
				}

				var lastModifiedInterval = new Date().getTime() - screen.getCacheLastModified();

				return lastModifiedInterval > this.getCacheExpirationTime();
			}
		}, {
			key: 'onBeforeNavigate',
			value: function onBeforeNavigate(data, event) {
				if (Liferay.SPA.clearScreensCache || data.form) {
					this.clearScreensCache();
				}

				Liferay.fire('beforeNavigate', {
					app: this,
					originalEvent: event,
					path: data.path
				});
			}
		}, {
			key: 'onDocClickDelegate_',
			value: function onDocClickDelegate_(event) {
				if (this.isInPortletBlacklist(event.delegateTarget)) {
					return;
				}

				_get(LiferayApp.prototype.__proto__ || Object.getPrototypeOf(LiferayApp.prototype), 'onDocClickDelegate_', this).call(this, event);
			}
		}, {
			key: 'onDocSubmitDelegate_',
			value: function onDocSubmitDelegate_(event) {
				if (this.isInPortletBlacklist(event.delegateTarget)) {
					return;
				}

				_get(LiferayApp.prototype.__proto__ || Object.getPrototypeOf(LiferayApp.prototype), 'onDocSubmitDelegate_', this).call(this, event);
			}
		}, {
			key: 'onEndNavigate',
			value: function onEndNavigate(event) {
				Liferay.fire('endNavigate', {
					app: this,
					error: event.error,
					path: event.path
				});

				if (!this.pendingNavigate) {
					this._clearRequestTimer();
					this._hideTimeoutAlert();
				}

				if (event.error) {
					if (event.error.invalidStatus || event.error.requestError || event.error.timeout) {
						this._createNotification({
							message: Liferay.Language.get('there-was-an-unexpected-error.-please-refresh-the-current-page'),
							title: Liferay.Language.get('error'),
							type: 'danger'
						});
					}
				} else if (Liferay.Layout && Liferay.Data.layoutConfig) {
					Liferay.Layout.init();
				}

				AUI().Get._insertCache = {};

				Liferay.DOMTaskRunner.reset();
			}
		}, {
			key: 'onLiferayIOComplete',
			value: function onLiferayIOComplete() {
				this.clearScreensCache();
			}
		}, {
			key: 'onStartNavigate',
			value: function onStartNavigate(event) {
				Liferay.fire('startNavigate', {
					app: this,
					path: event.path
				});

				this._startRequestTimer(event.path);
			}
		}, {
			key: 'setPortletsBlacklist',
			value: function setPortletsBlacklist(portletsBlacklist) {
				this.portletsBlacklist = portletsBlacklist;
			}
		}, {
			key: 'setValidStatusCodes',
			value: function setValidStatusCodes(validStatusCodes) {
				this.validStatusCodes = validStatusCodes;
			}
		}, {
			key: '_clearRequestTimer',
			value: function _clearRequestTimer() {
				if (this.requestTimer) {
					clearTimeout(this.requestTimer);
				}
			}
		}, {
			key: '_createNotification',
			value: function _createNotification(config) {
				return new _Promise.CancellablePromise(function (resolve) {
					AUI().use('liferay-notification', function () {
						resolve(new Liferay.Notification(Object.assign({
							closeable: true,
							delay: {
								hide: 0,
								show: 0
							},
							duration: 500,
							type: 'warning'
						}, config)).render('body'));
					});
				});
			}
		}, {
			key: '_hideTimeoutAlert',
			value: function _hideTimeoutAlert() {
				if (this.timeoutAlert) {
					this.timeoutAlert.hide();
				}
			}
		}, {
			key: '_startRequestTimer',
			value: function _startRequestTimer(path) {
				var _this2 = this;

				this._clearRequestTimer();

				if (Liferay.SPA.userNotification.timeout > 0) {
					this.requestTimer = setTimeout(function () {
						Liferay.fire('spaRequestTimeout', {
							path: path
						});

						if (!_this2.timeoutAlert) {
							_this2._createNotification({
								message: Liferay.SPA.userNotification.message,
								title: Liferay.SPA.userNotification.title,
								type: 'warning'
							}).then(function (alert) {
								_this2.timeoutAlert = alert;
							});
						} else {
							_this2.timeoutAlert.show();
						}
					}, Liferay.SPA.userNotification.timeout);
				}
			}
		}]);

		return LiferayApp;
	}(_App3.default);

	exports.default = LiferayApp;
});
//# sourceMappingURL=App.es.js.map
