Liferay.Loader.define("frontend-js-spa-web@1.0.34/liferay/screen/EventScreen.es", ['exports', 'senna/src/screen/HtmlScreen', 'senna/src/globals/globals', 'metal-promise/src/promise/Promise', '../util/Utils.es'], function (exports, _HtmlScreen2, _globals, _Promise, _Utils) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _HtmlScreen3 = _interopRequireDefault(_HtmlScreen2);

	var _globals2 = _interopRequireDefault(_globals);

	var _Utils2 = _interopRequireDefault(_Utils);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;
		var desc = Object.getOwnPropertyDescriptor(object, property);

		if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);

			if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;

			if (getter === undefined) {
				return undefined;
			}

			return getter.call(receiver);
		}
	};

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var EventScreen = function (_HtmlScreen) {
		_inherits(EventScreen, _HtmlScreen);

		function EventScreen() {
			_classCallCheck(this, EventScreen);

			var _this = _possibleConstructorReturn(this, (EventScreen.__proto__ || Object.getPrototypeOf(EventScreen)).call(this));

			_this.cacheable = false;
			return _this;
		}

		_createClass(EventScreen, [{
			key: 'dispose',
			value: function dispose() {
				_get(EventScreen.prototype.__proto__ || Object.getPrototypeOf(EventScreen.prototype), 'dispose', this).call(this);

				Liferay.fire('screenDispose', {
					app: Liferay.SPA.app,
					screen: this
				});
			}
		}, {
			key: 'activate',
			value: function activate() {
				_get(EventScreen.prototype.__proto__ || Object.getPrototypeOf(EventScreen.prototype), 'activate', this).call(this);

				Liferay.fire('screenActivate', {
					app: Liferay.SPA.app,
					screen: this
				});
			}
		}, {
			key: 'addCache',
			value: function addCache(content) {
				_get(EventScreen.prototype.__proto__ || Object.getPrototypeOf(EventScreen.prototype), 'addCache', this).call(this, content);

				this.cacheLastModified = new Date().getTime();
			}
		}, {
			key: 'checkRedirectPath',
			value: function checkRedirectPath(redirectPath) {
				var app = Liferay.SPA.app;

				if (!_globals2.default.capturedFormElement && !app.findRoute(redirectPath)) {
					window.location.href = redirectPath;
				}
			}
		}, {
			key: 'deactivate',
			value: function deactivate() {
				_get(EventScreen.prototype.__proto__ || Object.getPrototypeOf(EventScreen.prototype), 'deactivate', this).call(this);

				Liferay.fire('screenDeactivate', {
					app: Liferay.SPA.app,
					screen: this
				});
			}
		}, {
			key: 'beforeScreenFlip',
			value: function beforeScreenFlip() {
				Liferay.fire('beforeScreenFlip', {
					app: Liferay.SPA.app,
					screen: this
				});
			}
		}, {
			key: 'copyBodyAttributes',
			value: function copyBodyAttributes() {
				var virtualBody = this.virtualDocument.querySelector('body');

				document.body.className = virtualBody.className;
				document.body.onload = virtualBody.onload;
			}
		}, {
			key: 'flip',
			value: function flip(surfaces) {
				var _this2 = this;

				this.copyBodyAttributes();

				return _Promise.CancellablePromise.resolve(_Utils2.default.resetAllPortlets()).then(_Promise.CancellablePromise.resolve(this.beforeScreenFlip())).then(_get(EventScreen.prototype.__proto__ || Object.getPrototypeOf(EventScreen.prototype), 'flip', this).call(this, surfaces)).then(function () {
					_this2.runBodyOnLoad();

					Liferay.fire('screenFlip', {
						app: Liferay.SPA.app,
						screen: _this2
					});
				});
			}
		}, {
			key: 'getCache',
			value: function getCache() {
				var app = Liferay.SPA.app;

				if (app.isCacheEnabled() && !app.isScreenCacheExpired(this)) {
					return _get(EventScreen.prototype.__proto__ || Object.getPrototypeOf(EventScreen.prototype), 'getCache', this).call(this);
				}

				return null;
			}
		}, {
			key: 'getCacheLastModified',
			value: function getCacheLastModified() {
				return this.cacheLastModified;
			}
		}, {
			key: 'isValidResponseStatusCode',
			value: function isValidResponseStatusCode(statusCode) {
				var validStatusCodes = Liferay.SPA.app.getValidStatusCodes();

				return statusCode >= 200 && statusCode <= 500 || validStatusCodes.indexOf(statusCode) > -1;
			}
		}, {
			key: 'load',
			value: function load(path) {
				var _this3 = this;

				return _get(EventScreen.prototype.__proto__ || Object.getPrototypeOf(EventScreen.prototype), 'load', this).call(this, path).then(function (content) {
					var redirectPath = _this3.beforeUpdateHistoryPath(path);

					_this3.checkRedirectPath(redirectPath);

					Liferay.fire('screenLoad', {
						app: Liferay.SPA.app,
						content: content,
						screen: _this3
					});

					return content;
				});
			}
		}, {
			key: 'runBodyOnLoad',
			value: function runBodyOnLoad() {
				var onLoad = document.body.onload;

				if (onLoad) {
					onLoad();
				}
			}
		}]);

		return EventScreen;
	}(_HtmlScreen3.default);

	exports.default = EventScreen;
});
//# sourceMappingURL=EventScreen.es.js.map
