Liferay.Loader.define("frontend-js-spa-web@1.0.34/liferay/util/Utils.es", ['exports'], function (exports) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	var MAX_TIMEOUT = Math.pow(2, 31) - 1;

	var Utils = function () {
		function Utils() {
			_classCallCheck(this, Utils);
		}

		_createClass(Utils, null, [{
			key: 'getMaxTimeout',
			value: function getMaxTimeout() {
				return MAX_TIMEOUT;
			}
		}, {
			key: 'getPortletBoundaryId',
			value: function getPortletBoundaryId(portletId) {
				return 'p_p_id_' + portletId + '_';
			}
		}, {
			key: 'getPortletBoundaryIds',
			value: function getPortletBoundaryIds(portletIds) {
				return portletIds.map(function (portletId) {
					return Utils.getPortletBoundaryId(portletId);
				});
			}
		}, {
			key: 'resetAllPortlets',
			value: function resetAllPortlets() {
				Utils.getPortletBoundaryIds(Liferay.Portlet.list).forEach(function (value, index, collection) {
					var portlet = document.querySelector('#' + value);

					if (portlet) {
						Liferay.Portlet.destroy(portlet);

						portlet.portletProcessed = false;
					}
				});

				Liferay.Portlet.readyCounter = 0;
			}
		}]);

		return Utils;
	}();

	exports.default = Utils;
});
//# sourceMappingURL=Utils.es.js.map
