'use strict';

Liferay.Loader.define("frontend-js-spa-web@2.0.28/liferay/init.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-uri/lib/Uri', 'frontend-js-metal-web$metal/lib/async/async', 'frontend-js-spa-web$senna/lib/globals/globals', 'frontend-js-spa-web$senna/lib/utils/utils', 'frontend-js-spa-web$senna/lib/app/version', 'frontend-js-metal-web$metal-dom', './screen/ActionURLScreen.es', './app/App.es', './screen/RenderURLScreen.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _Uri = _interopRequireDefault(require("frontend-js-metal-web$metal-uri/lib/Uri"));

  var _async = _interopRequireDefault(require("frontend-js-metal-web$metal/lib/async/async"));

  var _globals = _interopRequireDefault(require("frontend-js-spa-web$senna/lib/globals/globals"));

  var _utils = _interopRequireDefault(require("frontend-js-spa-web$senna/lib/utils/utils"));

  var _version = _interopRequireDefault(require("frontend-js-spa-web$senna/lib/app/version"));

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _ActionURLScreen = _interopRequireDefault(require("./screen/ActionURLScreen.es"));

  var _App = _interopRequireDefault(require("./app/App.es"));

  var _RenderURLScreen = _interopRequireDefault(require("./screen/RenderURLScreen.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Initializes a Senna App with routes that match both ActionURLs and RenderURLs.
   * It also overrides Liferay's default Liferay.Util.submitForm to makes sure
   * forms are properly submitted using SPA.
   * @return {!App} The Senna App initialized
   */
  var initSPA = function initSPA() {
    var app = new _App["default"]();
    app.addRoutes([{
      handler: _ActionURLScreen["default"],
      path: function path(url) {
        var match = false;
        var uri = new _Uri["default"](url);
        var loginRedirect = new _Uri["default"](Liferay.SPA.loginRedirect);
        var host = loginRedirect.getHost() || window.location.host;

        if (app.isLinkSameOrigin_(host)) {
          match = uri.getParameterValue('p_p_lifecycle') === '1';
        }

        return match;
      }
    }, {
      handler: _RenderURLScreen["default"],
      path: function path(url) {
        var match = false;

        if ((url + '/').indexOf(themeDisplay.getPathMain() + '/') !== 0) {
          var excluded = Liferay.SPA.excludedPaths.some(function (excludedPath) {
            return url.indexOf(excludedPath) === 0;
          });

          if (!excluded) {
            var uri = new _Uri["default"](url);
            var lifecycle = uri.getParameterValue('p_p_lifecycle');
            match = lifecycle === '0' || !lifecycle;
          }
        }

        return match;
      }
    }]);

    Liferay.Util.submitForm = function (form) {
      _async["default"].nextTick(function () {
        var formElement = form.getDOM();
        var formSelector = 'form' + Liferay.SPA.navigationExceptionSelectors;
        var url = formElement.action;

        if ((0, _metalDom.match)(formElement, formSelector) && app.canNavigate(url) && formElement.method !== 'get' && !app.isInPortletBlacklist(formElement)) {
          Liferay.Util._submitLocked = false;
          _globals["default"].capturedFormElement = formElement;
          var buttonSelector = 'button:not([type]),button[type=submit],input[type=submit]';

          if ((0, _metalDom.match)(_globals["default"].document.activeElement, buttonSelector)) {
            _globals["default"].capturedFormButtonElement = _globals["default"].document.activeElement;
          } else {
            _globals["default"].capturedFormButtonElement = form.one(buttonSelector);
          }

          app.navigate(_utils["default"].getUrlPath(url));
        } else {
          formElement.submit();
        }
      });
    };

    Liferay.SPA.app = app;
    Liferay.SPA.version = _version["default"];
    Liferay.fire('SPAReady');
    return app;
  };

  var _default = {
    init: function init(callback) {
      var _this = this;

      if (_globals["default"].document.readyState == 'loading') {
        _globals["default"].document.addEventListener('DOMContentLoaded', function () {
          callback.call(_this, initSPA());
        });
      } else {
        callback.call(this, initSPA());
      }
    }
  };
  exports["default"] = _default;
  //# sourceMappingURL=init.es.js.map
});
//# sourceMappingURL=init.es.js.map