/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.spa.web.internal.servlet.taglib.helper;

import com.liferay.frontend.js.spa.web.internal.configuration.SPAConfiguration;
import com.liferay.frontend.js.spa.web.internal.configuration.SPAConfigurationUtil;
import com.liferay.osgi.util.StringPlus;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.ServletResponseConstants;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.frontend.js.spa.web.internal.configuration.SPAConfiguration"}, service={SPAHelper.class})
public class SPAHelper {
    private static final String _REDIRECT_PARAM_NAME;
    private static final String _SPA_EXCLUDED_PATHS;
    private static final String _SPA_NAVIGATION_EXCEPTION_SELECTOR_KEY = "javascript.single.page.application.navigation.exception.selector";
    private static final String _VALID_STATUS_CODES;
    private static final Log _log;
    private static final List<String> _navigationExceptionSelectors;
    private static volatile String _navigationExceptionSelectorsString;
    private long _cacheExpirationTime;
    private ServiceTracker<Object, Object> _navigationExceptionSelectorTracker;
    private PortletLocalService _portletLocalService;
    private SPAConfiguration _spaConfiguration;

    public long getCacheExpirationTime(long companyId) {
        return this._cacheExpirationTime;
    }

    public String getExcludedPaths() {
        return _SPA_EXCLUDED_PATHS;
    }

    public ResourceBundle getLanguageResourceBundle(String servletContextName, Locale locale) {
        ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByServletContextName((String)servletContextName);
        return resourceBundleLoader.loadResourceBundle(locale);
    }

    public String getLoginRedirect(HttpServletRequest httpServletRequest) {
        return ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)_REDIRECT_PARAM_NAME);
    }

    public String getNavigationExceptionSelectors() {
        return _navigationExceptionSelectorsString;
    }

    public String getPortletsBlacklist(ThemeDisplay themeDisplay) {
        StringBundler sb = new StringBundler();
        sb.append("{");
        this._portletLocalService.visitPortlets(themeDisplay.getCompanyId(), portlet -> {
            if (!portlet.isSinglePageApplication() && !portlet.isUndeployedPortlet() && portlet.isActive() && portlet.isReady()) {
                sb.append("\"");
                sb.append(portlet.getPortletId());
                sb.append("\":true,");
            }
        });
        if (sb.index() == 1) {
            sb.append("}");
        } else {
            sb.setIndex(sb.index() - 1);
            sb.append("\":true}");
        }
        return sb.toString();
    }

    public int getRequestTimeout() {
        return this._spaConfiguration.requestTimeout();
    }

    public int getUserNotificationTimeout() {
        return this._spaConfiguration.userNotificationTimeout();
    }

    public String getValidStatusCodes() {
        return _VALID_STATUS_CODES;
    }

    public boolean isClearScreensCache(HttpServletRequest httpServletRequest, HttpSession session) {
        boolean singlePageApplicationClearCache = GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE"));
        if (singlePageApplicationClearCache) {
            return true;
        }
        String portletId = httpServletRequest.getParameter("p_p_id");
        if (Validator.isNull((String)portletId)) {
            return false;
        }
        String singlePageApplicationLastPortletId = (String)session.getAttribute("SINGLE_PAGE_APPLICATION_LAST_PORTLET_ID");
        return Validator.isNotNull((String)singlePageApplicationLastPortletId) && !Objects.equals(portletId, singlePageApplicationLastPortletId);
    }

    public boolean isDebugEnabled() {
        return _log.isDebugEnabled();
    }

    public boolean isDisabled(HttpServletRequest httpServletRequest) {
        if (BrowserSnifferUtil.isIe((HttpServletRequest)httpServletRequest)) {
            if (this._spaConfiguration.disableInInternetExplorer()) {
                return true;
            }
            double majorVersion = BrowserSnifferUtil.getMajorVersion((HttpServletRequest)httpServletRequest);
            if (majorVersion == 11.0) {
                return this._spaConfiguration.disableInInternetExplorer11();
            }
        }
        return false;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws InvalidSyntaxException {
        this._spaConfiguration = (SPAConfiguration)ConfigurableUtil.createConfigurable(SPAConfiguration.class, properties);
        this._cacheExpirationTime = this._getCacheExpirationTime(this._spaConfiguration);
        Collections.addAll(_navigationExceptionSelectors, this._spaConfiguration.navigationExceptionSelectors());
        _navigationExceptionSelectorsString = ListUtil.toString(_navigationExceptionSelectors, (String)null, (String)"");
        Filter filter = bundleContext.createFilter("(&(objectClass=java.lang.Object)(javascript.single.page.application.navigation.exception.selector=*))");
        this._navigationExceptionSelectorTracker = new ServiceTracker(bundleContext, filter, (ServiceTrackerCustomizer)new NavigationExceptionSelectorTrackerCustomizer(bundleContext));
        this._navigationExceptionSelectorTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._navigationExceptionSelectorTracker.close();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        _navigationExceptionSelectors.removeAll(Arrays.asList(this._spaConfiguration.navigationExceptionSelectors()));
        this._spaConfiguration = (SPAConfiguration)ConfigurableUtil.createConfigurable(SPAConfiguration.class, properties);
        this._cacheExpirationTime = this._getCacheExpirationTime(this._spaConfiguration);
        Collections.addAll(_navigationExceptionSelectors, this._spaConfiguration.navigationExceptionSelectors());
        _navigationExceptionSelectorsString = ListUtil.toString(_navigationExceptionSelectors, (String)null, (String)"");
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }

    private long _getCacheExpirationTime(SPAConfiguration spaConfiguration) {
        long cacheExpirationTime = spaConfiguration.cacheExpirationTime();
        if (cacheExpirationTime > 0L) {
            cacheExpirationTime *= 60000L;
        }
        return cacheExpirationTime;
    }

    static {
        String[] excludedPaths;
        _log = LogFactoryUtil.getLog(SPAHelper.class);
        _navigationExceptionSelectors = new CopyOnWriteArrayList<String>();
        Class<ServletResponseConstants> clazz = ServletResponseConstants.class;
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                jsonArray.put(field.getInt(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        _VALID_STATUS_CODES = jsonArray.toJSONString();
        String portletNamespace = PortalUtil.getPortletNamespace((String)PropsUtil.get((String)"auth.login.portlet.name"));
        _REDIRECT_PARAM_NAME = portletNamespace.concat("redirect");
        jsonArray = JSONFactoryUtil.createJSONArray();
        for (String excludedPath : excludedPaths = StringUtil.split((String)SPAConfigurationUtil.get("spa.excluded.paths"))) {
            jsonArray.put(PortalUtil.getPathContext() + excludedPath);
        }
        _SPA_EXCLUDED_PATHS = jsonArray.toString();
    }

    private static final class NavigationExceptionSelectorTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private final BundleContext _bundleContext;
        private final List<ServiceReference<Object>> _serviceReferences = new CopyOnWriteArrayList<ServiceReference<Object>>();

        public NavigationExceptionSelectorTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public Object addingService(ServiceReference<Object> reference) {
            List selectors = StringPlus.asList((Object)reference.getProperty(SPAHelper._SPA_NAVIGATION_EXCEPTION_SELECTOR_KEY));
            _navigationExceptionSelectors.addAll(selectors);
            _navigationExceptionSelectorsString = ListUtil.toString((List)_navigationExceptionSelectors, (String)null, (String)"");
            Object service = this._bundleContext.getService(reference);
            this._serviceReferences.add(reference);
            return service;
        }

        public void modifiedService(ServiceReference<Object> reference, Object service) {
            this.removedService(reference, service);
            this.addingService(reference);
        }

        public void removedService(ServiceReference<Object> reference, Object service) {
            List selectors = StringPlus.asList((Object)reference.getProperty(SPAHelper._SPA_NAVIGATION_EXCEPTION_SELECTOR_KEY));
            _navigationExceptionSelectors.removeAll(selectors);
            _navigationExceptionSelectorsString = ListUtil.toString((List)_navigationExceptionSelectors, (String)null, (String)"");
            this._serviceReferences.remove(reference);
            this._bundleContext.ungetService(reference);
        }
    }
}

