Liferay.Loader.define("frontend-js-spa-web@4.0.16/liferay/util/Utils.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var MAX_TIMEOUT = Math.pow(2, 31) - 1;
  /**
   * Utils
   *
   * A collection of utilities used by this module
   */

  var Utils = /*#__PURE__*/function () {
    function Utils() {
      _classCallCheck(this, Utils);
    }

    _createClass(Utils, null, [{
      key: "getMaxTimeout",

      /**
       * Returns the maximum number allowed by the `setTimeout` function
       * @return {!Number} The number
       */
      value: function getMaxTimeout() {
        return MAX_TIMEOUT;
      }
      /**
       * Given a portletId, returns the ID of the portlet's boundary DOM element
       * @param  {!String} portletId The portlet ID
       * @return {!String} The portlet boundary ID
       */

    }, {
      key: "getPortletBoundaryId",
      value: function getPortletBoundaryId(portletId) {
        return 'p_p_id_' + portletId + '_';
      }
      /**
       * Given an array of portlet IDs, returns an array of portlet boundary IDs
       * @param  {!Array} The collection of portletIds
       * @return {!Array} The collection of portlet boundary IDs
       */

    }, {
      key: "getPortletBoundaryIds",
      value: function getPortletBoundaryIds(portletIds) {
        return portletIds.map(function (portletId) {
          return Utils.getPortletBoundaryId(portletId);
        });
      }
      /**
       * Destroys all rendered portlets on the page
       */

    }, {
      key: "resetAllPortlets",
      value: function resetAllPortlets() {
        Utils.getPortletBoundaryIds(Liferay.Portlet.list).forEach(function (value) {
          var portlet = document.querySelector('#' + value);

          if (portlet) {
            Liferay.Portlet.destroy(portlet);
            portlet.portletProcessed = false;
          }
        });
        Liferay.Portlet.readyCounter = 0;
        Liferay.destroyComponents(function (component, componentConfig) {
          return componentConfig.destroyOnNavigate;
        });
      }
    }]);

    return Utils;
  }();

  var _default = Utils;
  exports["default"] = _default;
  //# sourceMappingURL=Utils.es.js.map
});
//# sourceMappingURL=Utils.es.js.map