import React from 'react';
interface IContentRowProps extends React.HTMLAttributes<HTMLDivElement> {
    containerElement?: string | React.JSXElementConstructor<{
        className: string;
        [key: string]: any;
    }>;
    float?: boolean | 'sm-down' | 'md-down' | 'end' | 'end-sm-down' | 'end-md-down';
    noGutters?: 'x' | 'y' | true;
    padded?: boolean;
    verticalAlign?: 'center' | 'end';
}
declare const ContentRow: React.ForwardRefExoticComponent<IContentRowProps & React.RefAttributes<HTMLElement>>;
interface IContentColProps extends React.HTMLAttributes<HTMLDivElement> {
    containerElement?: string | React.JSXElementConstructor<{
        className: string;
        [key: string]: any;
    }>;
    expand?: boolean;
    float?: 'end';
    gutters?: boolean;
}
declare const ContentCol: React.ForwardRefExoticComponent<IContentColProps & React.RefAttributes<HTMLElement>>;
interface IColSectionProps extends React.HTMLAttributes<HTMLDivElement> {
    containerElement?: string | React.JSXElementConstructor<{
        className: string;
        [key: string]: any;
    }>;
}
declare const ContentSection: React.ForwardRefExoticComponent<IColSectionProps & React.RefAttributes<HTMLElement>>;
export { ContentCol, ContentRow, ContentSection };
