/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.spa.web.internal.servlet.taglib.helper;

import com.liferay.frontend.js.spa.web.internal.configuration.SPAConfiguration;
import com.liferay.osgi.util.StringPlus;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.servlet.ServletResponseConstants;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.frontend.js.spa.web.internal.configuration.SPAConfiguration"}, service={SPAHelper.class})
public class SPAHelper {
    private static final String _REDIRECT_PARAM_NAME;
    private static final String[] _SPA_DEFAULT_EXCLUDED_PATHS;
    private static final String _SPA_NAVIGATION_EXCEPTION_SELECTOR_KEY = "javascript.single.page.application.navigation.exception.selector";
    private static final JSONArray _VALID_STATUS_CODES_JSON_ARRAY;
    private static final Log _log;
    private static final List<String> _navigationExceptionSelectors;
    private static volatile String _navigationExceptionSelectorsString;
    private volatile long _cacheExpirationTime;
    @Reference
    private JSONFactory _jsonFactory;
    private ServiceTracker<Object, Object> _navigationExceptionSelectorTracker;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    private volatile SPAConfiguration _spaConfiguration;
    private volatile JSONArray _spaExcludedPathsJSONArray;
    private volatile JSONArray _spaExcludedTargetPortletsJSONArray;

    public long getCacheExpirationTime(long companyId) {
        return this._cacheExpirationTime;
    }

    public JSONArray getExcludedPathsJSONArray() {
        return this._spaExcludedPathsJSONArray;
    }

    public JSONArray getExcludedTargetPortletsJSONArray() {
        return this._spaExcludedTargetPortletsJSONArray;
    }

    public ResourceBundle getLanguageResourceBundle(String servletContextName, Locale locale) {
        ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByServletContextName((String)servletContextName);
        if (resourceBundleLoader == null) {
            resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        }
        return resourceBundleLoader.loadResourceBundle(locale);
    }

    public String getLoginRedirect(HttpServletRequest httpServletRequest) {
        return ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)_REDIRECT_PARAM_NAME);
    }

    public String getNavigationExceptionSelectors() {
        return _navigationExceptionSelectorsString;
    }

    public JSONArray getPortletsBlacklistJSONArray(ThemeDisplay themeDisplay) {
        JSONArray portletsBlacklistJSONArray = this._jsonFactory.createJSONArray();
        this._portletLocalService.visitPortlets(themeDisplay.getCompanyId(), portlet -> {
            if (!portlet.isSinglePageApplication() && !portlet.isUndeployedPortlet() && portlet.isActive() && portlet.isReady()) {
                portletsBlacklistJSONArray.put(portlet.getPortletId());
            }
        });
        return portletsBlacklistJSONArray;
    }

    public int getRequestTimeout() {
        return this._spaConfiguration.requestTimeout();
    }

    public int getUserNotificationTimeout() {
        return this._spaConfiguration.userNotificationTimeout();
    }

    public JSONArray getValidStatusCodesJSONArray() {
        return _VALID_STATUS_CODES_JSON_ARRAY;
    }

    public boolean isClearScreensCache(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        boolean singlePageApplicationClearCache = GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE"));
        if (singlePageApplicationClearCache) {
            return true;
        }
        String portletId = httpServletRequest.getParameter("p_p_id");
        if (Validator.isNull((String)portletId)) {
            return false;
        }
        String singlePageApplicationLastPortletId = (String)httpSession.getAttribute("SINGLE_PAGE_APPLICATION_LAST_PORTLET_ID");
        return Validator.isNotNull((String)singlePageApplicationLastPortletId) && !Objects.equals(portletId, singlePageApplicationLastPortletId);
    }

    public boolean isDebugEnabled() {
        return _log.isDebugEnabled();
    }

    public boolean isPreloadCSS() {
        return this._spaConfiguration.preloadCSS();
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws InvalidSyntaxException {
        this._spaConfiguration = (SPAConfiguration)ConfigurableUtil.createConfigurable(SPAConfiguration.class, properties);
        this._cacheExpirationTime = this._getCacheExpirationTime(this._spaConfiguration);
        this._spaExcludedPathsJSONArray = this._getExcludedPathsJSONArray(this._spaConfiguration);
        this._spaExcludedTargetPortletsJSONArray = this._getExcludedTargetPortletsJSONArray();
        Collections.addAll(_navigationExceptionSelectors, this._spaConfiguration.navigationExceptionSelectors());
        _navigationExceptionSelectorsString = ListUtil.toString(_navigationExceptionSelectors, (String)null, (String)"");
        Filter filter = bundleContext.createFilter("(&(objectClass=java.lang.Object)(javascript.single.page.application.navigation.exception.selector=*))");
        this._navigationExceptionSelectorTracker = new ServiceTracker(bundleContext, filter, (ServiceTrackerCustomizer)new NavigationExceptionSelectorTrackerCustomizer(bundleContext));
        this._navigationExceptionSelectorTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._navigationExceptionSelectorTracker.close();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        _navigationExceptionSelectors.removeAll(Arrays.asList(this._spaConfiguration.navigationExceptionSelectors()));
        this._spaConfiguration = (SPAConfiguration)ConfigurableUtil.createConfigurable(SPAConfiguration.class, properties);
        this._cacheExpirationTime = this._getCacheExpirationTime(this._spaConfiguration);
        this._spaExcludedPathsJSONArray = this._getExcludedPathsJSONArray(this._spaConfiguration);
        this._spaExcludedTargetPortletsJSONArray = this._getExcludedTargetPortletsJSONArray();
        Collections.addAll(_navigationExceptionSelectors, this._spaConfiguration.navigationExceptionSelectors());
        _navigationExceptionSelectorsString = ListUtil.toString(_navigationExceptionSelectors, (String)null, (String)"");
    }

    private long _getCacheExpirationTime(SPAConfiguration spaConfiguration) {
        long cacheExpirationTime = spaConfiguration.cacheExpirationTime();
        if (cacheExpirationTime > 0L) {
            cacheExpirationTime *= 60000L;
        }
        return cacheExpirationTime;
    }

    private JSONArray _getExcludedPathsJSONArray(SPAConfiguration spaConfiguration) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (String excludedPath : _SPA_DEFAULT_EXCLUDED_PATHS) {
            jsonArray.put(this._portal.getPathContext() + excludedPath);
        }
        Object[] customExcludedPaths = spaConfiguration.customExcludedPaths();
        if (ArrayUtil.isEmpty((Object[])customExcludedPaths)) {
            return jsonArray;
        }
        for (Object customExcludedPath : customExcludedPaths) {
            jsonArray.put(this._portal.getPathContext() + (String)customExcludedPath);
        }
        return jsonArray;
    }

    private JSONArray _getExcludedTargetPortletsJSONArray() {
        return this._jsonFactory.createJSONArray((Object[])new String[]{"com_liferay_users_admin_web_portlet_UsersAdminPortlet", "com_liferay_server_admin_web_portlet_ServerAdminPortlet"});
    }

    static {
        _SPA_DEFAULT_EXCLUDED_PATHS = new String[]{"/c/document_library", "/documents", "/image"};
        _log = LogFactoryUtil.getLog(SPAHelper.class);
        _navigationExceptionSelectors = new CopyOnWriteArrayList<String>();
        Class<ServletResponseConstants> clazz = ServletResponseConstants.class;
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                jsonArray.put(field.getInt(null));
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
        }
        _VALID_STATUS_CODES_JSON_ARRAY = jsonArray;
        String portletNamespace = PortalUtil.getPortletNamespace((String)PropsUtil.get((String)"auth.login.portlet.name"));
        _REDIRECT_PARAM_NAME = portletNamespace.concat("redirect");
    }

    private static final class NavigationExceptionSelectorTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private final BundleContext _bundleContext;
        private final List<ServiceReference<Object>> _serviceReferences = new CopyOnWriteArrayList<ServiceReference<Object>>();

        public NavigationExceptionSelectorTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        public Object addingService(ServiceReference<Object> serviceReference) {
            List selectors = StringPlus.asList((Object)serviceReference.getProperty(SPAHelper._SPA_NAVIGATION_EXCEPTION_SELECTOR_KEY));
            _navigationExceptionSelectors.addAll(selectors);
            _navigationExceptionSelectorsString = ListUtil.toString((List)_navigationExceptionSelectors, (String)null, (String)"");
            Object service = this._bundleContext.getService(serviceReference);
            this._serviceReferences.add(serviceReference);
            return service;
        }

        public void modifiedService(ServiceReference<Object> serviceReference, Object service) {
            this.removedService(serviceReference, service);
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<Object> serviceReference, Object service) {
            List selectors = StringPlus.asList((Object)serviceReference.getProperty(SPAHelper._SPA_NAVIGATION_EXCEPTION_SELECTOR_KEY));
            _navigationExceptionSelectors.removeAll(selectors);
            _navigationExceptionSelectorsString = ListUtil.toString((List)_navigationExceptionSelectors, (String)null, (String)"");
            this._serviceReferences.remove(serviceReference);
            this._bundleContext.ungetService(serviceReference);
        }
    }
}

